# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin MODULE IMPORTED)

set(_Qt5QQuickWidgetPlugin_MODULE_DEPENDENCIES "Designer;QuickWidgets;Widgets;Gui;Core")

foreach(_module_dep ${_Qt5QQuickWidgetPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Designer_FIND_VERSION_EXACT}
            ${_Qt5Designer_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Designer_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Designer_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Designer ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin QQuickWidgetPlugin RELEASE "designer/libqquickwidget.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Designer_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Designer APPEND PROPERTY QT_ALL_PLUGINS_designer ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin PROPERTY QT_PLUGIN_TYPE "designer")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQuickWidgetPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QQuickWidgetPlugin")
endif()
