# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin MODULE IMPORTED)

set(_Qt5QSvgIconPlugin_MODULE_DEPENDENCIES "Svg;Gui;Gui;Core;Core")

foreach(_module_dep ${_Qt5QSvgIconPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Gui_FIND_VERSION_EXACT}
            ${_Qt5Gui_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Gui_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Gui_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Gui ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin QSvgIconPlugin RELEASE "iconengines/libqsvgicon.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Gui_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Gui APPEND PROPERTY QT_ALL_PLUGINS_iconengines ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin PROPERTY QT_PLUGIN_TYPE "iconengines")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin PROPERTY QT_PLUGIN_EXTENDS "Qt::Svg")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgIconPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QSvgIconPlugin")
endif()
