# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin MODULE IMPORTED)

set(_Qt5QShakeSensorGesturePlugin_MODULE_DEPENDENCIES "Sensors;Core")

foreach(_module_dep ${_Qt5QShakeSensorGesturePlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Sensors_FIND_VERSION_EXACT}
            ${_Qt5Sensors_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Sensors_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Sensors_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Sensors ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin QShakeSensorGesturePlugin RELEASE "sensorgestures/libqtsensorgestures_shakeplugin.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Sensors_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Sensors APPEND PROPERTY QT_ALL_PLUGINS_sensorgestures ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin PROPERTY QT_PLUGIN_TYPE "sensorgestures")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin PROPERTY QT_PLUGIN_EXTENDS "-")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QShakeSensorGesturePlugin PROPERTY QT_PLUGIN_CLASS_NAME "QShakeSensorGesturePlugin")
endif()
