if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 RepParser module requires at least CMake version 3.1.0")
endif()

# redirect to static package overriding variant prefix so it does not contain Static anymore
option(USE_STATIC_QT_BY_DEFAULT "specifies whether to use static Qt by default (rather than via Static-prefix)" OFF)
if(USE_STATIC_QT_BY_DEFAULT)
    set(ORIGINAL_OVERRIDE_QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    if(OVERRIDE_QT_VARIANT_PREFIX)
        string(REPLACE "Static" "" OVERRIDE_QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    endif()
    if(NOT OVERRIDE_QT_VARIANT_PREFIX)
        set(OVERRIDE_QT_VARIANT_PREFIX none)
    endif()
    find_package(StaticQt5RepParser)
    set(OVERRIDE_QT_VARIANT_PREFIX ${ORIGINAL_OVERRIDE_QT_VARIANT_PREFIX})
    return()
endif()

if(OVERRIDE_QT_VARIANT_PREFIX)
    if(OVERRIDE_QT_VARIANT_PREFIX STREQUAL none)
        unset(QT_VARIANT_PREFIX)
    else()
        set(QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    endif()
else()
    set(QT_VARIANT_PREFIX "")
endif()

get_filename_component(_qt5RepParser_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)


macro(_qt5_RepParser_check_file_exists FILE)
    if(NOT EXISTS "${FILE}")
        message(FATAL_ERROR "The imported target \"${QT_VARIANT_PREFIX}Qt5::RepParser\" references the file
   \"${FILE}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()



if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::RepParser)
    set(_Qt5RepParser_OWN_INCLUDE_DIRS "${_qt5RepParser_install_prefix}/include/qt/" "${_qt5RepParser_install_prefix}/include/qt/QtRepParser")
    set(${QT_VARIANT_PREFIX}Qt5RepParser_PRIVATE_INCLUDE_DIRS "")

    foreach(_dir ${_Qt5RepParser_OWN_INCLUDE_DIRS})
        _qt5_RepParser_check_file_exists(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt5RepParser_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt5RepParser_PRIVATE_INCLUDE_DIRS})
            _qt5_RepParser_check_file_exists(${_dir})
        endforeach()
    endif()

    set(_Qt5RepParser_MODULE_DEPENDENCIES "Core")


    set(${QT_VARIANT_PREFIX}Qt5RepParser_OWN_PRIVATE_INCLUDE_DIRS ${Qt5RepParser_PRIVATE_INCLUDE_DIRS})

    set(_Qt5RepParser_FIND_DEPENDENCIES_REQUIRED)
    if (${QT_VARIANT_PREFIX}Qt5RepParser_FIND_REQUIRED)
        set(_Qt5RepParser_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5RepParser_FIND_DEPENDENCIES_QUIET)
    if (Qt5RepParser_FIND_QUIETLY)
        set(_Qt5RepParser_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5RepParser_FIND_VERSION_EXACT)
    if (${QT_VARIANT_PREFIX}Qt5RepParser_FIND_VERSION_EXACT)
        set(_Qt5RepParser_FIND_VERSION_EXACT EXACT)
    endif()


    foreach(_module_dep ${_Qt5RepParser_MODULE_DEPENDENCIES})
        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
                5.15.18 ${_Qt5RepParser_FIND_VERSION_EXACT}
                ${_Qt5RepParser_DEPENDENCIES_FIND_QUIET}
                ${_Qt5RepParser_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            set(${QT_VARIANT_PREFIX}Qt5RepParser_FOUND False)
            return()
        endif()

    endforeach()

    # It can happen that the same FooConfig.cmake file is included when calling find_package()
    # on some Qt component. An example of that is when using a Qt static build with auto inclusion
    # of plugins:
    #
    # Qt5WidgetsConfig.cmake -> Qt5GuiConfig.cmake -> Qt5Gui_QSvgIconPlugin.cmake ->
    # Qt5SvgConfig.cmake -> Qt5WidgetsConfig.cmake ->
    # finish processing of second Qt5WidgetsConfig.cmake ->
    # return to first Qt5WidgetsConfig.cmake ->
    # add_library cannot create imported target Qt5::Widgets.
    #
    # Make sure to return early in the original Config inclusion, because the target has already
    # been defined as part of the second inclusion.
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::RepParser)
    if(TARGET ${TARGET_NAME})
        return()
    endif()

    set(_Qt5RepParser_LIB_DEPENDENCIES "${QT_VARIANT_PREFIX}Qt5::Core")


    add_library(${TARGET_NAME} INTERFACE IMPORTED)



    set_property(TARGET ${TARGET_NAME} PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5RepParser_OWN_INCLUDE_DIRS})
    set_property(TARGET ${TARGET_NAME} PROPERTY
        INTERFACE_COMPILE_DEFINITIONS QT_REPPARSER_LIB)

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_ENABLED_FEATURES )
    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    # Qt 6 forward compatible properties.
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY INTERFACE_QT_ENABLED_PUBLIC_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY INTERFACE_QT_DISABLED_PUBLIC_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY INTERFACE_QT_ENABLED_PRIVATE_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY INTERFACE_QT_DISABLED_PRIVATE_FEATURES
                 )

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_PLUGIN_TYPES "")

    # Find plugin targets
    file(GLOB pluginTargetsMaybe "${CMAKE_CURRENT_LIST_DIR}/*Qt5RepParser_*.cmake")
    unset(pluginTargets)
    if(pluginTargetsMaybe)
        foreach(pluginTarget ${pluginTargetsMaybe})
            file(STRINGS ${pluginTarget} matched REGEX Qt5RepParser_PLUGINS)
            if(matched)
                list(APPEND pluginTargets ${pluginTarget})
            endif()
        endforeach()
    endif()

    macro(_populate_RepParser_plugin_properties TARGET_NAME PLUGIN_TARGET_NAME PLUGIN_NAME CONFIG PLUGIN_LOCATION)
        set_property(TARGET ${PLUGIN_TARGET_NAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${CONFIG})

        set(imported_location "${_qt5RepParser_install_prefix}/lib/qt/plugins/${PLUGIN_LOCATION}")
        _qt5_RepParser_check_file_exists(${imported_location})
        set_target_properties(${PLUGIN_TARGET_NAME} PROPERTIES
            "IMPORTED_LOCATION_${CONFIG}" ${imported_location}
        )

    endmacro()

    if(pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()

    # set TARGET_NAME back to current module (when loading plugin targets other modules might have been loaded in the meantime)
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::RepParser)

    set(_Qt5RepParser_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5RepParser_PRIVATE_DIR ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5RepParser_PRIVATE_DIR})
            set(_Qt5RepParser_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5RepParser_PRIVATE_DIRS_EXIST)
        add_library(${TARGET_NAME}Private INTERFACE IMPORTED)
        set_property(TARGET ${TARGET_NAME}Private PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5RepParser_PRIVATEDEPS)
        foreach(dep ${_Qt5RepParser_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5RepParser_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET ${TARGET_NAME}Private PROPERTY
            INTERFACE_LINK_LIBRARIES ${TARGET_NAME} ${_Qt5RepParser_PRIVATEDEPS}
        )

        # Add a versionless target, for compatibility with Qt6.
        if(NOT "${QT_NO_CREATE_VERSIONLESS_TARGETS}" AND NOT TARGET ${QT_VARIANT_PREFIX}Qt::RepParserPrivate)
            add_library(${QT_VARIANT_PREFIX}Qt::RepParserPrivate INTERFACE IMPORTED)
            set_target_properties(${QT_VARIANT_PREFIX}Qt::RepParserPrivate PROPERTIES
                INTERFACE_LINK_LIBRARIES "${TARGET_NAME}Private"
            )
        endif()
    endif()

    set_target_properties(${TARGET_NAME} PROPERTIES
        INTERFACE_LINK_LIBRARIES "${_Qt5RepParser_LIB_DEPENDENCIES}"
    )


    _qt5_RepParser_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/../${QT_VARIANT_PREFIX}Qt5RepParser/${QT_VARIANT_PREFIX}Qt5RepParserConfigVersion.cmake")
endif()

# Add a versionless target, for compatibility with Qt6.
if(NOT "${QT_NO_CREATE_VERSIONLESS_TARGETS}" AND TARGET ${QT_VARIANT_PREFIX}Qt5::RepParser AND NOT TARGET ${QT_VARIANT_PREFIX}Qt::RepParser)
    add_library(${QT_VARIANT_PREFIX}Qt::RepParser INTERFACE IMPORTED)
    set_target_properties(${QT_VARIANT_PREFIX}Qt::RepParser PROPERTIES
        INTERFACE_LINK_LIBRARIES "${QT_VARIANT_PREFIX}Qt5::RepParser"
    )
endif()
