# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::DSServicePlugin MODULE IMPORTED)

set(_Qt5DSServicePlugin_MODULE_DEPENDENCIES "Multimedia;Gui;Widgets;Gui;Core;Core")

foreach(_module_dep ${_Qt5DSServicePlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Multimedia_FIND_VERSION_EXACT}
            ${_Qt5Multimedia_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Multimedia_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Multimedia_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Multimedia ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin DSServicePlugin RELEASE "mediaservice/libdsengine.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Multimedia_PLUGINS ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Multimedia APPEND PROPERTY QT_ALL_PLUGINS_mediaservice ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin PROPERTY QT_PLUGIN_TYPE "mediaservice")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::DSServicePlugin PROPERTY QT_PLUGIN_CLASS_NAME "DSServicePlugin")
endif()
