# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin MODULE IMPORTED)

set(_Qt5AudioCaptureServicePlugin_MODULE_DEPENDENCIES "Multimedia;Gui;Core")

foreach(_module_dep ${_Qt5AudioCaptureServicePlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Multimedia_FIND_VERSION_EXACT}
            ${_Qt5Multimedia_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Multimedia_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Multimedia_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Multimedia ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin AudioCaptureServicePlugin RELEASE "mediaservice/libqtmedia_audioengine.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Multimedia_PLUGINS ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Multimedia APPEND PROPERTY QT_ALL_PLUGINS_mediaservice ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin PROPERTY QT_PLUGIN_TYPE "mediaservice")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::AudioCaptureServicePlugin PROPERTY QT_PLUGIN_CLASS_NAME "AudioCaptureServicePlugin")
endif()
