# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll)
    add_library(${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll MODULE IMPORTED)

set(_Qt5QGeoPositionInfoSourceFactoryPoll_MODULE_DEPENDENCIES "Positioning;Core")

foreach(_module_dep ${_Qt5QGeoPositionInfoSourceFactoryPoll_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Positioning_FIND_VERSION_EXACT}
            ${_Qt5Positioning_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Positioning_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Positioning_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Positioning ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll QGeoPositionInfoSourceFactoryPoll RELEASE "position/libqtposition_positionpoll.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Positioning_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Positioning APPEND PROPERTY QT_ALL_PLUGINS_position ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll PROPERTY QT_PLUGIN_TYPE "position")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoPositionInfoSourceFactoryPoll PROPERTY QT_PLUGIN_CLASS_NAME "QGeoPositionInfoSourceFactoryPoll")
endif()
