# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin MODULE IMPORTED)

set(_Qt5QXInputGamepadBackendPlugin_MODULE_DEPENDENCIES "Gamepad;Gamepad;Gui;Core")

foreach(_module_dep ${_Qt5QXInputGamepadBackendPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Gamepad_FIND_VERSION_EXACT}
            ${_Qt5Gamepad_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Gamepad_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Gamepad_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Gamepad ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin QXInputGamepadBackendPlugin RELEASE "gamepads/libxinputgamepad.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Gamepad_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Gamepad APPEND PROPERTY QT_ALL_PLUGINS_gamepads ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin PROPERTY QT_PLUGIN_TYPE "gamepads")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QXInputGamepadBackendPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QXInputGamepadBackendPlugin")
endif()
