# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory)
    add_library(${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory MODULE IMPORTED)

set(_Qt5QTcpServerConnectionFactory_MODULE_DEPENDENCIES "Qml;Network")

foreach(_module_dep ${_Qt5QTcpServerConnectionFactory_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Qml_FIND_VERSION_EXACT}
            ${_Qt5Qml_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Qml_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Qml_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Qml ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory QTcpServerConnectionFactory RELEASE "qmltooling/libqmldbg_tcp.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Qml APPEND PROPERTY QT_ALL_PLUGINS_qmltooling ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory PROPERTY QT_PLUGIN_TYPE "qmltooling")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QTcpServerConnectionFactory PROPERTY QT_PLUGIN_CLASS_NAME "QTcpServerConnectionFactory")
endif()
