# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory)
    add_library(${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory MODULE IMPORTED)

set(_Qt5QQmlPreviewServiceFactory_MODULE_DEPENDENCIES "Quick;Qml;PacketProtocol;Gui;Gui;Core;Network;Core")

foreach(_module_dep ${_Qt5QQmlPreviewServiceFactory_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Qml_FIND_VERSION_EXACT}
            ${_Qt5Qml_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Qml_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Qml_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Qml ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory QQmlPreviewServiceFactory RELEASE "qmltooling/libqmldbg_preview.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Qml APPEND PROPERTY QT_ALL_PLUGINS_qmltooling ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory PROPERTY QT_PLUGIN_TYPE "qmltooling")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlPreviewServiceFactory PROPERTY QT_PLUGIN_CLASS_NAME "QQmlPreviewServiceFactory")
endif()
