if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 Qml module requires at least CMake version 3.1.0")
endif()

# redirect to static package overriding variant prefix so it does not contain Static anymore
option(USE_STATIC_QT_BY_DEFAULT "specifies whether to use static Qt by default (rather than via Static-prefix)" OFF)
if(USE_STATIC_QT_BY_DEFAULT)
    set(ORIGINAL_OVERRIDE_QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    if(OVERRIDE_QT_VARIANT_PREFIX)
        string(REPLACE "Static" "" OVERRIDE_QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    endif()
    if(NOT OVERRIDE_QT_VARIANT_PREFIX)
        set(OVERRIDE_QT_VARIANT_PREFIX none)
    endif()
    find_package(StaticQt5Qml)
    set(OVERRIDE_QT_VARIANT_PREFIX ${ORIGINAL_OVERRIDE_QT_VARIANT_PREFIX})
    return()
endif()

if(OVERRIDE_QT_VARIANT_PREFIX)
    if(OVERRIDE_QT_VARIANT_PREFIX STREQUAL none)
        unset(QT_VARIANT_PREFIX)
    else()
        set(QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    endif()
else()
    set(QT_VARIANT_PREFIX "")
endif()

get_filename_component(_qt5Qml_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt5Qml_VERSION instead.
set(${QT_VARIANT_PREFIX}Qt5Qml_VERSION_STRING 5.15.17)

set(${QT_VARIANT_PREFIX}Qt5Qml_LIBRARIES ${QT_VARIANT_PREFIX}Qt5::Qml)

macro(_qt5_Qml_check_file_exists FILE)
    if(NOT EXISTS "${FILE}")
        message(FATAL_ERROR "The imported target \"${QT_VARIANT_PREFIX}Qt5::Qml\" references the file
   \"${FILE}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()


macro(_populate_Qml_target_properties TARGET_NAME Configuration LIB_LOCATION IMPLIB_LOCATION
      IsDebugAndRelease)
    set_property(TARGET ${TARGET_NAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt5Qml_install_prefix}/bin/${LIB_LOCATION}")
    _qt5_Qml_check_file_exists(${imported_location})
    set(_deps
        ${_Qt5Qml_LIB_DEPENDENCIES}
    )

    # FIXME: handle IsDebugAndRelease like in official version

    set_target_properties("${TARGET_NAME}" PROPERTIES
        "INTERFACE_LINK_LIBRARIES_${Configuration}" "${_deps}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_deps}"
    )

    set(imported_implib "${_qt5Qml_install_prefix}/lib/${IMPLIB_LOCATION}")
    _qt5_Qml_check_file_exists(${imported_implib})
    if(NOT "${IMPLIB_LOCATION}" STREQUAL "")
        set_target_properties(${QT_VARIANT_PREFIX}Qt5::Qml PROPERTIES
        "IMPORTED_IMPLIB_${Configuration}" ${imported_implib}
        )
    endif()
endmacro()

macro(_populate_Qml_plugin_target_dependencies_from_prl_file PLUGIN_TARGET_NAME PRL_FILE_LOCATION CONFIGURATION LIB_DIRECTORY LIB_LOCATION)
    _qt5_Qml_process_prl_file(
        "${PRL_FILE_LOCATION}"
        "${CONFIGURATION}"
        _Qt5Qml_STATIC_PLUGIN_${CONFIGURATION}_LIB_DEPENDENCIES
        _Qt5Qml_STATIC_PLUGIN_${CONFIGURATION}_LINK_FLAGS)
    _qt5_add_dependencies("${PLUGIN_TARGET_NAME}" ALL "${_Qt5Qml_STATIC_PLUGIN_${CONFIGURATION}_LIB_DEPENDENCIES}")
endmacro()

if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::Qml)
    set(_Qt5Qml_OWN_INCLUDE_DIRS "${_qt5Qml_install_prefix}/include/qt/" "${_qt5Qml_install_prefix}/include/qt/QtQml")
    set(${QT_VARIANT_PREFIX}Qt5Qml_PRIVATE_INCLUDE_DIRS
        "${_qt5Qml_install_prefix}/include/qt/QtQml/5.15.17"
        "${_qt5Qml_install_prefix}/include/qt/QtQml/5.15.17/QtQml"
    )

    foreach(_dir ${_Qt5Qml_OWN_INCLUDE_DIRS})
        _qt5_Qml_check_file_exists(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt5Qml_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt5Qml_PRIVATE_INCLUDE_DIRS})
            _qt5_Qml_check_file_exists(${_dir})
        endforeach()
    endif()

    set(${QT_VARIANT_PREFIX}Qt5Qml_INCLUDE_DIRS ${_Qt5Qml_OWN_INCLUDE_DIRS})

    set(${QT_VARIANT_PREFIX}Qt5Qml_DEFINITIONS -DQT_QML_LIB)
    set(${QT_VARIANT_PREFIX}Qt5Qml_COMPILE_DEFINITIONS QT_QML_LIB)
    set(_Qt5Qml_MODULE_DEPENDENCIES "Network;Core")


    set(${QT_VARIANT_PREFIX}Qt5Qml_OWN_PRIVATE_INCLUDE_DIRS ${Qt5Qml_PRIVATE_INCLUDE_DIRS})

    set(_Qt5Qml_FIND_DEPENDENCIES_REQUIRED)
    if (${QT_VARIANT_PREFIX}Qt5Qml_FIND_REQUIRED)
        set(_Qt5Qml_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5Qml_FIND_DEPENDENCIES_QUIET)
    if (Qt5Qml_FIND_QUIETLY)
        set(_Qt5Qml_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5Qml_FIND_VERSION_EXACT)
    if (${QT_VARIANT_PREFIX}Qt5Qml_FIND_VERSION_EXACT)
        set(_Qt5Qml_FIND_VERSION_EXACT EXACT)
    endif()

    set(${QT_VARIANT_PREFIX}Qt5Qml_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt5Qml_MODULE_DEPENDENCIES})
        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
                5.15.17 ${_Qt5Qml_FIND_VERSION_EXACT}
                ${_Qt5Qml_DEPENDENCIES_FIND_QUIET}
                ${_Qt5Qml_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            set(${QT_VARIANT_PREFIX}Qt5Qml_FOUND False)
            return()
        endif()

        list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt5Qml_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt5Qml_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt5Qml_DEFINITIONS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt5Qml_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt5Qml_EXECUTABLE_COMPILE_FLAGS)

    # It can happen that the same FooConfig.cmake file is included when calling find_package()
    # on some Qt component. An example of that is when using a Qt static build with auto inclusion
    # of plugins:
    #
    # Qt5WidgetsConfig.cmake -> Qt5GuiConfig.cmake -> Qt5Gui_QSvgIconPlugin.cmake ->
    # Qt5SvgConfig.cmake -> Qt5WidgetsConfig.cmake ->
    # finish processing of second Qt5WidgetsConfig.cmake ->
    # return to first Qt5WidgetsConfig.cmake ->
    # add_library cannot create imported target Qt5::Widgets.
    #
    # Make sure to return early in the original Config inclusion, because the target has already
    # been defined as part of the second inclusion.
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::Qml)
    if(TARGET ${TARGET_NAME})
        return()
    endif()

    set(_Qt5Qml_LIB_DEPENDENCIES "${QT_VARIANT_PREFIX}Qt5::Network;${QT_VARIANT_PREFIX}Qt5::Core")


    add_library(${TARGET_NAME} SHARED IMPORTED)



    set_property(TARGET ${TARGET_NAME} PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5Qml_OWN_INCLUDE_DIRS})
    set_property(TARGET ${TARGET_NAME} PROPERTY
        INTERFACE_COMPILE_DEFINITIONS QT_QML_LIB)

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_ENABLED_FEATURES qml-debug;qml-network)
    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    # Qt 6 forward compatible properties.
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_ENABLED_PUBLIC_FEATURES
                 qml-debug;qml-network)
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_DISABLED_PUBLIC_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_ENABLED_PRIVATE_FEATURES
                 cxx14_make_unique;qml-animation;qml-devtools;qml-itemmodel;qml-jit;qml-locale;qml-preview;qml-profiler;qml-python;qml-sequence-object;qml-worker-script;qml-xml-http-request)
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_DISABLED_PRIVATE_FEATURES
                 )

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_PLUGIN_TYPES "qmltooling")

    # Find plugin targets
    file(GLOB pluginTargetsMaybe "${CMAKE_CURRENT_LIST_DIR}/*Qt5Qml_*.cmake")
    unset(pluginTargets)
    if(pluginTargetsMaybe)
        foreach(pluginTarget ${pluginTargetsMaybe})
            file(STRINGS ${pluginTarget} matched REGEX Qt5Qml_PLUGINS)
            if(matched)
                list(APPEND pluginTargets ${pluginTarget})
            endif()
        endforeach()
    endif()

    macro(_populate_Qml_plugin_properties TARGET_NAME PLUGIN_TARGET_NAME PLUGIN_NAME CONFIG PLUGIN_LOCATION)
        set_property(TARGET ${PLUGIN_TARGET_NAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${CONFIG})

        set(imported_location "${_qt5Qml_install_prefix}/lib/qt/plugins/${PLUGIN_LOCATION}")
        _qt5_Qml_check_file_exists(${imported_location})
        set_target_properties(${PLUGIN_TARGET_NAME} PROPERTIES
            "IMPORTED_LOCATION_${CONFIG}" ${imported_location}
        )

    endmacro()

    if(pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()

    # set TARGET_NAME back to current module (when loading plugin targets other modules might have been loaded in the meantime)
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::Qml)

    set(_Qt5Qml_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5Qml_PRIVATE_DIR ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5Qml_PRIVATE_DIR})
            set(_Qt5Qml_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5Qml_PRIVATE_DIRS_EXIST)
        add_library(${TARGET_NAME}Private INTERFACE IMPORTED)
        set_property(TARGET ${TARGET_NAME}Private PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5Qml_PRIVATEDEPS)
        foreach(dep ${_Qt5Qml_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5Qml_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET ${TARGET_NAME}Private PROPERTY
            INTERFACE_LINK_LIBRARIES ${TARGET_NAME} ${_Qt5Qml_PRIVATEDEPS}
        )

        # Add a versionless target, for compatibility with Qt6.
        if(NOT "${QT_NO_CREATE_VERSIONLESS_TARGETS}" AND NOT TARGET ${QT_VARIANT_PREFIX}Qt::QmlPrivate)
            add_library(${QT_VARIANT_PREFIX}Qt::QmlPrivate INTERFACE IMPORTED)
            set_target_properties(${QT_VARIANT_PREFIX}Qt::QmlPrivate PROPERTIES
                INTERFACE_LINK_LIBRARIES "${TARGET_NAME}Private"
            )
        endif()
    endif()

    _populate_Qml_target_properties(${TARGET_NAME} RELEASE "Qt5Qml.dll" "libQt5Qml.dll.a" FALSE)


    if (EXISTS
        "${_qt5Qml_install_prefix}/bin/Qt5Qml.dll"
    AND EXISTS
        "${_qt5Qml_install_prefix}/lib/libQt5Qml.dll.a" )
        _populate_Qml_target_properties(${TARGET_NAME} DEBUG "Qt5Qml.dll" "libQt5Qml.dll.a" FALSE)
    endif()


    include("${CMAKE_CURRENT_LIST_DIR}/../${QT_VARIANT_PREFIX}Qt5Qml/${QT_VARIANT_PREFIX}Qt5QmlConfigExtras.cmake")

    _qt5_Qml_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/../${QT_VARIANT_PREFIX}Qt5Qml/${QT_VARIANT_PREFIX}Qt5QmlConfigVersion.cmake")
endif()

# Add a versionless target, for compatibility with Qt6.
if(NOT "${QT_NO_CREATE_VERSIONLESS_TARGETS}" AND TARGET ${QT_VARIANT_PREFIX}Qt5::Qml AND NOT TARGET ${QT_VARIANT_PREFIX}Qt::Qml)
    add_library(${QT_VARIANT_PREFIX}Qt::Qml INTERFACE IMPORTED)
    set_target_properties(${QT_VARIANT_PREFIX}Qt::Qml PROPERTIES
        INTERFACE_LINK_LIBRARIES "${QT_VARIANT_PREFIX}Qt5::Qml"
    )
endif()
