# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin MODULE IMPORTED)

set(_Qt5QWindowsPrinterSupportPlugin_MODULE_DEPENDENCIES "PrintSupport;Gui;Gui;Core;Core")

foreach(_module_dep ${_Qt5QWindowsPrinterSupportPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5PrintSupport_FIND_VERSION_EXACT}
            ${_Qt5PrintSupport_DEPENDENCIES_FIND_QUIET}
            ${_Qt5PrintSupport_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_PrintSupport_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::PrintSupport ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin QWindowsPrinterSupportPlugin RELEASE "printsupport/libwindowsprintersupport.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5PrintSupport_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::PrintSupport APPEND PROPERTY QT_ALL_PLUGINS_printsupport ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin PROPERTY QT_PLUGIN_TYPE "printsupport")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsPrinterSupportPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QWindowsPrinterSupportPlugin")
endif()
