# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin MODULE IMPORTED)

set(_Qt5QGenericEnginePlugin_MODULE_DEPENDENCIES "Network;Core")

foreach(_module_dep ${_Qt5QGenericEnginePlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Network_FIND_VERSION_EXACT}
            ${_Qt5Network_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Network_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Network_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Network ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin QGenericEnginePlugin RELEASE "bearer/libqgenericbearer.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Network_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Network APPEND PROPERTY QT_ALL_PLUGINS_bearer ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin PROPERTY QT_PLUGIN_TYPE "bearer")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGenericEnginePlugin PROPERTY QT_PLUGIN_CLASS_NAME "QGenericEnginePlugin")
endif()
