# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin MODULE IMPORTED)

set(_Qt5QMYSQLDriverPlugin_MODULE_DEPENDENCIES "Sql;Core;Core")

foreach(_module_dep ${_Qt5QMYSQLDriverPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Sql_FIND_VERSION_EXACT}
            ${_Qt5Sql_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Sql_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Sql_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Sql ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin QMYSQLDriverPlugin RELEASE "sqldrivers/libqsqlmysql.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Sql_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Sql APPEND PROPERTY QT_ALL_PLUGINS_sqldrivers ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin PROPERTY QT_PLUGIN_TYPE "sqldrivers")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QMYSQLDriverPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QMYSQLDriverPlugin")
endif()
