# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin MODULE IMPORTED)

set(_Qt5OpenGLRendererPlugin_MODULE_DEPENDENCIES "3DRender;3DCore;3DRender;3DCore;Gui;OpenGLExtensions;Gui;Core;Core")

foreach(_module_dep ${_Qt5OpenGLRendererPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt53DRender_FIND_VERSION_EXACT}
            ${_Qt53DRender_DEPENDENCIES_FIND_QUIET}
            ${_Qt53DRender_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_3DRender_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::3DRender ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin OpenGLRendererPlugin RELEASE "renderers/libopenglrenderer.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt53DRender_PLUGINS ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::3DRender APPEND PROPERTY QT_ALL_PLUGINS_renderers ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin PROPERTY QT_PLUGIN_TYPE "renderers")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::OpenGLRendererPlugin PROPERTY QT_PLUGIN_CLASS_NAME "OpenGLRendererPlugin")
endif()
