if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 3DAnimation module requires at least CMake version 3.1.0")
endif()


if(OVERRIDE_QT_VARIANT_PREFIX)
    if(OVERRIDE_QT_VARIANT_PREFIX STREQUAL none)
        unset(QT_VARIANT_PREFIX)
    else()
        set(QT_VARIANT_PREFIX ${OVERRIDE_QT_VARIANT_PREFIX})
    endif()
else()
    set(QT_VARIANT_PREFIX "Static")
endif()

get_filename_component(_qt53DAnimation_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt53DAnimation_VERSION instead.
set(${QT_VARIANT_PREFIX}Qt53DAnimation_VERSION_STRING 5.15.17)

set(${QT_VARIANT_PREFIX}Qt53DAnimation_LIBRARIES ${QT_VARIANT_PREFIX}Qt5::3DAnimation)

macro(_qt5_3DAnimation_check_file_exists_static FILE)
    if(NOT EXISTS "${FILE}")
        message(FATAL_ERROR "The imported target \"${QT_VARIANT_PREFIX}Qt5::3DAnimation\" references the file
   \"${FILE}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()

function(_qt5_3DAnimation_process_prl_file prl_file_location Configuration lib_deps link_flags)
    set(_lib_deps)
    set(_link_flags)

    # prefer static libs
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib)
    set(CMAKE_FIND_LIBRARY_PREFIXES lib "")

    set(_qt5_install_libs "${_qt53DAnimation_install_prefix}/lib/")

    if(EXISTS "${prl_file_location}")
        file(STRINGS "${prl_file_location}" _prl_strings REGEX "QMAKE_PRL_LIBS_FOR_CMAKE[ \t]*=")
        if(NOT _prl_strings)
            message(WARNING "Prl file for Qt 5 module 3DAnimation does not contain QMAKE_PRL_LIBS_FOR_CMAKE. Was looking at \"${prl_file_location}\".")
            return()
        endif()

        # file(STRINGS) replaces all semicolons read from the file with backslash semicolons.
        # We need to do a reverse transformation in CMake. For that we replace all backslash
        # semicolons with just semicolons, but due to the qmake substitution feature
        # creating this file, we need to double the amount of backslashes, so the final file
        # should have three backslashes and one semicolon.
        string(REGEX REPLACE "\\\;" ";" _prl_strings "${_prl_strings}")

        string(REGEX REPLACE "QMAKE_PRL_LIBS_FOR_CMAKE[ \t]*=[ \t]*([^\n]*)" "\\1" _static_depends "${_prl_strings}")
        string(REGEX REPLACE "[ \t]+" ";" _standard_libraries "${CMAKE_CXX_STANDARD_LIBRARIES}")
        set(_search_paths)
        set(_fw_search_paths)
        set(_framework_flag)
        string(REPLACE "\$\$[QT_INSTALL_LIBS]" "${_qt5_install_libs}" _static_depends "${_static_depends}")
        foreach(_flag ${_static_depends})
            string(REPLACE "\"" "" _flag ${_flag})
            if(_flag MATCHES "^-framework$")
                # Handle the next flag as framework name
                set(_framework_flag 1)
            elseif(_flag MATCHES "^-F(.*)$")
                # Handle -F/foo/bar flags by recording the framework search paths to be used
                # by find_library.
                list(APPEND _fw_search_paths "${CMAKE_MATCH_1}")
            elseif(_framework_flag OR _flag MATCHES "^-l(.*)$")
                if(_framework_flag)
                    # Handle Darwin framework bundles passed as -framework Foo
                    set(_lib ${_flag})
                else()
                    # Handle normal libraries passed as -lfoo
                    set(_lib "${CMAKE_MATCH_1}")
                    foreach(_standard_library ${_standard_libraries})
                        if(_standard_library MATCHES "^${_lib}(\\.lib|\\.a)?$")
                            set(_lib_is_default_linked TRUE)
                            break()
                        endif()
                    endforeach()
                endif()
                if (_lib_is_default_linked)
                    unset(_lib_is_default_linked)
                elseif(_lib MATCHES "^pthread$")
                    find_package(Threads REQUIRED)
                    list(APPEND _lib_deps Threads::Threads)
                else()
                    set(current_search_paths "${_search_paths}")
                    if(_framework_flag)
                        set(current_search_paths "${_fw_search_paths}")
                    endif()
                    if(current_search_paths)
                        find_library(_Qt53DAnimation_${Configuration}_${_lib}_PATH ${_lib} HINTS ${current_search_paths} NO_DEFAULT_PATH)
                    endif()
                    find_library(_Qt53DAnimation_${Configuration}_${_lib}_PATH ${_lib} HINTS ${CMAKE_CXX_IMPLICIT_LINK_DIRECTORIES})
                    mark_as_advanced(_Qt53DAnimation_${Configuration}_${_lib}_PATH)
                    if(_Qt53DAnimation_${Configuration}_${_lib}_PATH)
                        list(APPEND _lib_deps
                            ${_Qt53DAnimation_${Configuration}_${_lib}_PATH}
                        )
                    else()
                        message(FATAL_ERROR "Library not found: ${_lib}")
                    endif()
                    unset(_framework_flag)
                endif()
            elseif(EXISTS "${_flag}")
                # The flag is an absolute path to an existing library
                list(APPEND _lib_deps "${_flag}")
            elseif(_flag MATCHES "^-L(.*)$")
                # Handle -Lfoo flags by putting their paths in the search path used by find_library above
                list(APPEND _search_paths "${CMAKE_MATCH_1}")
            else()
                # Handle all remaining flags by simply passing them to the linker
                list(APPEND _link_flags ${_flag})
            endif()
        endforeach()
    endif()

    string(REPLACE ";" " " _link_flags "${_link_flags}")
    set(${lib_deps} ${_lib_deps} PARENT_SCOPE)
    set(${link_flags} "SHELL:${_link_flags}" PARENT_SCOPE)
endfunction()

if(NOT COMMAND _qt5_add_dependencies)
    # add dependencies via imported targets so CMake does not mess with their (absolute) file path
    # which can be problematic with unwanted -Wl,-Bstatic or -Wl,-Bdynamic in the linker line
    function(_qt5_add_dependencies IMPORTED_TARGET_NAME IMPORTED_TARGET_CONFIG STATIC_DEPENDENCIES)
        set(DEPENDENCY_INDEX 0)
        unset(EXTRA_PATHS)
        unset(DEPENDENCY_TARGETS)

        foreach(LIBRARY_LOCATION ${STATIC_DEPENDENCIES})
            if (TARGET "${LIBRARY_LOCATION}")
                list(APPEND DEPENDENCY_TARGETS "${LIBRARY_LOCATION}")
                continue()
            endif()
            set(DEPENDENCY_NAME ${IMPORTED_TARGET_NAME}_DEPENDENCY_${DEPENDENCY_INDEX})
            if (NOT TARGET "${DEPENDENCY_NAME}")
                add_library(${DEPENDENCY_NAME} STATIC IMPORTED)
                set_property(TARGET ${DEPENDENCY_NAME} PROPERTY IMPORTED_LOCATION ${LIBRARY_LOCATION})
            endif()
            list(APPEND DEPENDENCY_TARGETS ${DEPENDENCY_NAME})
            math(EXPR DEPENDENCY_INDEX "${DEPENDENCY_INDEX} + 1")
        endforeach()

        if ("${IMPORTED_TARGET_CONFIG}" STREQUAL "ALL" OR "${IMPORTED_TARGET_CONFIG}" STREQUAL "RELEASE")
            set_property(TARGET ${IMPORTED_TARGET_NAME} PROPERTY INTERFACE_LINK_LIBRARIES ${DEPENDENCY_TARGETS})
        endif()
        if (NOT "${IMPORTED_TARGET_CONFIG}" STREQUAL "ALL")
            set_property(TARGET ${IMPORTED_TARGET_NAME} PROPERTY INTERFACE_LINK_LIBRARIES_${IMPORTED_TARGET_CONFIG} ${DEPENDENCY_TARGETS})
        endif()
    endfunction()
endif()

# ensure also regular/dynamic macro exists because it might be used in some extra config
if(NOT COMMAND _qt5_3DAnimation_check_file_exists)
    macro(_qt5_3DAnimation_check_file_exists FILE)
        _qt5_3DAnimation_check_file_exists_static("${FILE}")
    endmacro()
endif()

macro(_populate_3DAnimation_target_properties_static TARGET_NAME Configuration LIB_LOCATION IMPLIB_LOCATION
      IsDebugAndRelease)
    set_property(TARGET ${TARGET_NAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt53DAnimation_install_prefix}/lib/${LIB_LOCATION}")
    _qt5_3DAnimation_check_file_exists(${imported_location})
    set(_deps
        ${_Qt53DAnimation_LIB_DEPENDENCIES}
        ${_Qt53DAnimation_STATIC_${Configuration}_LIB_DEPENDENCIES}
    )

    # FIXME: handle IsDebugAndRelease like in official version

    set_target_properties("${TARGET_NAME}" PROPERTIES
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
    )
    _qt5_add_dependencies("${TARGET_NAME}" "${Configuration}" "${_deps}")
    if(NOT CMAKE_VERSION VERSION_LESS "3.13")
        set_target_properties("${TARGET_NAME}" PROPERTIES
            "INTERFACE_LINK_OPTIONS" "${_Qt53DAnimation_STATIC_${Configuration}_LINK_FLAGS}"
        )
    endif()

    set(imported_implib "${_qt53DAnimation_install_prefix}/lib/${IMPLIB_LOCATION}")
    _qt5_3DAnimation_check_file_exists_static(${imported_implib})
    if(NOT "${IMPLIB_LOCATION}" STREQUAL "")
        set_target_properties(${QT_VARIANT_PREFIX}Qt5::3DAnimation PROPERTIES
        "IMPORTED_IMPLIB_${Configuration}" ${imported_implib}
        )
    endif()
endmacro()

macro(_populate_3DAnimation_plugin_target_dependencies_from_prl_file PLUGIN_TARGET_NAME PRL_FILE_LOCATION CONFIGURATION LIB_DIRECTORY LIB_LOCATION)
    _qt5_3DAnimation_process_prl_file(
        "${PRL_FILE_LOCATION}"
        "${CONFIGURATION}"
        _Qt53DAnimation_STATIC_PLUGIN_${CONFIGURATION}_LIB_DEPENDENCIES
        _Qt53DAnimation_STATIC_PLUGIN_${CONFIGURATION}_LINK_FLAGS)
    _qt5_add_dependencies("${PLUGIN_TARGET_NAME}" ALL "${_Qt53DAnimation_STATIC_PLUGIN_${CONFIGURATION}_LIB_DEPENDENCIES}")
endmacro()

if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::3DAnimation)
    set(_Qt53DAnimation_OWN_INCLUDE_DIRS "${_qt53DAnimation_install_prefix}/include/qt/" "${_qt53DAnimation_install_prefix}/include/qt/Qt3DAnimation")
    set(${QT_VARIANT_PREFIX}Qt53DAnimation_PRIVATE_INCLUDE_DIRS
        "${_qt53DAnimation_install_prefix}/include/qt/Qt3DAnimation/5.15.17"
        "${_qt53DAnimation_install_prefix}/include/qt/Qt3DAnimation/5.15.17/Qt3DAnimation"
    )

    foreach(_dir ${_Qt53DAnimation_OWN_INCLUDE_DIRS})
        _qt5_3DAnimation_check_file_exists_static(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt53DAnimation_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt53DAnimation_PRIVATE_INCLUDE_DIRS})
            _qt5_3DAnimation_check_file_exists_static(${_dir})
        endforeach()
    endif()

    set(${QT_VARIANT_PREFIX}Qt53DAnimation_INCLUDE_DIRS ${_Qt53DAnimation_OWN_INCLUDE_DIRS})

    set(${QT_VARIANT_PREFIX}Qt53DAnimation_DEFINITIONS -DQT_3DANIMATION_LIB)
    set(${QT_VARIANT_PREFIX}Qt53DAnimation_COMPILE_DEFINITIONS QT_3DANIMATION_LIB)
    set(_Qt53DAnimation_MODULE_DEPENDENCIES "3DRender;3DCore;Gui;Core")


    set(${QT_VARIANT_PREFIX}Qt53DAnimation_OWN_PRIVATE_INCLUDE_DIRS ${Qt53DAnimation_PRIVATE_INCLUDE_DIRS})

    set(_Qt53DAnimation_FIND_DEPENDENCIES_REQUIRED)
    if (${QT_VARIANT_PREFIX}Qt53DAnimation_FIND_REQUIRED)
        set(_Qt53DAnimation_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt53DAnimation_FIND_DEPENDENCIES_QUIET)
    if (Qt53DAnimation_FIND_QUIETLY)
        set(_Qt53DAnimation_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt53DAnimation_FIND_VERSION_EXACT)
    if (${QT_VARIANT_PREFIX}Qt53DAnimation_FIND_VERSION_EXACT)
        set(_Qt53DAnimation_FIND_VERSION_EXACT EXACT)
    endif()

    set(${QT_VARIANT_PREFIX}Qt53DAnimation_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt53DAnimation_MODULE_DEPENDENCIES})
        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
                5.15.17 ${_Qt53DAnimation_FIND_VERSION_EXACT}
                ${_Qt53DAnimation_DEPENDENCIES_FIND_QUIET}
                ${_Qt53DAnimation_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
            set(${QT_VARIANT_PREFIX}Qt53DAnimation_FOUND False)
            return()
        endif()

        list(APPEND ${QT_VARIANT_PREFIX}Qt53DAnimation_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND ${QT_VARIANT_PREFIX}Qt53DAnimation_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND ${QT_VARIANT_PREFIX}Qt53DAnimation_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND ${QT_VARIANT_PREFIX}Qt53DAnimation_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND ${QT_VARIANT_PREFIX}Qt53DAnimation_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt53DAnimation_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt53DAnimation_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt53DAnimation_DEFINITIONS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt53DAnimation_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES ${QT_VARIANT_PREFIX}Qt53DAnimation_EXECUTABLE_COMPILE_FLAGS)

    # It can happen that the same FooConfig.cmake file is included when calling find_package()
    # on some Qt component. An example of that is when using a Qt static build with auto inclusion
    # of plugins:
    #
    # Qt5WidgetsConfig.cmake -> Qt5GuiConfig.cmake -> Qt5Gui_QSvgIconPlugin.cmake ->
    # Qt5SvgConfig.cmake -> Qt5WidgetsConfig.cmake ->
    # finish processing of second Qt5WidgetsConfig.cmake ->
    # return to first Qt5WidgetsConfig.cmake ->
    # add_library cannot create imported target Qt5::Widgets.
    #
    # Make sure to return early in the original Config inclusion, because the target has already
    # been defined as part of the second inclusion.
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::3DAnimation)
    if(TARGET ${TARGET_NAME})
        return()
    endif()

    set(_Qt53DAnimation_LIB_DEPENDENCIES "${QT_VARIANT_PREFIX}Qt5::3DRender;${QT_VARIANT_PREFIX}Qt5::3DCore;${QT_VARIANT_PREFIX}Qt5::Gui;${QT_VARIANT_PREFIX}Qt5::Core")


    if(NOT Qt5_EXCLUDE_STATIC_DEPENDENCIES)

        _qt5_3DAnimation_process_prl_file(
            "${_qt53DAnimation_install_prefix}/lib/Qt53DAnimation.static.prl" RELEASE
            _Qt53DAnimation_STATIC_RELEASE_LIB_DEPENDENCIES
            _Qt53DAnimation_STATIC_RELEASE_LINK_FLAGS
        )
    endif()

    add_library(${TARGET_NAME} STATIC IMPORTED)
    set_property(TARGET ${TARGET_NAME} PROPERTY IMPORTED_LINK_INTERFACE_LANGUAGES CXX)




    set_property(TARGET ${TARGET_NAME} PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt53DAnimation_OWN_INCLUDE_DIRS})
    set_property(TARGET ${TARGET_NAME} PROPERTY
        INTERFACE_COMPILE_DEFINITIONS QT_STATIC;QT_DESIGNER_STATIC QT_3DANIMATION_LIB)

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_ENABLED_FEATURES )
    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    # Qt 6 forward compatible properties.
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_ENABLED_PUBLIC_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_DISABLED_PUBLIC_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_ENABLED_PRIVATE_FEATURES
                 )
    set_property(TARGET ${TARGET_NAME}
                 PROPERTY QT_DISABLED_PRIVATE_FEATURES
                 )

    set_property(TARGET ${TARGET_NAME} PROPERTY INTERFACE_QT_PLUGIN_TYPES "")

    # Find plugin targets
    file(GLOB pluginTargetsMaybe "${CMAKE_CURRENT_LIST_DIR}/*Qt53DAnimation_*.cmake")
    unset(pluginTargets)
    if(pluginTargetsMaybe)
        foreach(pluginTarget ${pluginTargetsMaybe})
            file(STRINGS ${pluginTarget} matched REGEX Qt53DAnimation_PLUGINS)
            if(matched)
                list(APPEND pluginTargets ${pluginTarget})
            endif()
        endforeach()
    endif()

    macro(_populate_3DAnimation_plugin_properties_static TARGET_NAME PLUGIN_TARGET_NAME PLUGIN_NAME CONFIG PLUGIN_LOCATION)
        set_property(TARGET ${PLUGIN_TARGET_NAME} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${CONFIG})

        set(imported_location "${_qt53DAnimation_install_prefix}/lib/qt/plugins/${PLUGIN_LOCATION}")
        _qt5_3DAnimation_check_file_exists_static(${imported_location})
        set_target_properties(${PLUGIN_TARGET_NAME} PROPERTIES
            "IMPORTED_LOCATION_${CONFIG}" ${imported_location}
        )
        set_property(TARGET ${TARGET_NAME} APPEND PROPERTY STATIC_PLUGINS ${PLUGIN_NAME})
        get_filename_component(_PLUGIN_DIR ${PLUGIN_LOCATION} PATH)
        get_filename_component(_PLUGIN_DIR_NAME ${_PLUGIN_DIR} NAME)
        get_filename_component(_PLUGIN_NAME ${PLUGIN_LOCATION} NAME)
        string(REGEX REPLACE "^lib(.*)\\.a" "${_qt53DAnimation_install_prefix}/lib/qt/plugins/${_PLUGIN_DIR_NAME}/\\1.static.prl" PLUGIN_PRL_FILE_LOCATION ${_PLUGIN_NAME})
        if(NOT EXISTS ${PLUGIN_PRL_FILE_LOCATION})
            string(REGEX REPLACE "^lib(.*)\\.a" "${_qt53DAnimation_install_prefix}/lib/qt/plugins/${_PLUGIN_DIR_NAME}/\\1.prl" PLUGIN_PRL_FILE_LOCATION ${_PLUGIN_NAME})
        endif()
        if(NOT EXISTS ${PLUGIN_PRL_FILE_LOCATION})
            string(REGEX REPLACE "^lib(.*)\\.a" "${_qt53DAnimation_install_prefix}/lib/qt/plugins/${_PLUGIN_DIR_NAME}/lib\\1.prl" PLUGIN_PRL_FILE_LOCATION ${_PLUGIN_NAME})
        endif()
        if(NOT EXISTS ${PLUGIN_PRL_FILE_LOCATION})
            message(FATAL_ERROR The prl file containing dependencies of static plugin ${PLUGIN_TARGET_NAME} of ${TARGET_NAME} could not be found.)
        endif()
        _populate_3DAnimation_plugin_target_dependencies_from_prl_file(${PLUGIN_TARGET_NAME} ${PLUGIN_PRL_FILE_LOCATION} ${CONFIG} "lib/qt/plugins" ${PLUGIN_LOCATION})

    endmacro()

    if(pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()

    # set TARGET_NAME back to current module (when loading plugin targets other modules might have been loaded in the meantime)
    set(TARGET_NAME ${QT_VARIANT_PREFIX}Qt5::3DAnimation)

    set(_Qt53DAnimation_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt53DAnimation_PRIVATE_DIR ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt53DAnimation_PRIVATE_DIR})
            set(_Qt53DAnimation_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt53DAnimation_PRIVATE_DIRS_EXIST)
        add_library(${TARGET_NAME}Private INTERFACE IMPORTED)
        set_property(TARGET ${TARGET_NAME}Private PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${${TARGET_NAME}_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt53DAnimation_PRIVATEDEPS)
        foreach(dep ${_Qt53DAnimation_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt53DAnimation_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        _qt5_add_dependencies(${TARGET_NAME}Private ALL
            "${TARGET_NAME};${_Qt53DAnimation_PRIVATEDEPS}")
    endif()

    _populate_3DAnimation_target_properties_static(${TARGET_NAME} RELEASE "libQt53DAnimation.a" "" FALSE)


    if (EXISTS "${_qt53DAnimation_install_prefix}/lib/libQt53DAnimation.a" )
        _populate_3DAnimation_target_properties_static(${TARGET_NAME} DEBUG "libQt53DAnimation.a" "" FALSE)
    endif()



    _qt5_3DAnimation_check_file_exists_static("${CMAKE_CURRENT_LIST_DIR}/../${QT_VARIANT_PREFIX}Qt53DAnimation/${QT_VARIANT_PREFIX}Qt53DAnimationConfigVersion.cmake")
endif()

# Add a versionless target, for compatibility with Qt6.
if(NOT "${QT_NO_CREATE_VERSIONLESS_TARGETS}" AND TARGET ${QT_VARIANT_PREFIX}Qt5::3DAnimation AND NOT TARGET ${QT_VARIANT_PREFIX}Qt::3DAnimation)
    add_library(${QT_VARIANT_PREFIX}Qt::3DAnimation INTERFACE IMPORTED)
    set_target_properties(${QT_VARIANT_PREFIX}Qt::3DAnimation PROPERTIES
        INTERFACE_LINK_LIBRARIES "${QT_VARIANT_PREFIX}Qt5::3DAnimation"
    )
endif()
