// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Devices_HumanInterfaceDevice_H
#define WINRT_Windows_Devices_HumanInterfaceDevice_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Devices.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.Devices.HumanInterfaceDevice.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::UsagePage() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::UsageId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::IsActive(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsActive(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->put_IsActive(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControl<D>::ControlDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ControlDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>**)this;
            check_hresult(_winrt_abi_type->get_ControlDescription(&value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::ReportId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::ReportType() const
    {
        winrt::Windows::Devices::HumanInterfaceDevice::HidReportType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::UsagePage() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::UsageId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription<D>::ParentCollections() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ParentCollections(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ParentCollections(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidCollection>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidBooleanControlDescription2<D>::IsAbsolute() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAbsolute(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2>**)this;
            check_hresult(_winrt_abi_type->get_IsAbsolute(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidCollection<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidCollection<D>::Type() const
    {
        winrt::Windows::Devices::HumanInterfaceDevice::HidCollectionType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Type(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)this;
            check_hresult(_winrt_abi_type->get_Type(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidCollection<D>::UsagePage() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidCollection<D>::UsageId() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::VendorId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VendorId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->get_VendorId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::ProductId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::Version() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Version(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->get_Version(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::UsagePage() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::UsageId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetInputReportAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetInputReportAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetInputReportAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetInputReportAsync(uint16_t reportId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetInputReportByIdAsync(reportId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetInputReportByIdAsync(reportId, &value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetFeatureReportAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFeatureReportAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetFeatureReportAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetFeatureReportAsync(uint16_t reportId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFeatureReportByIdAsync(reportId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetFeatureReportByIdAsync(reportId, &value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::CreateOutputReport() const
    {
        void* outputReport{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateOutputReport(&outputReport));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->CreateOutputReport(&outputReport));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport{ outputReport, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::CreateOutputReport(uint16_t reportId) const
    {
        void* outputReport{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateOutputReportById(reportId, &outputReport));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->CreateOutputReportById(reportId, &outputReport));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport{ outputReport, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::CreateFeatureReport() const
    {
        void* featureReport{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFeatureReport(&featureReport));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->CreateFeatureReport(&featureReport));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport{ featureReport, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::CreateFeatureReport(uint16_t reportId) const
    {
        void* featureReport{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFeatureReportById(reportId, &featureReport));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->CreateFeatureReportById(reportId, &featureReport));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport{ featureReport, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::SendOutputReportAsync(winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport const& outputReport) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SendOutputReportAsync(*(void**)(&outputReport), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->SendOutputReportAsync(*(void**)(&outputReport), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<uint32_t>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::SendFeatureReportAsync(winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport const& featureReport) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SendFeatureReportAsync(*(void**)(&featureReport), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->SendFeatureReportAsync(*(void**)(&featureReport), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<uint32_t>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetBooleanControlDescriptions(winrt::Windows::Devices::HumanInterfaceDevice::HidReportType const& reportType, uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControlDescriptions(static_cast<int32_t>(reportType), usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControlDescriptions(static_cast<int32_t>(reportType), usagePage, usageId, &value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::GetNumericControlDescriptions(winrt::Windows::Devices::HumanInterfaceDevice::HidReportType const& reportType, uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControlDescriptions(static_cast<int32_t>(reportType), usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->GetNumericControlDescriptions(static_cast<int32_t>(reportType), usagePage, usageId, &value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::InputReportReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice, winrt::Windows::Devices::HumanInterfaceDevice::HidInputReportReceivedEventArgs> const& reportHandler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_InputReportReceived(*(void**)(&reportHandler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            check_hresult(_winrt_abi_type->add_InputReportReceived(*(void**)(&reportHandler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::InputReportReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice, winrt::Windows::Devices::HumanInterfaceDevice::HidInputReportReceivedEventArgs> const& reportHandler) const
    {
        return impl::make_event_revoker<D, InputReportReceived_revoker>(this, InputReportReceived(reportHandler));
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDevice<D>::InputReportReceived(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)&_winrt_casted_result;
            _winrt_abi_type->remove_InputReportReceived(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>**)this;
            _winrt_abi_type->remove_InputReportReceived(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDeviceStatics<D>::GetDeviceSelector(uint16_t usagePage, uint16_t usageId) const
    {
        void* selector{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(usagePage, usageId, &selector));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(usagePage, usageId, &selector));
        }
        return hstring{ selector, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDeviceStatics<D>::GetDeviceSelector(uint16_t usagePage, uint16_t usageId, uint16_t vendorId, uint16_t productId) const
    {
        void* selector{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorVidPid(usagePage, usageId, vendorId, productId, &selector));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorVidPid(usagePage, usageId, vendorId, productId, &selector));
        }
        return hstring{ selector, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidDeviceStatics<D>::FromIdAsync(param::hstring const& deviceId, winrt::Windows::Storage::FileAccessMode const& accessMode) const
    {
        void* hidDevice{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), static_cast<int32_t>(accessMode), &hidDevice));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&deviceId), static_cast<int32_t>(accessMode), &hidDevice));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice>{ hidDevice, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::Id() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::Data(winrt::Windows::Storage::Streams::IBuffer const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::GetBooleanControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::GetBooleanControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::GetNumericControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidFeatureReport<D>::GetNumericControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::Id() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::ActivatedBooleanControls() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActivatedBooleanControls(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->get_ActivatedBooleanControls(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::TransitionedBooleanControls() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransitionedBooleanControls(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->get_TransitionedBooleanControls(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::GetBooleanControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::GetBooleanControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::GetNumericControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReport<D>::GetNumericControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidInputReportReceivedEventArgs<D>::Report() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Report(&value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::IsGrouped() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsGrouped(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_IsGrouped(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::UsagePage() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::UsageId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::Value() const
    {
        int64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_Value(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::Value(int64_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Value(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->put_Value(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::ScaledValue() const
    {
        int64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ScaledValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_ScaledValue(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::ScaledValue(int64_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ScaledValue(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->put_ScaledValue(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControl<D>::ControlDescription() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ControlDescription(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>**)this;
            check_hresult(_winrt_abi_type->get_ControlDescription(&value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::ReportId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::ReportType() const
    {
        winrt::Windows::Devices::HumanInterfaceDevice::HidReportType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::ReportSize() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportSize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportSize(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::ReportCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReportCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ReportCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::UsagePage() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_UsagePage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::UsageId() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_UsageId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::LogicalMinimum() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LogicalMinimum(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_LogicalMinimum(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::LogicalMaximum() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LogicalMaximum(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_LogicalMaximum(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::PhysicalMinimum() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalMinimum(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalMinimum(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::PhysicalMaximum() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PhysicalMaximum(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_PhysicalMaximum(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::UnitExponent() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UnitExponent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_UnitExponent(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::Unit() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Unit(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_Unit(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::IsAbsolute() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAbsolute(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_IsAbsolute(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::HasNull() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HasNull(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_HasNull(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidNumericControlDescription<D>::ParentCollections() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ParentCollections(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>**)this;
            check_hresult(_winrt_abi_type->get_ParentCollections(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidCollection>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::Id() const
    {
        uint16_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::Data(winrt::Windows::Storage::Streams::IBuffer const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->put_Data(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::GetBooleanControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::GetBooleanControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->GetBooleanControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::GetNumericControl(uint16_t usagePage, uint16_t usageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControl(usagePage, usageId, &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_HumanInterfaceDevice_IHidOutputReport<D>::GetNumericControlByDescription(winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const& controlDescription) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>**)this;
            check_hresult(_winrt_abi_type->GetNumericControlByDescription(*(void**)(&controlDescription), &value));
        }
        return winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsActive(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsActive(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ControlDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription>(this->shim().ControlDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().ReportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidReportType>(this->shim().ReportType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ParentCollections(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidCollection>>(this->shim().ParentCollections());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2>
    {
        int32_t __stdcall get_IsAbsolute(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAbsolute());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Type(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidCollectionType>(this->shim().Type());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice>
    {
        int32_t __stdcall get_VendorId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().VendorId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProductId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().ProductId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Version(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Version());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetInputReportAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport>>(this->shim().GetInputReportAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetInputReportByIdAsync(uint16_t reportId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport>>(this->shim().GetInputReportAsync(reportId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFeatureReportAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>>(this->shim().GetFeatureReportAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFeatureReportByIdAsync(uint16_t reportId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>>(this->shim().GetFeatureReportAsync(reportId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateOutputReport(void** outputReport) noexcept final try
        {
            clear_abi(outputReport);
            typename D::abi_guard guard(this->shim());
            *outputReport = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport>(this->shim().CreateOutputReport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateOutputReportById(uint16_t reportId, void** outputReport) noexcept final try
        {
            clear_abi(outputReport);
            typename D::abi_guard guard(this->shim());
            *outputReport = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport>(this->shim().CreateOutputReport(reportId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFeatureReport(void** featureReport) noexcept final try
        {
            clear_abi(featureReport);
            typename D::abi_guard guard(this->shim());
            *featureReport = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>(this->shim().CreateFeatureReport());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFeatureReportById(uint16_t reportId, void** featureReport) noexcept final try
        {
            clear_abi(featureReport);
            typename D::abi_guard guard(this->shim());
            *featureReport = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport>(this->shim().CreateFeatureReport(reportId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SendOutputReportAsync(void* outputReport, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<uint32_t>>(this->shim().SendOutputReportAsync(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport const*>(&outputReport)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SendFeatureReportAsync(void* featureReport, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<uint32_t>>(this->shim().SendFeatureReportAsync(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport const*>(&featureReport)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControlDescriptions(int32_t reportType, uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription>>(this->shim().GetBooleanControlDescriptions(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidReportType const*>(&reportType), usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControlDescriptions(int32_t reportType, uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription>>(this->shim().GetNumericControlDescriptions(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidReportType const*>(&reportType), usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_InputReportReceived(void* reportHandler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().InputReportReceived(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice, winrt::Windows::Devices::HumanInterfaceDevice::HidInputReportReceivedEventArgs> const*>(&reportHandler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_InputReportReceived(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InputReportReceived(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics>
    {
        int32_t __stdcall GetDeviceSelector(uint16_t usagePage, uint16_t usageId, void** selector) noexcept final try
        {
            clear_abi(selector);
            typename D::abi_guard guard(this->shim());
            *selector = detach_from<hstring>(this->shim().GetDeviceSelector(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelectorVidPid(uint16_t usagePage, uint16_t usageId, uint16_t vendorId, uint16_t productId, void** selector) noexcept final try
        {
            clear_abi(selector);
            typename D::abi_guard guard(this->shim());
            *selector = detach_from<hstring>(this->shim().GetDeviceSelector(usagePage, usageId, vendorId, productId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromIdAsync(void* deviceId, int32_t accessMode, void** hidDevice) noexcept final try
        {
            clear_abi(hidDevice);
            typename D::abi_guard guard(this->shim());
            *hidDevice = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&deviceId), *reinterpret_cast<winrt::Windows::Storage::FileAccessMode const*>(&accessMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport>
    {
        int32_t __stdcall get_Id(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Data(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Data(*reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport>
    {
        int32_t __stdcall get_Id(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ActivatedBooleanControls(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>>(this->shim().ActivatedBooleanControls());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransitionedBooleanControls(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>>(this->shim().TransitionedBooleanControls());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs>
    {
        int32_t __stdcall get_Report(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport>(this->shim().Report());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsGrouped(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsGrouped());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Value(int64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int64_t>(this->shim().Value());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Value(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Value(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ScaledValue(int64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int64_t>(this->shim().ScaledValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ScaledValue(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ScaledValue(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ControlDescription(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription>(this->shim().ControlDescription());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().ReportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidReportType>(this->shim().ReportType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportSize(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ReportSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReportCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ReportCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsagePage(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsagePage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UsageId(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().UsageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LogicalMinimum(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().LogicalMinimum());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LogicalMaximum(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().LogicalMaximum());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalMinimum(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().PhysicalMinimum());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PhysicalMaximum(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().PhysicalMaximum());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UnitExponent(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().UnitExponent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Unit(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Unit());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsAbsolute(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAbsolute());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HasNull(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().HasNull());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ParentCollections(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::HumanInterfaceDevice::HidCollection>>(this->shim().ParentCollections());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport> : produce_base<D, winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport>
    {
        int32_t __stdcall get_Id(uint16_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint16_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Data(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Data(*reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBooleanControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl>(this->shim().GetBooleanControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControl(uint16_t usagePage, uint16_t usageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControl(usagePage, usageId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetNumericControlByDescription(void* controlDescription, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl>(this->shim().GetNumericControlByDescription(*reinterpret_cast<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription const*>(&controlDescription)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Devices::HumanInterfaceDevice
{
    inline auto HidDevice::GetDeviceSelector(uint16_t usagePage, uint16_t usageId)
    {
        return impl::call_factory<HidDevice, IHidDeviceStatics>([&](IHidDeviceStatics const& f) { return f.GetDeviceSelector(usagePage, usageId); });
    }
    inline auto HidDevice::GetDeviceSelector(uint16_t usagePage, uint16_t usageId, uint16_t vendorId, uint16_t productId)
    {
        return impl::call_factory<HidDevice, IHidDeviceStatics>([&](IHidDeviceStatics const& f) { return f.GetDeviceSelector(usagePage, usageId, vendorId, productId); });
    }
    inline auto HidDevice::FromIdAsync(param::hstring const& deviceId, winrt::Windows::Storage::FileAccessMode const& accessMode)
    {
        return impl::call_factory<HidDevice, IHidDeviceStatics>([&](IHidDeviceStatics const& f) { return f.FromIdAsync(deviceId, accessMode); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidBooleanControlDescription2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidCollection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidDeviceStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidFeatureReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidInputReportReceivedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidNumericControlDescription> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::IHidOutputReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidBooleanControlDescription> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidCollection> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidFeatureReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidInputReportReceivedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControl> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidNumericControlDescription> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::HumanInterfaceDevice::HidOutputReport> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
