// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_ApplicationModel_Store_H
#define WINRT_Windows_ApplicationModel_Store_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.ApplicationModel.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.ApplicationModel.Store.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::LicenseInformation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LicenseInformation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->get_LicenseInformation(&value));
        }
        return winrt::Windows::ApplicationModel::Store::LicenseInformation{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::LinkUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinkUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->get_LinkUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::AppId() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->get_AppId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::RequestAppPurchaseAsync(bool includeReceipt) const
    {
        void* requestAppPurchaseOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAppPurchaseAsync(includeReceipt, &requestAppPurchaseOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->RequestAppPurchaseAsync(includeReceipt, &requestAppPurchaseOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ requestAppPurchaseOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::RequestProductPurchaseAsync(param::hstring const& productId, bool includeReceipt) const
    {
        void* requestProductPurchaseOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseAsync(*(void**)(&productId), includeReceipt, &requestProductPurchaseOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseAsync(*(void**)(&productId), includeReceipt, &requestProductPurchaseOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ requestProductPurchaseOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::LoadListingInformationAsync() const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationAsync(&loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationAsync(&loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::GetAppReceiptAsync() const
    {
        void* appReceiptOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAppReceiptAsync(&appReceiptOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->GetAppReceiptAsync(&appReceiptOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ appReceiptOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp<D>::GetProductReceiptAsync(param::hstring const& productId) const
    {
        void* getProductReceiptOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetProductReceiptAsync(*(void**)(&productId), &getProductReceiptOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp>**)this;
            check_hresult(_winrt_abi_type->GetProductReceiptAsync(*(void**)(&productId), &getProductReceiptOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ getProductReceiptOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp2Statics<D>::GetCustomerPurchaseIdAsync(param::hstring const& serviceTicket, param::hstring const& publisherUserId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCustomerPurchaseIdAsync(*(void**)(&serviceTicket), *(void**)(&publisherUserId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>**)this;
            check_hresult(_winrt_abi_type->GetCustomerPurchaseIdAsync(*(void**)(&serviceTicket), *(void**)(&publisherUserId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentApp2Statics<D>::GetCustomerCollectionsIdAsync(param::hstring const& serviceTicket, param::hstring const& publisherUserId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCustomerCollectionsIdAsync(*(void**)(&serviceTicket), *(void**)(&publisherUserId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>**)this;
            check_hresult(_winrt_abi_type->GetCustomerCollectionsIdAsync(*(void**)(&serviceTicket), *(void**)(&publisherUserId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::LicenseInformation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LicenseInformation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->get_LicenseInformation(&value));
        }
        return winrt::Windows::ApplicationModel::Store::LicenseInformation{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::LinkUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LinkUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->get_LinkUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::AppId() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->get_AppId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::RequestAppPurchaseAsync(bool includeReceipt) const
    {
        void* requestAppPurchaseOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAppPurchaseAsync(includeReceipt, &requestAppPurchaseOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->RequestAppPurchaseAsync(includeReceipt, &requestAppPurchaseOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ requestAppPurchaseOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::RequestProductPurchaseAsync(param::hstring const& productId, bool includeReceipt) const
    {
        void* requestProductPurchaseOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseAsync(*(void**)(&productId), includeReceipt, &requestProductPurchaseOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseAsync(*(void**)(&productId), includeReceipt, &requestProductPurchaseOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ requestProductPurchaseOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::LoadListingInformationAsync() const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationAsync(&loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationAsync(&loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::GetAppReceiptAsync() const
    {
        void* appReceiptOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAppReceiptAsync(&appReceiptOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->GetAppReceiptAsync(&appReceiptOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ appReceiptOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::GetProductReceiptAsync(param::hstring const& productId) const
    {
        void* getProductReceiptOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetProductReceiptAsync(*(void**)(&productId), &getProductReceiptOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->GetProductReceiptAsync(*(void**)(&productId), &getProductReceiptOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ getProductReceiptOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulator<D>::ReloadSimulatorAsync(winrt::Windows::Storage::StorageFile const& simulatorSettingsFile) const
    {
        void* reloadSimulatorOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReloadSimulatorAsync(*(void**)(&simulatorSettingsFile), &reloadSimulatorOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>**)this;
            check_hresult(_winrt_abi_type->ReloadSimulatorAsync(*(void**)(&simulatorSettingsFile), &reloadSimulatorOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ reloadSimulatorOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorStaticsWithFiltering<D>::LoadListingInformationByProductIdsAsync(param::async_iterable<hstring> const& productIds) const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationByProductIdsAsync(*(void**)(&productIds), &loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationByProductIdsAsync(*(void**)(&productIds), &loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorStaticsWithFiltering<D>::LoadListingInformationByKeywordsAsync(param::async_iterable<hstring> const& keywords) const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationByKeywordsAsync(*(void**)(&keywords), &loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationByKeywordsAsync(*(void**)(&keywords), &loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorWithCampaignId<D>::GetAppPurchaseCampaignIdAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAppPurchaseCampaignIdAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId>**)this;
            check_hresult(_winrt_abi_type->GetAppPurchaseCampaignIdAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorWithConsumables<D>::ReportConsumableFulfillmentAsync(param::hstring const& productId, winrt::guid const& transactionId) const
    {
        void* reportConsumableFulfillmentOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportConsumableFulfillmentAsync(*(void**)(&productId), impl::bind_in(transactionId), &reportConsumableFulfillmentOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)this;
            check_hresult(_winrt_abi_type->ReportConsumableFulfillmentAsync(*(void**)(&productId), impl::bind_in(transactionId), &reportConsumableFulfillmentOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::FulfillmentResult>{ reportConsumableFulfillmentOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorWithConsumables<D>::RequestProductPurchaseAsync(param::hstring const& productId) const
    {
        void* requestProductPurchaseWithResultsOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithResultsAsync(*(void**)(&productId), &requestProductPurchaseWithResultsOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithResultsAsync(*(void**)(&productId), &requestProductPurchaseWithResultsOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>{ requestProductPurchaseWithResultsOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorWithConsumables<D>::RequestProductPurchaseAsync(param::hstring const& productId, param::hstring const& offerId, winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const& displayProperties) const
    {
        void* requestProductPurchaseWithDisplayPropertiesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithDisplayPropertiesAsync(*(void**)(&productId), *(void**)(&offerId), *(void**)(&displayProperties), &requestProductPurchaseWithDisplayPropertiesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithDisplayPropertiesAsync(*(void**)(&productId), *(void**)(&offerId), *(void**)(&displayProperties), &requestProductPurchaseWithDisplayPropertiesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>{ requestProductPurchaseWithDisplayPropertiesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppSimulatorWithConsumables<D>::GetUnfulfilledConsumablesAsync() const
    {
        void* getUnfulfilledConsumablesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetUnfulfilledConsumablesAsync(&getUnfulfilledConsumablesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>**)this;
            check_hresult(_winrt_abi_type->GetUnfulfilledConsumablesAsync(&getUnfulfilledConsumablesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>{ getUnfulfilledConsumablesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppStaticsWithFiltering<D>::LoadListingInformationByProductIdsAsync(param::async_iterable<hstring> const& productIds) const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationByProductIdsAsync(*(void**)(&productIds), &loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationByProductIdsAsync(*(void**)(&productIds), &loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppStaticsWithFiltering<D>::LoadListingInformationByKeywordsAsync(param::async_iterable<hstring> const& keywords) const
    {
        void* loadListingOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LoadListingInformationByKeywordsAsync(*(void**)(&keywords), &loadListingOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)this;
            check_hresult(_winrt_abi_type->LoadListingInformationByKeywordsAsync(*(void**)(&keywords), &loadListingOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>{ loadListingOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppStaticsWithFiltering<D>::ReportProductFulfillment(param::hstring const& productId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportProductFulfillment(*(void**)(&productId)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>**)this;
            check_hresult(_winrt_abi_type->ReportProductFulfillment(*(void**)(&productId)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppWithCampaignId<D>::GetAppPurchaseCampaignIdAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetAppPurchaseCampaignIdAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId>**)this;
            check_hresult(_winrt_abi_type->GetAppPurchaseCampaignIdAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppWithConsumables<D>::ReportConsumableFulfillmentAsync(param::hstring const& productId, winrt::guid const& transactionId) const
    {
        void* reportConsumableFulfillmentOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportConsumableFulfillmentAsync(*(void**)(&productId), impl::bind_in(transactionId), &reportConsumableFulfillmentOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)this;
            check_hresult(_winrt_abi_type->ReportConsumableFulfillmentAsync(*(void**)(&productId), impl::bind_in(transactionId), &reportConsumableFulfillmentOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::FulfillmentResult>{ reportConsumableFulfillmentOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppWithConsumables<D>::RequestProductPurchaseAsync(param::hstring const& productId) const
    {
        void* requestProductPurchaseWithResultsOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithResultsAsync(*(void**)(&productId), &requestProductPurchaseWithResultsOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithResultsAsync(*(void**)(&productId), &requestProductPurchaseWithResultsOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>{ requestProductPurchaseWithResultsOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppWithConsumables<D>::RequestProductPurchaseAsync(param::hstring const& productId, param::hstring const& offerId, winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const& displayProperties) const
    {
        void* requestProductPurchaseWithDisplayPropertiesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithDisplayPropertiesAsync(*(void**)(&productId), *(void**)(&offerId), *(void**)(&displayProperties), &requestProductPurchaseWithDisplayPropertiesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)this;
            check_hresult(_winrt_abi_type->RequestProductPurchaseWithDisplayPropertiesAsync(*(void**)(&productId), *(void**)(&offerId), *(void**)(&displayProperties), &requestProductPurchaseWithDisplayPropertiesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>{ requestProductPurchaseWithDisplayPropertiesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ICurrentAppWithConsumables<D>::GetUnfulfilledConsumablesAsync() const
    {
        void* getUnfulfilledConsumablesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetUnfulfilledConsumablesAsync(&getUnfulfilledConsumablesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>**)this;
            check_hresult(_winrt_abi_type->GetUnfulfilledConsumablesAsync(&getUnfulfilledConsumablesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>{ getUnfulfilledConsumablesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::ProductLicenses() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductLicenses(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            check_hresult(_winrt_abi_type->get_ProductLicenses(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Store::ProductLicense>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::IsTrial() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsTrial(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            check_hresult(_winrt_abi_type->get_IsTrial(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::ExpirationDate() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExpirationDate(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            check_hresult(_winrt_abi_type->get_ExpirationDate(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::LicenseChanged(winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler const& handler) const
    {
        winrt::event_token cookie{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_LicenseChanged(*(void**)(&handler), put_abi(cookie)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            check_hresult(_winrt_abi_type->add_LicenseChanged(*(void**)(&handler), put_abi(cookie)));
        }
        return cookie;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::LicenseChanged(auto_revoke_t, winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler const& handler) const
    {
        return impl::make_event_revoker<D, LicenseChanged_revoker>(this, LicenseChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_ILicenseInformation<D>::LicenseChanged(winrt::event_token const& cookie) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::ILicenseInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)&_winrt_casted_result;
            _winrt_abi_type->remove_LicenseChanged(impl::bind_in(cookie));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::ILicenseInformation>**)this;
            _winrt_abi_type->remove_LicenseChanged(impl::bind_in(cookie));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::CurrentMarket() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentMarket(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_CurrentMarket(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::Description() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::ProductListings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductListings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_ProductListings(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Store::ProductListing>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::FormattedPrice() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FormattedPrice(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_FormattedPrice(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation<D>::AgeRating() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AgeRating(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation>**)this;
            check_hresult(_winrt_abi_type->get_AgeRating(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation2<D>::FormattedBasePrice() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FormattedBasePrice(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)this;
            check_hresult(_winrt_abi_type->get_FormattedBasePrice(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation2<D>::SaleEndDate() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SaleEndDate(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)this;
            check_hresult(_winrt_abi_type->get_SaleEndDate(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation2<D>::IsOnSale() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOnSale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)this;
            check_hresult(_winrt_abi_type->get_IsOnSale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IListingInformation2<D>::CurrencyCode() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IListingInformation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IListingInformation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrencyCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IListingInformation2>**)this;
            check_hresult(_winrt_abi_type->get_CurrencyCode(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductLicense<D>::ProductId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductLicense>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductLicense, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)this;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductLicense<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductLicense>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductLicense, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductLicense<D>::ExpirationDate() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductLicense>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductLicense, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExpirationDate(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicense>**)this;
            check_hresult(_winrt_abi_type->get_ExpirationDate(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductLicenseWithFulfillment<D>::IsConsumable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsConsumable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment>**)this;
            check_hresult(_winrt_abi_type->get_IsConsumable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing<D>::ProductId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)this;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing<D>::FormattedPrice() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FormattedPrice(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)this;
            check_hresult(_winrt_abi_type->get_FormattedPrice(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing2<D>::FormattedBasePrice() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FormattedBasePrice(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)this;
            check_hresult(_winrt_abi_type->get_FormattedBasePrice(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing2<D>::SaleEndDate() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SaleEndDate(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)this;
            check_hresult(_winrt_abi_type->get_SaleEndDate(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing2<D>::IsOnSale() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOnSale(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)this;
            check_hresult(_winrt_abi_type->get_IsOnSale(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListing2<D>::CurrencyCode() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListing2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListing2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrencyCode(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListing2>**)this;
            check_hresult(_winrt_abi_type->get_CurrencyCode(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithConsumables<D>::ProductType() const
    {
        winrt::Windows::ApplicationModel::Store::ProductType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables>**)this;
            check_hresult(_winrt_abi_type->get_ProductType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithMetadata<D>::Description() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)this;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithMetadata<D>::Keywords() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Keywords(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)this;
            check_hresult(_winrt_abi_type->get_Keywords(&value));
        }
        return winrt::Windows::Foundation::Collections::IIterable<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithMetadata<D>::ProductType() const
    {
        winrt::Windows::ApplicationModel::Store::ProductType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)this;
            check_hresult(_winrt_abi_type->get_ProductType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithMetadata<D>::Tag() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Tag(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)this;
            check_hresult(_winrt_abi_type->get_Tag(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductListingWithMetadata<D>::ImageUri() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ImageUri(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>**)this;
            check_hresult(_winrt_abi_type->get_ImageUri(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Name(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->put_Name(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Description() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->get_Description(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Description(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Description(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->put_Description(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Image() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Image(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->get_Image(&value));
        }
        return winrt::Windows::Foundation::Uri{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayProperties<D>::Image(winrt::Windows::Foundation::Uri const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Image(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>**)this;
            check_hresult(_winrt_abi_type->put_Image(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IProductPurchaseDisplayPropertiesFactory<D>::CreateProductPurchaseDisplayProperties(param::hstring const& name) const
    {
        void* displayProperties{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateProductPurchaseDisplayProperties(*(void**)(&name), &displayProperties));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory>**)this;
            check_hresult(_winrt_abi_type->CreateProductPurchaseDisplayProperties(*(void**)(&name), &displayProperties));
        }
        return winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties{ displayProperties, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IPurchaseResults<D>::Status() const
    {
        winrt::Windows::ApplicationModel::Store::ProductPurchaseStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IPurchaseResults, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IPurchaseResults<D>::TransactionId() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IPurchaseResults, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransactionId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)this;
            check_hresult(_winrt_abi_type->get_TransactionId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IPurchaseResults<D>::ReceiptXml() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IPurchaseResults, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReceiptXml(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)this;
            check_hresult(_winrt_abi_type->get_ReceiptXml(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IPurchaseResults<D>::OfferId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IPurchaseResults, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OfferId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IPurchaseResults>**)this;
            check_hresult(_winrt_abi_type->get_OfferId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IUnfulfilledConsumable<D>::ProductId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)this;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IUnfulfilledConsumable<D>::TransactionId() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransactionId(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)this;
            check_hresult(_winrt_abi_type->get_TransactionId(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_IUnfulfilledConsumable<D>::OfferId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OfferId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>**)this;
            check_hresult(_winrt_abi_type->get_OfferId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename H> struct delegate<winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler, H> final : implements_delegate<winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke() noexcept final try
        {
            (*this)();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentApp> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentApp>
    {
        int32_t __stdcall get_LicenseInformation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::LicenseInformation>(this->shim().LicenseInformation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LinkUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().LinkUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppId(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().AppId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestAppPurchaseAsync(bool includeReceipt, void** requestAppPurchaseOperation) noexcept final try
        {
            clear_abi(requestAppPurchaseOperation);
            typename D::abi_guard guard(this->shim());
            *requestAppPurchaseOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().RequestAppPurchaseAsync(includeReceipt));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseAsync(void* productId, bool includeReceipt, void** requestProductPurchaseOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId), includeReceipt));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadListingInformationAsync(void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetAppReceiptAsync(void** appReceiptOperation) noexcept final try
        {
            clear_abi(appReceiptOperation);
            typename D::abi_guard guard(this->shim());
            *appReceiptOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetAppReceiptAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetProductReceiptAsync(void* productId, void** getProductReceiptOperation) noexcept final try
        {
            clear_abi(getProductReceiptOperation);
            typename D::abi_guard guard(this->shim());
            *getProductReceiptOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetProductReceiptAsync(*reinterpret_cast<hstring const*>(&productId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics>
    {
        int32_t __stdcall GetCustomerPurchaseIdAsync(void* serviceTicket, void* publisherUserId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetCustomerPurchaseIdAsync(*reinterpret_cast<hstring const*>(&serviceTicket), *reinterpret_cast<hstring const*>(&publisherUserId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCustomerCollectionsIdAsync(void* serviceTicket, void* publisherUserId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetCustomerCollectionsIdAsync(*reinterpret_cast<hstring const*>(&serviceTicket), *reinterpret_cast<hstring const*>(&publisherUserId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator>
    {
        int32_t __stdcall get_LicenseInformation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::LicenseInformation>(this->shim().LicenseInformation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LinkUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().LinkUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppId(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().AppId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestAppPurchaseAsync(bool includeReceipt, void** requestAppPurchaseOperation) noexcept final try
        {
            clear_abi(requestAppPurchaseOperation);
            typename D::abi_guard guard(this->shim());
            *requestAppPurchaseOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().RequestAppPurchaseAsync(includeReceipt));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseAsync(void* productId, bool includeReceipt, void** requestProductPurchaseOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId), includeReceipt));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadListingInformationAsync(void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetAppReceiptAsync(void** appReceiptOperation) noexcept final try
        {
            clear_abi(appReceiptOperation);
            typename D::abi_guard guard(this->shim());
            *appReceiptOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetAppReceiptAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetProductReceiptAsync(void* productId, void** getProductReceiptOperation) noexcept final try
        {
            clear_abi(getProductReceiptOperation);
            typename D::abi_guard guard(this->shim());
            *getProductReceiptOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetProductReceiptAsync(*reinterpret_cast<hstring const*>(&productId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReloadSimulatorAsync(void* simulatorSettingsFile, void** reloadSimulatorOperation) noexcept final try
        {
            clear_abi(reloadSimulatorOperation);
            typename D::abi_guard guard(this->shim());
            *reloadSimulatorOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ReloadSimulatorAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFile const*>(&simulatorSettingsFile)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering>
    {
        int32_t __stdcall LoadListingInformationByProductIdsAsync(void* productIds, void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationByProductIdsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&productIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadListingInformationByKeywordsAsync(void* keywords, void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationByKeywordsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&keywords)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId>
    {
        int32_t __stdcall GetAppPurchaseCampaignIdAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetAppPurchaseCampaignIdAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables>
    {
        int32_t __stdcall ReportConsumableFulfillmentAsync(void* productId, winrt::guid transactionId, void** reportConsumableFulfillmentOperation) noexcept final try
        {
            clear_abi(reportConsumableFulfillmentOperation);
            typename D::abi_guard guard(this->shim());
            *reportConsumableFulfillmentOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::FulfillmentResult>>(this->shim().ReportConsumableFulfillmentAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<winrt::guid const*>(&transactionId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseWithResultsAsync(void* productId, void** requestProductPurchaseWithResultsOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseWithResultsOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseWithResultsOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseWithDisplayPropertiesAsync(void* productId, void* offerId, void* displayProperties, void** requestProductPurchaseWithDisplayPropertiesOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseWithDisplayPropertiesOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseWithDisplayPropertiesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&offerId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const*>(&displayProperties)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetUnfulfilledConsumablesAsync(void** getUnfulfilledConsumablesOperation) noexcept final try
        {
            clear_abi(getUnfulfilledConsumablesOperation);
            typename D::abi_guard guard(this->shim());
            *getUnfulfilledConsumablesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>>(this->shim().GetUnfulfilledConsumablesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering>
    {
        int32_t __stdcall LoadListingInformationByProductIdsAsync(void* productIds, void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationByProductIdsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&productIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LoadListingInformationByKeywordsAsync(void* keywords, void** loadListingOperation) noexcept final try
        {
            clear_abi(loadListingOperation);
            typename D::abi_guard guard(this->shim());
            *loadListingOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>>(this->shim().LoadListingInformationByKeywordsAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&keywords)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportProductFulfillment(void* productId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportProductFulfillment(*reinterpret_cast<hstring const*>(&productId));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId>
    {
        int32_t __stdcall GetAppPurchaseCampaignIdAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().GetAppPurchaseCampaignIdAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables> : produce_base<D, winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables>
    {
        int32_t __stdcall ReportConsumableFulfillmentAsync(void* productId, winrt::guid transactionId, void** reportConsumableFulfillmentOperation) noexcept final try
        {
            clear_abi(reportConsumableFulfillmentOperation);
            typename D::abi_guard guard(this->shim());
            *reportConsumableFulfillmentOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::FulfillmentResult>>(this->shim().ReportConsumableFulfillmentAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<winrt::guid const*>(&transactionId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseWithResultsAsync(void* productId, void** requestProductPurchaseWithResultsOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseWithResultsOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseWithResultsOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestProductPurchaseWithDisplayPropertiesAsync(void* productId, void* offerId, void* displayProperties, void** requestProductPurchaseWithDisplayPropertiesOperation) noexcept final try
        {
            clear_abi(requestProductPurchaseWithDisplayPropertiesOperation);
            typename D::abi_guard guard(this->shim());
            *requestProductPurchaseWithDisplayPropertiesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::PurchaseResults>>(this->shim().RequestProductPurchaseAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&offerId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const*>(&displayProperties)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetUnfulfilledConsumablesAsync(void** getUnfulfilledConsumablesOperation) noexcept final try
        {
            clear_abi(getUnfulfilledConsumablesOperation);
            typename D::abi_guard guard(this->shim());
            *getUnfulfilledConsumablesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>>(this->shim().GetUnfulfilledConsumablesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation> : produce_base<D, winrt::Windows::ApplicationModel::Store::ILicenseInformation>
    {
        int32_t __stdcall get_ProductLicenses(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Store::ProductLicense>>(this->shim().ProductLicenses());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsTrial(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsTrial());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExpirationDate(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().ExpirationDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_LicenseChanged(void* handler, winrt::event_token* cookie) noexcept final try
        {
            zero_abi<winrt::event_token>(cookie);
            typename D::abi_guard guard(this->shim());
            *cookie = detach_from<winrt::event_token>(this->shim().LicenseChanged(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::LicenseChangedEventHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_LicenseChanged(winrt::event_token cookie) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LicenseChanged(*reinterpret_cast<winrt::event_token const*>(&cookie));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IListingInformation> : produce_base<D, winrt::Windows::ApplicationModel::Store::IListingInformation>
    {
        int32_t __stdcall get_CurrentMarket(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CurrentMarket());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Description(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Description());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProductListings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Store::ProductListing>>(this->shim().ProductListings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FormattedPrice(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FormattedPrice());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AgeRating(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().AgeRating());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IListingInformation2> : produce_base<D, winrt::Windows::ApplicationModel::Store::IListingInformation2>
    {
        int32_t __stdcall get_FormattedBasePrice(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FormattedBasePrice());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SaleEndDate(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().SaleEndDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsOnSale(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOnSale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CurrencyCode(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CurrencyCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductLicense> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductLicense>
    {
        int32_t __stdcall get_ProductId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProductId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExpirationDate(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().ExpirationDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment>
    {
        int32_t __stdcall get_IsConsumable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsConsumable());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductListing> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductListing>
    {
        int32_t __stdcall get_ProductId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProductId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FormattedPrice(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FormattedPrice());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductListing2> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductListing2>
    {
        int32_t __stdcall get_FormattedBasePrice(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FormattedBasePrice());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SaleEndDate(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().SaleEndDate());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsOnSale(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOnSale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CurrencyCode(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CurrencyCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables>
    {
        int32_t __stdcall get_ProductType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::ProductType>(this->shim().ProductType());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata>
    {
        int32_t __stdcall get_Description(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Description());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Keywords(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IIterable<hstring>>(this->shim().Keywords());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProductType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::ProductType>(this->shim().ProductType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Tag(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Tag());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ImageUri(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().ImageUri());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties>
    {
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Name(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Name(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Description(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Description());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Description(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Description(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Image(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Uri>(this->shim().Image());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Image(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Image(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory> : produce_base<D, winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory>
    {
        int32_t __stdcall CreateProductPurchaseDisplayProperties(void* name, void** displayProperties) noexcept final try
        {
            clear_abi(displayProperties);
            typename D::abi_guard guard(this->shim());
            *displayProperties = detach_from<winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties>(this->shim().CreateProductPurchaseDisplayProperties(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults> : produce_base<D, winrt::Windows::ApplicationModel::Store::IPurchaseResults>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::ProductPurchaseStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransactionId(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().TransactionId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReceiptXml(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ReceiptXml());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OfferId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().OfferId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable> : produce_base<D, winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable>
    {
        int32_t __stdcall get_ProductId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProductId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransactionId(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().TransactionId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OfferId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().OfferId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::ApplicationModel::Store
{
    inline auto CurrentApp::LicenseInformation()
    {
        return impl::call_factory_cast<winrt::Windows::ApplicationModel::Store::LicenseInformation(*)(ICurrentApp const&), CurrentApp, ICurrentApp>([](ICurrentApp const& f) { return f.LicenseInformation(); });
    }
    inline auto CurrentApp::LinkUri()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Uri(*)(ICurrentApp const&), CurrentApp, ICurrentApp>([](ICurrentApp const& f) { return f.LinkUri(); });
    }
    inline auto CurrentApp::AppId()
    {
        return impl::call_factory_cast<winrt::guid(*)(ICurrentApp const&), CurrentApp, ICurrentApp>([](ICurrentApp const& f) { return f.AppId(); });
    }
    inline auto CurrentApp::RequestAppPurchaseAsync(bool includeReceipt)
    {
        return impl::call_factory<CurrentApp, ICurrentApp>([&](ICurrentApp const& f) { return f.RequestAppPurchaseAsync(includeReceipt); });
    }
    inline auto CurrentApp::RequestProductPurchaseAsync(param::hstring const& productId, bool includeReceipt)
    {
        return impl::call_factory<CurrentApp, ICurrentApp>([&](ICurrentApp const& f) { return f.RequestProductPurchaseAsync(productId, includeReceipt); });
    }
    inline auto CurrentApp::LoadListingInformationAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>(*)(ICurrentApp const&), CurrentApp, ICurrentApp>([](ICurrentApp const& f) { return f.LoadListingInformationAsync(); });
    }
    inline auto CurrentApp::GetAppReceiptAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<hstring>(*)(ICurrentApp const&), CurrentApp, ICurrentApp>([](ICurrentApp const& f) { return f.GetAppReceiptAsync(); });
    }
    inline auto CurrentApp::GetProductReceiptAsync(param::hstring const& productId)
    {
        return impl::call_factory<CurrentApp, ICurrentApp>([&](ICurrentApp const& f) { return f.GetProductReceiptAsync(productId); });
    }
    inline auto CurrentApp::GetCustomerPurchaseIdAsync(param::hstring const& serviceTicket, param::hstring const& publisherUserId)
    {
        return impl::call_factory<CurrentApp, ICurrentApp2Statics>([&](ICurrentApp2Statics const& f) { return f.GetCustomerPurchaseIdAsync(serviceTicket, publisherUserId); });
    }
    inline auto CurrentApp::GetCustomerCollectionsIdAsync(param::hstring const& serviceTicket, param::hstring const& publisherUserId)
    {
        return impl::call_factory<CurrentApp, ICurrentApp2Statics>([&](ICurrentApp2Statics const& f) { return f.GetCustomerCollectionsIdAsync(serviceTicket, publisherUserId); });
    }
    inline auto CurrentApp::LoadListingInformationByProductIdsAsync(param::async_iterable<hstring> const& productIds)
    {
        return impl::call_factory<CurrentApp, ICurrentAppStaticsWithFiltering>([&](ICurrentAppStaticsWithFiltering const& f) { return f.LoadListingInformationByProductIdsAsync(productIds); });
    }
    inline auto CurrentApp::LoadListingInformationByKeywordsAsync(param::async_iterable<hstring> const& keywords)
    {
        return impl::call_factory<CurrentApp, ICurrentAppStaticsWithFiltering>([&](ICurrentAppStaticsWithFiltering const& f) { return f.LoadListingInformationByKeywordsAsync(keywords); });
    }
    inline auto CurrentApp::ReportProductFulfillment(param::hstring const& productId)
    {
        impl::call_factory<CurrentApp, ICurrentAppStaticsWithFiltering>([&](ICurrentAppStaticsWithFiltering const& f) { return f.ReportProductFulfillment(productId); });
    }
    inline auto CurrentApp::GetAppPurchaseCampaignIdAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<hstring>(*)(ICurrentAppWithCampaignId const&), CurrentApp, ICurrentAppWithCampaignId>([](ICurrentAppWithCampaignId const& f) { return f.GetAppPurchaseCampaignIdAsync(); });
    }
    inline auto CurrentApp::ReportConsumableFulfillmentAsync(param::hstring const& productId, winrt::guid const& transactionId)
    {
        return impl::call_factory<CurrentApp, ICurrentAppWithConsumables>([&](ICurrentAppWithConsumables const& f) { return f.ReportConsumableFulfillmentAsync(productId, transactionId); });
    }
    inline auto CurrentApp::RequestProductPurchaseAsync(param::hstring const& productId)
    {
        return impl::call_factory<CurrentApp, ICurrentAppWithConsumables>([&](ICurrentAppWithConsumables const& f) { return f.RequestProductPurchaseAsync(productId); });
    }
    inline auto CurrentApp::RequestProductPurchaseAsync(param::hstring const& productId, param::hstring const& offerId, winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const& displayProperties)
    {
        return impl::call_factory<CurrentApp, ICurrentAppWithConsumables>([&](ICurrentAppWithConsumables const& f) { return f.RequestProductPurchaseAsync(productId, offerId, displayProperties); });
    }
    inline auto CurrentApp::GetUnfulfilledConsumablesAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>(*)(ICurrentAppWithConsumables const&), CurrentApp, ICurrentAppWithConsumables>([](ICurrentAppWithConsumables const& f) { return f.GetUnfulfilledConsumablesAsync(); });
    }
    inline auto CurrentAppSimulator::LicenseInformation()
    {
        return impl::call_factory_cast<winrt::Windows::ApplicationModel::Store::LicenseInformation(*)(ICurrentAppSimulator const&), CurrentAppSimulator, ICurrentAppSimulator>([](ICurrentAppSimulator const& f) { return f.LicenseInformation(); });
    }
    inline auto CurrentAppSimulator::LinkUri()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Uri(*)(ICurrentAppSimulator const&), CurrentAppSimulator, ICurrentAppSimulator>([](ICurrentAppSimulator const& f) { return f.LinkUri(); });
    }
    inline auto CurrentAppSimulator::AppId()
    {
        return impl::call_factory_cast<winrt::guid(*)(ICurrentAppSimulator const&), CurrentAppSimulator, ICurrentAppSimulator>([](ICurrentAppSimulator const& f) { return f.AppId(); });
    }
    inline auto CurrentAppSimulator::RequestAppPurchaseAsync(bool includeReceipt)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulator>([&](ICurrentAppSimulator const& f) { return f.RequestAppPurchaseAsync(includeReceipt); });
    }
    inline auto CurrentAppSimulator::RequestProductPurchaseAsync(param::hstring const& productId, bool includeReceipt)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulator>([&](ICurrentAppSimulator const& f) { return f.RequestProductPurchaseAsync(productId, includeReceipt); });
    }
    inline auto CurrentAppSimulator::LoadListingInformationAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::ListingInformation>(*)(ICurrentAppSimulator const&), CurrentAppSimulator, ICurrentAppSimulator>([](ICurrentAppSimulator const& f) { return f.LoadListingInformationAsync(); });
    }
    inline auto CurrentAppSimulator::GetAppReceiptAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<hstring>(*)(ICurrentAppSimulator const&), CurrentAppSimulator, ICurrentAppSimulator>([](ICurrentAppSimulator const& f) { return f.GetAppReceiptAsync(); });
    }
    inline auto CurrentAppSimulator::GetProductReceiptAsync(param::hstring const& productId)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulator>([&](ICurrentAppSimulator const& f) { return f.GetProductReceiptAsync(productId); });
    }
    inline auto CurrentAppSimulator::ReloadSimulatorAsync(winrt::Windows::Storage::StorageFile const& simulatorSettingsFile)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulator>([&](ICurrentAppSimulator const& f) { return f.ReloadSimulatorAsync(simulatorSettingsFile); });
    }
    inline auto CurrentAppSimulator::LoadListingInformationByProductIdsAsync(param::async_iterable<hstring> const& productIds)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulatorStaticsWithFiltering>([&](ICurrentAppSimulatorStaticsWithFiltering const& f) { return f.LoadListingInformationByProductIdsAsync(productIds); });
    }
    inline auto CurrentAppSimulator::LoadListingInformationByKeywordsAsync(param::async_iterable<hstring> const& keywords)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulatorStaticsWithFiltering>([&](ICurrentAppSimulatorStaticsWithFiltering const& f) { return f.LoadListingInformationByKeywordsAsync(keywords); });
    }
    inline auto CurrentAppSimulator::GetAppPurchaseCampaignIdAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<hstring>(*)(ICurrentAppSimulatorWithCampaignId const&), CurrentAppSimulator, ICurrentAppSimulatorWithCampaignId>([](ICurrentAppSimulatorWithCampaignId const& f) { return f.GetAppPurchaseCampaignIdAsync(); });
    }
    inline auto CurrentAppSimulator::ReportConsumableFulfillmentAsync(param::hstring const& productId, winrt::guid const& transactionId)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulatorWithConsumables>([&](ICurrentAppSimulatorWithConsumables const& f) { return f.ReportConsumableFulfillmentAsync(productId, transactionId); });
    }
    inline auto CurrentAppSimulator::RequestProductPurchaseAsync(param::hstring const& productId)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulatorWithConsumables>([&](ICurrentAppSimulatorWithConsumables const& f) { return f.RequestProductPurchaseAsync(productId); });
    }
    inline auto CurrentAppSimulator::RequestProductPurchaseAsync(param::hstring const& productId, param::hstring const& offerId, winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties const& displayProperties)
    {
        return impl::call_factory<CurrentAppSimulator, ICurrentAppSimulatorWithConsumables>([&](ICurrentAppSimulatorWithConsumables const& f) { return f.RequestProductPurchaseAsync(productId, offerId, displayProperties); });
    }
    inline auto CurrentAppSimulator::GetUnfulfilledConsumablesAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable>>(*)(ICurrentAppSimulatorWithConsumables const&), CurrentAppSimulator, ICurrentAppSimulatorWithConsumables>([](ICurrentAppSimulatorWithConsumables const& f) { return f.GetUnfulfilledConsumablesAsync(); });
    }
    inline ProductPurchaseDisplayProperties::ProductPurchaseDisplayProperties() :
        ProductPurchaseDisplayProperties(impl::call_factory_cast<ProductPurchaseDisplayProperties(*)(winrt::Windows::Foundation::IActivationFactory const&), ProductPurchaseDisplayProperties>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ProductPurchaseDisplayProperties>(); }))
    {
    }
    inline ProductPurchaseDisplayProperties::ProductPurchaseDisplayProperties(param::hstring const& name) :
        ProductPurchaseDisplayProperties(impl::call_factory<ProductPurchaseDisplayProperties, IProductPurchaseDisplayPropertiesFactory>([&](IProductPurchaseDisplayPropertiesFactory const& f) { return f.CreateProductPurchaseDisplayProperties(name); }))
    {
    }
    template <typename L> LicenseChangedEventHandler::LicenseChangedEventHandler(L handler) :
        LicenseChangedEventHandler(impl::make_delegate<LicenseChangedEventHandler>(std::forward<L>(handler)))
    {
    }
    template <typename F> LicenseChangedEventHandler::LicenseChangedEventHandler(F* handler) :
        LicenseChangedEventHandler([=](auto&&... args) { return handler(args...); })
    {
    }
    template <typename O, typename M> LicenseChangedEventHandler::LicenseChangedEventHandler(O* object, M method) :
        LicenseChangedEventHandler([=](auto&&... args) { return ((*object).*(method))(args...); })
    {
    }
    template <typename O, typename M> LicenseChangedEventHandler::LicenseChangedEventHandler(com_ptr<O>&& object, M method) :
        LicenseChangedEventHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> LicenseChangedEventHandler::LicenseChangedEventHandler(weak_ref<O>&& object, LM&& lambda_or_method) :
        LicenseChangedEventHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.get()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    template <typename O, typename M> LicenseChangedEventHandler::LicenseChangedEventHandler(std::shared_ptr<O>&& object, M method) :
        LicenseChangedEventHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> LicenseChangedEventHandler::LicenseChangedEventHandler(std::weak_ptr<O>&& object, LM&& lambda_or_method) :
        LicenseChangedEventHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.lock()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    inline auto LicenseChangedEventHandler::operator()() const
    {
        check_hresult((*(impl::abi_t<LicenseChangedEventHandler>**)this)->Invoke());
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentApp> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentApp2Statics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulator> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorStaticsWithFiltering> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithCampaignId> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppSimulatorWithConsumables> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppStaticsWithFiltering> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppWithCampaignId> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ICurrentAppWithConsumables> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ILicenseInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IListingInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IListingInformation2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductLicense> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductLicenseWithFulfillment> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductListing> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductListing2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductListingWithConsumables> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductListingWithMetadata> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IProductPurchaseDisplayPropertiesFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IPurchaseResults> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::IUnfulfilledConsumable> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::CurrentApp> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::CurrentAppSimulator> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::LicenseInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ListingInformation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ProductLicense> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ProductListing> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::ProductPurchaseDisplayProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::PurchaseResults> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::UnfulfilledConsumable> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
