// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Phone_Notification_Management_2_H
#define WINRT_Windows_Phone_Notification_Management_2_H
#include "winrt/impl/Windows.Foundation.1.h"
#include "winrt/impl/Windows.Foundation.Collections.1.h"
#include "winrt/impl/Windows.Phone.Notification.Management.1.h"
WINRT_EXPORT namespace winrt::Windows::Phone::Notification::Management
{
    struct AccessoryManager
    {
        AccessoryManager() = delete;
        static auto RegisterAccessoryApp();
        static auto GetNextTriggerDetails();
        static auto ProcessTriggerDetails(winrt::Windows::Phone::Notification::Management::IAccessoryNotificationTriggerDetails const& pDetails);
        [[nodiscard]] static auto PhoneLineDetails();
        static auto GetPhoneLineDetails(winrt::guid const& phoneLine);
        static auto AcceptPhoneCall(uint32_t phoneCallId);
        static auto AcceptPhoneCall(uint32_t phoneCallId, winrt::Windows::Phone::Notification::Management::PhoneCallAudioEndpoint const& endPoint);
        static auto AcceptPhoneCallWithVideo(uint32_t phoneCallId);
        static auto AcceptPhoneCallWithVideo(uint32_t phoneCallId, winrt::Windows::Phone::Notification::Management::PhoneCallAudioEndpoint const& endPoint);
        static auto RejectPhoneCall(uint32_t phoneCallId);
        static auto RejectPhoneCall(uint32_t phoneCallId, uint32_t textResponseID);
        static auto MakePhoneCall(winrt::guid const& phoneLine, param::hstring const& phoneNumber);
        static auto MakePhoneCall(winrt::guid const& phoneLine, param::hstring const& phoneNumber, winrt::Windows::Phone::Notification::Management::PhoneCallAudioEndpoint const& endPoint);
        static auto MakePhoneCallWithVideo(winrt::guid const& phoneLine, param::hstring const& phoneNumber);
        static auto MakePhoneCallWithVideo(winrt::guid const& phoneLine, param::hstring const& phoneNumber, winrt::Windows::Phone::Notification::Management::PhoneCallAudioEndpoint const& endPoint);
        static auto SwapPhoneCalls(uint32_t phoneCallIdToHold, uint32_t phoneCallIdOnHold);
        static auto HoldPhoneCall(uint32_t phoneCallId, bool holdCall);
        static auto EndPhoneCall(uint32_t phoneCallId);
        static auto PhoneMute(bool value);
        [[nodiscard]] static auto PhoneMute();
        static auto PhoneCallAudioEndpoint(winrt::Windows::Phone::Notification::Management::PhoneCallAudioEndpoint const& value);
        [[nodiscard]] static auto PhoneCallAudioEndpoint();
        static auto SnoozeAlarm(winrt::guid const& alarmId);
        static auto SnoozeAlarm(winrt::guid const& alarmId, winrt::Windows::Foundation::TimeSpan const& timeSpan);
        static auto DismissAlarm(winrt::guid const& alarmId);
        static auto SnoozeReminder(winrt::guid const& reminderId);
        static auto SnoozeReminder(winrt::guid const& reminderId, winrt::Windows::Foundation::TimeSpan const& timeSpan);
        static auto DismissReminder(winrt::guid const& reminderId);
        static auto GetMediaMetadata();
        [[nodiscard]] static auto MediaPlaybackCapabilities();
        [[nodiscard]] static auto MediaPlaybackStatus();
        static auto PerformMediaPlaybackCommand(winrt::Windows::Phone::Notification::Management::PlaybackCommand const& command);
        [[nodiscard]] static auto DoNotDisturbEnabled();
        [[nodiscard]] static auto DrivingModeEnabled();
        [[nodiscard]] static auto BatterySaverState();
        static auto GetApps();
        static auto EnableNotificationsForApplication(param::hstring const& appId);
        static auto DisableNotificationsForApplication(param::hstring const& appId);
        static auto IsNotificationEnabledForApplication(param::hstring const& appId);
        static auto GetEnabledAccessoryNotificationTypes();
        static auto EnableAccessoryNotificationTypes(int32_t accessoryNotificationTypes);
        static auto DisableAllAccessoryNotificationTypes();
        static auto GetUserConsent();
        static auto GetAppIcon(param::hstring const& appId);
        static auto RingDevice();
        [[nodiscard]] static auto SpeedDialList();
        static auto ClearToast(param::hstring const& instanceId);
        [[nodiscard]] static auto IsPhonePinLocked();
        static auto IncreaseVolume(int32_t step);
        static auto DecreaseVolume(int32_t step);
        static auto SetMute(bool mute);
        static auto SetRingerVibrate(bool ringer, bool vibrate);
        [[nodiscard]] static auto VolumeInfo();
        static auto GetAllEmailAccounts();
        static auto GetFolders(param::hstring const& emailAccount);
        static auto EnableEmailNotificationEmailAccount(param::hstring const& emailAccount);
        static auto DisableEmailNotificationEmailAccount(param::hstring const& emailAccount);
        static auto EnableEmailNotificationFolderFilter(param::hstring const& emailAccount, param::vector_view<hstring> const& folders);
        static auto UpdateEmailReadStatus(winrt::Windows::Phone::Notification::Management::BinaryId const& messageEntryId, bool isRead);
        static auto SnoozeAlarmByInstanceId(param::hstring const& instanceId);
        static auto DismissAlarmByInstanceId(param::hstring const& instanceId);
        static auto SnoozeReminderByInstanceId(param::hstring const& instanceId);
        static auto DismissReminderByInstanceId(param::hstring const& instanceId);
    };
    struct WINRT_IMPL_EMPTY_BASES AlarmNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IAlarmNotificationTriggerDetails,
        impl::require<AlarmNotificationTriggerDetails, winrt::Windows::Phone::Notification::Management::IAlarmNotificationTriggerDetails2>
    {
        AlarmNotificationTriggerDetails(std::nullptr_t) noexcept {}
        AlarmNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IAlarmNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES AppNotificationInfo : winrt::Windows::Phone::Notification::Management::IAppNotificationInfo
    {
        AppNotificationInfo(std::nullptr_t) noexcept {}
        AppNotificationInfo(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IAppNotificationInfo(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES BinaryId : winrt::Windows::Phone::Notification::Management::IBinaryId
    {
        BinaryId(std::nullptr_t) noexcept {}
        BinaryId(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IBinaryId(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES CalendarChangedNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::ICalendarChangedNotificationTriggerDetails
    {
        CalendarChangedNotificationTriggerDetails(std::nullptr_t) noexcept {}
        CalendarChangedNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::ICalendarChangedNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES CortanaTileNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::ICortanaTileNotificationTriggerDetails
    {
        CortanaTileNotificationTriggerDetails(std::nullptr_t) noexcept {}
        CortanaTileNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::ICortanaTileNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES EmailAccountInfo : winrt::Windows::Phone::Notification::Management::IEmailAccountInfo
    {
        EmailAccountInfo(std::nullptr_t) noexcept {}
        EmailAccountInfo(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IEmailAccountInfo(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES EmailFolderInfo : winrt::Windows::Phone::Notification::Management::IEmailFolderInfo
    {
        EmailFolderInfo(std::nullptr_t) noexcept {}
        EmailFolderInfo(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IEmailFolderInfo(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES EmailNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IEmailNotificationTriggerDetails,
        impl::require<EmailNotificationTriggerDetails, winrt::Windows::Phone::Notification::Management::IEmailNotificationTriggerDetails2>
    {
        EmailNotificationTriggerDetails(std::nullptr_t) noexcept {}
        EmailNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IEmailNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES EmailReadNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IEmailReadNotificationTriggerDetails
    {
        EmailReadNotificationTriggerDetails(std::nullptr_t) noexcept {}
        EmailReadNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IEmailReadNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES MediaControlsTriggerDetails : winrt::Windows::Phone::Notification::Management::IMediaControlsTriggerDetails
    {
        MediaControlsTriggerDetails(std::nullptr_t) noexcept {}
        MediaControlsTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IMediaControlsTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES MediaMetadata : winrt::Windows::Phone::Notification::Management::IMediaMetadata
    {
        MediaMetadata(std::nullptr_t) noexcept {}
        MediaMetadata(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IMediaMetadata(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES PhoneCallDetails : winrt::Windows::Phone::Notification::Management::IPhoneCallDetails
    {
        PhoneCallDetails(std::nullptr_t) noexcept {}
        PhoneCallDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IPhoneCallDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES PhoneLineDetails : winrt::Windows::Phone::Notification::Management::IPhoneLineDetails,
        impl::require<PhoneLineDetails, winrt::Windows::Phone::Notification::Management::IPhoneLineDetails2>
    {
        PhoneLineDetails(std::nullptr_t) noexcept {}
        PhoneLineDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IPhoneLineDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES PhoneNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IPhoneNotificationTriggerDetails
    {
        PhoneNotificationTriggerDetails(std::nullptr_t) noexcept {}
        PhoneNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IPhoneNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES ReminderNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IReminderNotificationTriggerDetails,
        impl::require<ReminderNotificationTriggerDetails, winrt::Windows::Phone::Notification::Management::IReminderNotificationTriggerDetails2>
    {
        ReminderNotificationTriggerDetails(std::nullptr_t) noexcept {}
        ReminderNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IReminderNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES SpeedDialEntry : winrt::Windows::Phone::Notification::Management::ISpeedDialEntry
    {
        SpeedDialEntry(std::nullptr_t) noexcept {}
        SpeedDialEntry(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::ISpeedDialEntry(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES TextResponse : winrt::Windows::Phone::Notification::Management::ITextResponse
    {
        TextResponse(std::nullptr_t) noexcept {}
        TextResponse(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::ITextResponse(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES ToastNotificationTriggerDetails : winrt::Windows::Phone::Notification::Management::IToastNotificationTriggerDetails,
        impl::require<ToastNotificationTriggerDetails, winrt::Windows::Phone::Notification::Management::IToastNotificationTriggerDetails2>
    {
        ToastNotificationTriggerDetails(std::nullptr_t) noexcept {}
        ToastNotificationTriggerDetails(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IToastNotificationTriggerDetails(ptr, take_ownership_from_abi) {}
    };
    struct WINRT_IMPL_EMPTY_BASES VolumeInfo : winrt::Windows::Phone::Notification::Management::IVolumeInfo
    {
        VolumeInfo(std::nullptr_t) noexcept {}
        VolumeInfo(void* ptr, take_ownership_from_abi_t) noexcept : winrt::Windows::Phone::Notification::Management::IVolumeInfo(ptr, take_ownership_from_abi) {}
    };
}
#endif
