// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_ApplicationModel_Store_Preview_InstallControl_H
#define WINRT_Windows_ApplicationModel_Store_Preview_InstallControl_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.ApplicationModel.Store.Preview.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Management.Deployment.2.h"
#include "winrt/impl/Windows.System.2.h"
#include "winrt/impl/Windows.ApplicationModel.Store.Preview.InstallControl.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::ProductId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->get_ProductId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::PackageFamilyName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PackageFamilyName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->get_PackageFamilyName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::InstallType() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InstallType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->get_InstallType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::IsUserInitiated() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsUserInitiated(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->get_IsUserInitiated(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::GetCurrentStatus() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCurrentStatus(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->GetCurrentStatus(&result));
        }
        return winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallStatus{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Cancel() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Cancel());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->Cancel());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Pause() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Pause());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->Pause());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Restart() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Restart());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->Restart());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Completed(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->add_Completed(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Completed(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, Completed_revoker>(this, Completed(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::Completed(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            _winrt_abi_type->remove_Completed(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::StatusChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StatusChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            check_hresult(_winrt_abi_type->add_StatusChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::StatusChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, StatusChanged_revoker>(this, StatusChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem<D>::StatusChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StatusChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>**)this;
            _winrt_abi_type->remove_StatusChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem2<D>::Cancel(param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CancelWithTelemetry(*(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)this;
            check_hresult(_winrt_abi_type->CancelWithTelemetry(*(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem2<D>::Pause(param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PauseWithTelemetry(*(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)this;
            check_hresult(_winrt_abi_type->PauseWithTelemetry(*(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem2<D>::Restart(param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RestartWithTelemetry(*(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>**)this;
            check_hresult(_winrt_abi_type->RestartWithTelemetry(*(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem3<D>::Children() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>**)this;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem3<D>::ItemOperationsMightAffectOtherItems() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ItemOperationsMightAffectOtherItems(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>**)this;
            check_hresult(_winrt_abi_type->get_ItemOperationsMightAffectOtherItems(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem4<D>::LaunchAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LaunchAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>**)this;
            check_hresult(_winrt_abi_type->get_LaunchAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem4<D>::LaunchAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LaunchAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>**)this;
            check_hresult(_winrt_abi_type->put_LaunchAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToDesktopAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToDesktopAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->get_PinToDesktopAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToDesktopAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToDesktopAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->put_PinToDesktopAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToStartAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToStartAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->get_PinToStartAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToStartAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToStartAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->put_PinToStartAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToTaskbarAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToTaskbarAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->get_PinToTaskbarAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::PinToTaskbarAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToTaskbarAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->put_PinToTaskbarAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::CompletedInstallToastNotificationMode() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompletedInstallToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->get_CompletedInstallToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::CompletedInstallToastNotificationMode(winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CompletedInstallToastNotificationMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->put_CompletedInstallToastNotificationMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::InstallInProgressToastNotificationMode() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InstallInProgressToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->get_InstallInProgressToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallItem5<D>::InstallInProgressToastNotificationMode(winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InstallInProgressToastNotificationMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>**)this;
            check_hresult(_winrt_abi_type->put_InstallInProgressToastNotificationMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::AppInstallItems() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppInstallItems(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->get_AppInstallItems(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::Cancel(param::hstring const& productId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Cancel(*(void**)(&productId)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->Cancel(*(void**)(&productId)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::Pause(param::hstring const& productId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Pause(*(void**)(&productId)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->Pause(*(void**)(&productId)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::Restart(param::hstring const& productId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Restart(*(void**)(&productId)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->Restart(*(void**)(&productId)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemCompleted(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ItemCompleted(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->add_ItemCompleted(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemCompleted(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ItemCompleted_revoker>(this, ItemCompleted(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemCompleted(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ItemCompleted(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            _winrt_abi_type->remove_ItemCompleted(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemStatusChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ItemStatusChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->add_ItemStatusChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemStatusChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ItemStatusChanged_revoker>(this, ItemStatusChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::ItemStatusChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ItemStatusChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            _winrt_abi_type->remove_ItemStatusChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::AutoUpdateSetting() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AutoUpdateSetting value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AutoUpdateSetting(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->get_AutoUpdateSetting(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::AutoUpdateSetting(winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AutoUpdateSetting const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AutoUpdateSetting(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->put_AutoUpdateSetting(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::AcquisitionIdentity() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AcquisitionIdentity(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->get_AcquisitionIdentity(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::AcquisitionIdentity(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AcquisitionIdentity(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->put_AcquisitionIdentity(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::GetIsApplicableAsync(param::hstring const& productId, param::hstring const& skuId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsApplicableAsync(*(void**)(&productId), *(void**)(&skuId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->GetIsApplicableAsync(*(void**)(&productId), *(void**)(&skuId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::StartAppInstallAsync(param::hstring const& productId, param::hstring const& skuId, bool repair, bool forceUseOfNonRemovableStorage) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAppInstallAsync(*(void**)(&productId), *(void**)(&skuId), repair, forceUseOfNonRemovableStorage, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->StartAppInstallAsync(*(void**)(&productId), *(void**)(&skuId), repair, forceUseOfNonRemovableStorage, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::UpdateAppByPackageFamilyNameAsync(param::hstring const& packageFamilyName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameAsync(*(void**)(&packageFamilyName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameAsync(*(void**)(&packageFamilyName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::SearchForUpdatesAsync(param::hstring const& productId, param::hstring const& skuId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForUpdatesAsync(*(void**)(&productId), *(void**)(&skuId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->SearchForUpdatesAsync(*(void**)(&productId), *(void**)(&skuId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::SearchForAllUpdatesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::IsStoreBlockedByPolicyAsync(param::hstring const& storeClientName, param::hstring const& storeClientPublisher) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsStoreBlockedByPolicyAsync(*(void**)(&storeClientName), *(void**)(&storeClientPublisher), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->IsStoreBlockedByPolicyAsync(*(void**)(&storeClientName), *(void**)(&storeClientPublisher), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager<D>::GetIsAppAllowedToInstallAsync(param::hstring const& productId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallAsync(*(void**)(&productId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>**)this;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallAsync(*(void**)(&productId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::StartAppInstallAsync(param::hstring const& productId, param::hstring const& skuId, bool repair, bool forceUseOfNonRemovableStorage, param::hstring const& catalogId, param::hstring const& bundleId, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartAppInstallWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), repair, forceUseOfNonRemovableStorage, *(void**)(&catalogId), *(void**)(&bundleId), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->StartAppInstallWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), repair, forceUseOfNonRemovableStorage, *(void**)(&catalogId), *(void**)(&bundleId), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::UpdateAppByPackageFamilyNameAsync(param::hstring const& packageFamilyName, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameWithTelemetryAsync(*(void**)(&packageFamilyName), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameWithTelemetryAsync(*(void**)(&packageFamilyName), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::SearchForUpdatesAsync(param::hstring const& productId, param::hstring const& skuId, param::hstring const& catalogId, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::SearchForAllUpdatesAsync(param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithTelemetryAsync(*(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithTelemetryAsync(*(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::GetIsAppAllowedToInstallAsync(param::hstring const& productId, param::hstring const& skuId, param::hstring const& catalogId, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallWithTelemetryAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::Cancel(param::hstring const& productId, param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CancelWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->CancelWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::Pause(param::hstring const& productId, param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->PauseWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->PauseWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager2<D>::Restart(param::hstring const& productId, param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RestartWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>**)this;
            check_hresult(_winrt_abi_type->RestartWithTelemetry(*(void**)(&productId), *(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::StartProductInstallAsync(param::hstring const& productId, param::hstring const& catalogId, param::hstring const& flightId, param::hstring const& clientId, bool repair, bool forceUseOfNonRemovableStorage, param::hstring const& correlationVector, winrt::Windows::Management::Deployment::PackageVolume const& targetVolume) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartProductInstallAsync(*(void**)(&productId), *(void**)(&catalogId), *(void**)(&flightId), *(void**)(&clientId), repair, forceUseOfNonRemovableStorage, *(void**)(&correlationVector), *(void**)(&targetVolume), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->StartProductInstallAsync(*(void**)(&productId), *(void**)(&catalogId), *(void**)(&flightId), *(void**)(&clientId), repair, forceUseOfNonRemovableStorage, *(void**)(&correlationVector), *(void**)(&targetVolume), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::StartProductInstallForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& catalogId, param::hstring const& flightId, param::hstring const& clientId, bool repair, bool forceUseOfNonRemovableStorage, param::hstring const& correlationVector, winrt::Windows::Management::Deployment::PackageVolume const& targetVolume) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartProductInstallForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&catalogId), *(void**)(&flightId), *(void**)(&clientId), repair, forceUseOfNonRemovableStorage, *(void**)(&correlationVector), *(void**)(&targetVolume), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->StartProductInstallForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&catalogId), *(void**)(&flightId), *(void**)(&clientId), repair, forceUseOfNonRemovableStorage, *(void**)(&correlationVector), *(void**)(&targetVolume), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::UpdateAppByPackageFamilyNameForUserAsync(winrt::Windows::System::User const& user, param::hstring const& packageFamilyName, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameForUserAsync(*(void**)(&user), *(void**)(&packageFamilyName), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->UpdateAppByPackageFamilyNameForUserAsync(*(void**)(&user), *(void**)(&packageFamilyName), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::SearchForUpdatesForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& skuId, param::hstring const& catalogId, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForUpdatesForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->SearchForUpdatesForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::SearchForAllUpdatesForUserAsync(winrt::Windows::System::User const& user, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesForUserAsync(*(void**)(&user), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesForUserAsync(*(void**)(&user), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::GetIsAppAllowedToInstallForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& skuId, param::hstring const& catalogId, param::hstring const& correlationVector) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->GetIsAppAllowedToInstallForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&catalogId), *(void**)(&correlationVector), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::GetIsApplicableForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& skuId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsApplicableForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->GetIsApplicableForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager3<D>::MoveToFrontOfDownloadQueue(param::hstring const& productId, param::hstring const& correlationVector) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MoveToFrontOfDownloadQueue(*(void**)(&productId), *(void**)(&correlationVector)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>**)this;
            check_hresult(_winrt_abi_type->MoveToFrontOfDownloadQueue(*(void**)(&productId), *(void**)(&correlationVector)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager4<D>::GetFreeUserEntitlementAsync(param::hstring const& storeId, param::hstring const& campaignId, param::hstring const& correlationVector) const
    {
        void* ppAsyncOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFreeUserEntitlementAsync(*(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)this;
            check_hresult(_winrt_abi_type->GetFreeUserEntitlementAsync(*(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>{ ppAsyncOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager4<D>::GetFreeUserEntitlementForUserAsync(winrt::Windows::System::User const& user, param::hstring const& storeId, param::hstring const& campaignId, param::hstring const& correlationVector) const
    {
        void* ppAsyncOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFreeUserEntitlementForUserAsync(*(void**)(&user), *(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)this;
            check_hresult(_winrt_abi_type->GetFreeUserEntitlementForUserAsync(*(void**)(&user), *(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>{ ppAsyncOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager4<D>::GetFreeDeviceEntitlementAsync(param::hstring const& storeId, param::hstring const& campaignId, param::hstring const& correlationVector) const
    {
        void* ppAsyncOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFreeDeviceEntitlementAsync(*(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>**)this;
            check_hresult(_winrt_abi_type->GetFreeDeviceEntitlementAsync(*(void**)(&storeId), *(void**)(&campaignId), *(void**)(&correlationVector), &ppAsyncOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>{ ppAsyncOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager5<D>::AppInstallItemsWithGroupSupport() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppInstallItemsWithGroupSupport(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5>**)this;
            check_hresult(_winrt_abi_type->get_AppInstallItemsWithGroupSupport(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::SearchForAllUpdatesAsync(param::hstring const& correlationVector, param::hstring const& clientId, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const& updateOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithUpdateOptionsAsync(*(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithUpdateOptionsAsync(*(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::SearchForAllUpdatesForUserAsync(winrt::Windows::System::User const& user, param::hstring const& correlationVector, param::hstring const& clientId, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const& updateOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithUpdateOptionsForUserAsync(*(void**)(&user), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->SearchForAllUpdatesWithUpdateOptionsForUserAsync(*(void**)(&user), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::SearchForUpdatesAsync(param::hstring const& productId, param::hstring const& skuId, param::hstring const& correlationVector, param::hstring const& clientId, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const& updateOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithUpdateOptionsAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithUpdateOptionsAsync(*(void**)(&productId), *(void**)(&skuId), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::SearchForUpdatesForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& skuId, param::hstring const& correlationVector, param::hstring const& clientId, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const& updateOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithUpdateOptionsForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->SearchForUpdatesWithUpdateOptionsForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&skuId), *(void**)(&correlationVector), *(void**)(&clientId), *(void**)(&updateOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::StartProductInstallAsync(param::hstring const& productId, param::hstring const& flightId, param::hstring const& clientId, param::hstring const& correlationVector, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallOptions const& installOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartProductInstallWithOptionsAsync(*(void**)(&productId), *(void**)(&flightId), *(void**)(&clientId), *(void**)(&correlationVector), *(void**)(&installOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->StartProductInstallWithOptionsAsync(*(void**)(&productId), *(void**)(&flightId), *(void**)(&clientId), *(void**)(&correlationVector), *(void**)(&installOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::StartProductInstallForUserAsync(winrt::Windows::System::User const& user, param::hstring const& productId, param::hstring const& flightId, param::hstring const& clientId, param::hstring const& correlationVector, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallOptions const& installOptions) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartProductInstallWithOptionsForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&flightId), *(void**)(&clientId), *(void**)(&correlationVector), *(void**)(&installOptions), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->StartProductInstallWithOptionsForUserAsync(*(void**)(&user), *(void**)(&productId), *(void**)(&flightId), *(void**)(&clientId), *(void**)(&correlationVector), *(void**)(&installOptions), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::GetIsPackageIdentityAllowedToInstallAsync(param::hstring const& correlationVector, param::hstring const& packageIdentityName, param::hstring const& publisherCertificateName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsPackageIdentityAllowedToInstallAsync(*(void**)(&correlationVector), *(void**)(&packageIdentityName), *(void**)(&publisherCertificateName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->GetIsPackageIdentityAllowedToInstallAsync(*(void**)(&correlationVector), *(void**)(&packageIdentityName), *(void**)(&publisherCertificateName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager6<D>::GetIsPackageIdentityAllowedToInstallForUserAsync(winrt::Windows::System::User const& user, param::hstring const& correlationVector, param::hstring const& packageIdentityName, param::hstring const& publisherCertificateName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetIsPackageIdentityAllowedToInstallForUserAsync(*(void**)(&user), *(void**)(&correlationVector), *(void**)(&packageIdentityName), *(void**)(&publisherCertificateName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>**)this;
            check_hresult(_winrt_abi_type->GetIsPackageIdentityAllowedToInstallForUserAsync(*(void**)(&user), *(void**)(&correlationVector), *(void**)(&packageIdentityName), *(void**)(&publisherCertificateName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManager7<D>::CanInstallForAllUsers() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanInstallForAllUsers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7>**)this;
            check_hresult(_winrt_abi_type->get_CanInstallForAllUsers(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallManagerItemEventArgs<D>::Item() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Item(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Item(&value));
        }
        return winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::CatalogId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CatalogId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_CatalogId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::CatalogId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CatalogId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_CatalogId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::ForceUseOfNonRemovableStorage() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ForceUseOfNonRemovableStorage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_ForceUseOfNonRemovableStorage(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::ForceUseOfNonRemovableStorage(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ForceUseOfNonRemovableStorage(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_ForceUseOfNonRemovableStorage(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::AllowForcedAppRestart() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowForcedAppRestart(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_AllowForcedAppRestart(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::AllowForcedAppRestart(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowForcedAppRestart(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_AllowForcedAppRestart(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::Repair() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Repair(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_Repair(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::Repair(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Repair(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_Repair(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::TargetVolume() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetVolume(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_TargetVolume(&value));
        }
        return winrt::Windows::Management::Deployment::PackageVolume{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::TargetVolume(winrt::Windows::Management::Deployment::PackageVolume const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetVolume(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_TargetVolume(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::LaunchAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LaunchAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->get_LaunchAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions<D>::LaunchAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LaunchAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>**)this;
            check_hresult(_winrt_abi_type->put_LaunchAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToDesktopAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToDesktopAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_PinToDesktopAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToDesktopAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToDesktopAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_PinToDesktopAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToStartAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToStartAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_PinToStartAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToStartAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToStartAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_PinToStartAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToTaskbarAfterInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinToTaskbarAfterInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_PinToTaskbarAfterInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::PinToTaskbarAfterInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_PinToTaskbarAfterInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_PinToTaskbarAfterInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::CompletedInstallToastNotificationMode() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CompletedInstallToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_CompletedInstallToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::CompletedInstallToastNotificationMode(winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CompletedInstallToastNotificationMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_CompletedInstallToastNotificationMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::InstallInProgressToastNotificationMode() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InstallInProgressToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_InstallInProgressToastNotificationMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::InstallInProgressToastNotificationMode(winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InstallInProgressToastNotificationMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_InstallInProgressToastNotificationMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::InstallForAllUsers() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InstallForAllUsers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_InstallForAllUsers(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::InstallForAllUsers(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_InstallForAllUsers(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_InstallForAllUsers(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::StageButDoNotInstall() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_StageButDoNotInstall(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_StageButDoNotInstall(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::StageButDoNotInstall(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_StageButDoNotInstall(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_StageButDoNotInstall(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::CampaignId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CampaignId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_CampaignId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::CampaignId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CampaignId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_CampaignId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::ExtendedCampaignId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedCampaignId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedCampaignId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallOptions2<D>::ExtendedCampaignId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ExtendedCampaignId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>**)this;
            check_hresult(_winrt_abi_type->put_ExtendedCampaignId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus<D>::InstallState() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallState value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InstallState(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)this;
            check_hresult(_winrt_abi_type->get_InstallState(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus<D>::DownloadSizeInBytes() const
    {
        uint64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DownloadSizeInBytes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)this;
            check_hresult(_winrt_abi_type->get_DownloadSizeInBytes(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus<D>::BytesDownloaded() const
    {
        uint64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BytesDownloaded(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)this;
            check_hresult(_winrt_abi_type->get_BytesDownloaded(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus<D>::PercentComplete() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PercentComplete(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)this;
            check_hresult(_winrt_abi_type->get_PercentComplete(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus<D>::ErrorCode() const
    {
        winrt::hresult value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ErrorCode(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>**)this;
            check_hresult(_winrt_abi_type->get_ErrorCode(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus2<D>::User() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_User(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>**)this;
            check_hresult(_winrt_abi_type->get_User(&value));
        }
        return winrt::Windows::System::User{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus2<D>::ReadyForLaunch() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReadyForLaunch(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>**)this;
            check_hresult(_winrt_abi_type->get_ReadyForLaunch(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppInstallStatus3<D>::IsStaged() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsStaged(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3>**)this;
            check_hresult(_winrt_abi_type->get_IsStaged(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions<D>::CatalogId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CatalogId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)this;
            check_hresult(_winrt_abi_type->get_CatalogId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions<D>::CatalogId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CatalogId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)this;
            check_hresult(_winrt_abi_type->put_CatalogId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions<D>::AllowForcedAppRestart() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowForcedAppRestart(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)this;
            check_hresult(_winrt_abi_type->get_AllowForcedAppRestart(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions<D>::AllowForcedAppRestart(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AllowForcedAppRestart(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>**)this;
            check_hresult(_winrt_abi_type->put_AllowForcedAppRestart(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions2<D>::AutomaticallyDownloadAndInstallUpdateIfFound() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AutomaticallyDownloadAndInstallUpdateIfFound(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>**)this;
            check_hresult(_winrt_abi_type->get_AutomaticallyDownloadAndInstallUpdateIfFound(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IAppUpdateOptions2<D>::AutomaticallyDownloadAndInstallUpdateIfFound(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_AutomaticallyDownloadAndInstallUpdateIfFound(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>**)this;
            check_hresult(_winrt_abi_type->put_AutomaticallyDownloadAndInstallUpdateIfFound(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IGetEntitlementResult<D>::Status() const
    {
        winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IGetEntitlementResult2<D>::IsAlreadyOwned() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAlreadyOwned(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)this;
            check_hresult(_winrt_abi_type->get_IsAlreadyOwned(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IGetEntitlementResult2<D>::OrderId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OrderId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)this;
            check_hresult(_winrt_abi_type->get_OrderId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IGetEntitlementResult2<D>::SkuId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SkuId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)this;
            check_hresult(_winrt_abi_type->get_SkuId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Store_Preview_InstallControl_IGetEntitlementResult2<D>::AvailabilityId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AvailabilityId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>**)this;
            check_hresult(_winrt_abi_type->get_AvailabilityId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem>
    {
        int32_t __stdcall get_ProductId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProductId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PackageFamilyName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PackageFamilyName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InstallType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallType>(this->shim().InstallType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsUserInitiated(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsUserInitiated());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCurrentStatus(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallStatus>(this->shim().GetCurrentStatus());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Cancel() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Cancel();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Pause() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Restart() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restart();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_Completed(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Completed(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Completed(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Completed(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_StatusChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StatusChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StatusChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StatusChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2>
    {
        int32_t __stdcall CancelWithTelemetry(void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Cancel(*reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall PauseWithTelemetry(void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause(*reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RestartWithTelemetry(void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restart(*reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3>
    {
        int32_t __stdcall get_Children(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().Children());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ItemOperationsMightAffectOtherItems(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().ItemOperationsMightAffectOtherItems());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4>
    {
        int32_t __stdcall get_LaunchAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().LaunchAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LaunchAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LaunchAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5>
    {
        int32_t __stdcall get_PinToDesktopAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToDesktopAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToDesktopAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToDesktopAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PinToStartAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToStartAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToStartAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToStartAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PinToTaskbarAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToTaskbarAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToTaskbarAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToTaskbarAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CompletedInstallToastNotificationMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode>(this->shim().CompletedInstallToastNotificationMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CompletedInstallToastNotificationMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CompletedInstallToastNotificationMode(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InstallInProgressToastNotificationMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode>(this->shim().InstallInProgressToastNotificationMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InstallInProgressToastNotificationMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InstallInProgressToastNotificationMode(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager>
    {
        int32_t __stdcall get_AppInstallItems(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().AppInstallItems());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Cancel(void* productId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Cancel(*reinterpret_cast<hstring const*>(&productId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Pause(void* productId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause(*reinterpret_cast<hstring const*>(&productId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Restart(void* productId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restart(*reinterpret_cast<hstring const*>(&productId));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ItemCompleted(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ItemCompleted(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ItemCompleted(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ItemCompleted(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_ItemStatusChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ItemStatusChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ItemStatusChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ItemStatusChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall get_AutoUpdateSetting(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AutoUpdateSetting>(this->shim().AutoUpdateSetting());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AutoUpdateSetting(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AutoUpdateSetting(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AutoUpdateSetting const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AcquisitionIdentity(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AcquisitionIdentity());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AcquisitionIdentity(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcquisitionIdentity(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsApplicableAsync(void* productId, void* skuId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsApplicableAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartAppInstallAsync(void* productId, void* skuId, bool repair, bool forceUseOfNonRemovableStorage, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().StartAppInstallAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), repair, forceUseOfNonRemovableStorage));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateAppByPackageFamilyNameAsync(void* packageFamilyName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().UpdateAppByPackageFamilyNameAsync(*reinterpret_cast<hstring const*>(&packageFamilyName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForUpdatesAsync(void* productId, void* skuId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().SearchForUpdatesAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForAllUpdatesAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().SearchForAllUpdatesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsStoreBlockedByPolicyAsync(void* storeClientName, void* storeClientPublisher, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().IsStoreBlockedByPolicyAsync(*reinterpret_cast<hstring const*>(&storeClientName), *reinterpret_cast<hstring const*>(&storeClientPublisher)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsAppAllowedToInstallAsync(void* productId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsAppAllowedToInstallAsync(*reinterpret_cast<hstring const*>(&productId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2>
    {
        int32_t __stdcall StartAppInstallWithTelemetryAsync(void* productId, void* skuId, bool repair, bool forceUseOfNonRemovableStorage, void* catalogId, void* bundleId, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().StartAppInstallAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), repair, forceUseOfNonRemovableStorage, *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&bundleId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateAppByPackageFamilyNameWithTelemetryAsync(void* packageFamilyName, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().UpdateAppByPackageFamilyNameAsync(*reinterpret_cast<hstring const*>(&packageFamilyName), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForUpdatesWithTelemetryAsync(void* productId, void* skuId, void* catalogId, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().SearchForUpdatesAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForAllUpdatesWithTelemetryAsync(void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().SearchForAllUpdatesAsync(*reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsAppAllowedToInstallWithTelemetryAsync(void* productId, void* skuId, void* catalogId, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsAppAllowedToInstallAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CancelWithTelemetry(void* productId, void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Cancel(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall PauseWithTelemetry(void* productId, void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Pause(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RestartWithTelemetry(void* productId, void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Restart(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3>
    {
        int32_t __stdcall StartProductInstallAsync(void* productId, void* catalogId, void* flightId, void* clientId, bool repair, bool forceUseOfNonRemovableStorage, void* correlationVector, void* targetVolume, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().StartProductInstallAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&flightId), *reinterpret_cast<hstring const*>(&clientId), repair, forceUseOfNonRemovableStorage, *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<winrt::Windows::Management::Deployment::PackageVolume const*>(&targetVolume)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartProductInstallForUserAsync(void* user, void* productId, void* catalogId, void* flightId, void* clientId, bool repair, bool forceUseOfNonRemovableStorage, void* correlationVector, void* targetVolume, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().StartProductInstallForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&flightId), *reinterpret_cast<hstring const*>(&clientId), repair, forceUseOfNonRemovableStorage, *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<winrt::Windows::Management::Deployment::PackageVolume const*>(&targetVolume)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UpdateAppByPackageFamilyNameForUserAsync(void* user, void* packageFamilyName, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().UpdateAppByPackageFamilyNameForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&packageFamilyName), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForUpdatesForUserAsync(void* user, void* productId, void* skuId, void* catalogId, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().SearchForUpdatesForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForAllUpdatesForUserAsync(void* user, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().SearchForAllUpdatesForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsAppAllowedToInstallForUserAsync(void* user, void* productId, void* skuId, void* catalogId, void* correlationVector, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsAppAllowedToInstallForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&catalogId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsApplicableForUserAsync(void* user, void* productId, void* skuId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsApplicableForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MoveToFrontOfDownloadQueue(void* productId, void* correlationVector) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MoveToFrontOfDownloadQueue(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&correlationVector));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4>
    {
        int32_t __stdcall GetFreeUserEntitlementAsync(void* storeId, void* campaignId, void* correlationVector, void** ppAsyncOperation) noexcept final try
        {
            clear_abi(ppAsyncOperation);
            typename D::abi_guard guard(this->shim());
            *ppAsyncOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>>(this->shim().GetFreeUserEntitlementAsync(*reinterpret_cast<hstring const*>(&storeId), *reinterpret_cast<hstring const*>(&campaignId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFreeUserEntitlementForUserAsync(void* user, void* storeId, void* campaignId, void* correlationVector, void** ppAsyncOperation) noexcept final try
        {
            clear_abi(ppAsyncOperation);
            typename D::abi_guard guard(this->shim());
            *ppAsyncOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>>(this->shim().GetFreeUserEntitlementForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&storeId), *reinterpret_cast<hstring const*>(&campaignId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFreeDeviceEntitlementAsync(void* storeId, void* campaignId, void* correlationVector, void** ppAsyncOperation) noexcept final try
        {
            clear_abi(ppAsyncOperation);
            typename D::abi_guard guard(this->shim());
            *ppAsyncOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult>>(this->shim().GetFreeDeviceEntitlementAsync(*reinterpret_cast<hstring const*>(&storeId), *reinterpret_cast<hstring const*>(&campaignId), *reinterpret_cast<hstring const*>(&correlationVector)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5>
    {
        int32_t __stdcall get_AppInstallItemsWithGroupSupport(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().AppInstallItemsWithGroupSupport());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6>
    {
        int32_t __stdcall SearchForAllUpdatesWithUpdateOptionsAsync(void* correlationVector, void* clientId, void* updateOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().SearchForAllUpdatesAsync(*reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const*>(&updateOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForAllUpdatesWithUpdateOptionsForUserAsync(void* user, void* correlationVector, void* clientId, void* updateOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().SearchForAllUpdatesForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const*>(&updateOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForUpdatesWithUpdateOptionsAsync(void* productId, void* skuId, void* correlationVector, void* clientId, void* updateOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().SearchForUpdatesAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const*>(&updateOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SearchForUpdatesWithUpdateOptionsForUserAsync(void* user, void* productId, void* skuId, void* correlationVector, void* clientId, void* updateOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>(this->shim().SearchForUpdatesForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&skuId), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions const*>(&updateOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartProductInstallWithOptionsAsync(void* productId, void* flightId, void* clientId, void* correlationVector, void* installOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().StartProductInstallAsync(*reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&flightId), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallOptions const*>(&installOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartProductInstallWithOptionsForUserAsync(void* user, void* productId, void* flightId, void* clientId, void* correlationVector, void* installOptions, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>>>(this->shim().StartProductInstallForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&productId), *reinterpret_cast<hstring const*>(&flightId), *reinterpret_cast<hstring const*>(&clientId), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallOptions const*>(&installOptions)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsPackageIdentityAllowedToInstallAsync(void* correlationVector, void* packageIdentityName, void* publisherCertificateName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsPackageIdentityAllowedToInstallAsync(*reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&packageIdentityName), *reinterpret_cast<hstring const*>(&publisherCertificateName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetIsPackageIdentityAllowedToInstallForUserAsync(void* user, void* correlationVector, void* packageIdentityName, void* publisherCertificateName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().GetIsPackageIdentityAllowedToInstallForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&correlationVector), *reinterpret_cast<hstring const*>(&packageIdentityName), *reinterpret_cast<hstring const*>(&publisherCertificateName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7>
    {
        int32_t __stdcall get_CanInstallForAllUsers(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().CanInstallForAllUsers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs>
    {
        int32_t __stdcall get_Item(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem>(this->shim().Item());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions>
    {
        int32_t __stdcall get_CatalogId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CatalogId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CatalogId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CatalogId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ForceUseOfNonRemovableStorage(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().ForceUseOfNonRemovableStorage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ForceUseOfNonRemovableStorage(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ForceUseOfNonRemovableStorage(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AllowForcedAppRestart(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AllowForcedAppRestart());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowForcedAppRestart(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowForcedAppRestart(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Repair(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().Repair());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Repair(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Repair(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TargetVolume(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Management::Deployment::PackageVolume>(this->shim().TargetVolume());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TargetVolume(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetVolume(*reinterpret_cast<winrt::Windows::Management::Deployment::PackageVolume const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LaunchAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().LaunchAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LaunchAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LaunchAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2>
    {
        int32_t __stdcall get_PinToDesktopAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToDesktopAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToDesktopAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToDesktopAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PinToStartAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToStartAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToStartAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToStartAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PinToTaskbarAfterInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().PinToTaskbarAfterInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_PinToTaskbarAfterInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().PinToTaskbarAfterInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CompletedInstallToastNotificationMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode>(this->shim().CompletedInstallToastNotificationMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CompletedInstallToastNotificationMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CompletedInstallToastNotificationMode(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InstallInProgressToastNotificationMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode>(this->shim().InstallInProgressToastNotificationMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InstallInProgressToastNotificationMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InstallInProgressToastNotificationMode(*reinterpret_cast<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallationToastNotificationMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InstallForAllUsers(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().InstallForAllUsers());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_InstallForAllUsers(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().InstallForAllUsers(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_StageButDoNotInstall(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().StageButDoNotInstall());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_StageButDoNotInstall(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StageButDoNotInstall(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CampaignId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CampaignId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CampaignId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CampaignId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedCampaignId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ExtendedCampaignId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ExtendedCampaignId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ExtendedCampaignId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus>
    {
        int32_t __stdcall get_InstallState(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallState>(this->shim().InstallState());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DownloadSizeInBytes(uint64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint64_t>(this->shim().DownloadSizeInBytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BytesDownloaded(uint64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint64_t>(this->shim().BytesDownloaded());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PercentComplete(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().PercentComplete());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ErrorCode(winrt::hresult* value) noexcept final try
        {
            zero_abi<winrt::hresult>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::hresult>(this->shim().ErrorCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2>
    {
        int32_t __stdcall get_User(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::System::User>(this->shim().User());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReadyForLaunch(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().ReadyForLaunch());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3>
    {
        int32_t __stdcall get_IsStaged(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsStaged());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions>
    {
        int32_t __stdcall get_CatalogId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CatalogId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CatalogId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CatalogId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AllowForcedAppRestart(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AllowForcedAppRestart());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AllowForcedAppRestart(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AllowForcedAppRestart(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2>
    {
        int32_t __stdcall get_AutomaticallyDownloadAndInstallUpdateIfFound(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().AutomaticallyDownloadAndInstallUpdateIfFound());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_AutomaticallyDownloadAndInstallUpdateIfFound(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AutomaticallyDownloadAndInstallUpdateIfFound(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2> : produce_base<D, winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2>
    {
        int32_t __stdcall get_IsAlreadyOwned(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAlreadyOwned());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OrderId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().OrderId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SkuId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SkuId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AvailabilityId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AvailabilityId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::ApplicationModel::Store::Preview::InstallControl
{
    inline AppInstallManager::AppInstallManager() :
        AppInstallManager(impl::call_factory_cast<AppInstallManager(*)(winrt::Windows::Foundation::IActivationFactory const&), AppInstallManager>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<AppInstallManager>(); }))
    {
    }
    inline AppInstallOptions::AppInstallOptions() :
        AppInstallOptions(impl::call_factory_cast<AppInstallOptions(*)(winrt::Windows::Foundation::IActivationFactory const&), AppInstallOptions>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<AppInstallOptions>(); }))
    {
    }
    inline AppUpdateOptions::AppUpdateOptions() :
        AppUpdateOptions(impl::call_factory_cast<AppUpdateOptions(*)(winrt::Windows::Foundation::IActivationFactory const&), AppUpdateOptions>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<AppUpdateOptions>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallItem5> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager5> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager6> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManager7> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallManagerItemEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallOptions2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppInstallStatus3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IAppUpdateOptions2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::IGetEntitlementResult2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallManagerItemEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppInstallStatus> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::AppUpdateOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Store::Preview::InstallControl::GetEntitlementResult> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
