/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tg.v07;

import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongReader;
import app.tuxguitar.io.base.TGSongReaderHandle;
import app.tuxguitar.io.tg.TGFileFormatVersion;
import app.tuxguitar.io.tg.v15.TGFileFormatDetectorImpl;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.song.models.TGTimeSignature;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import java.io.DataInputStream;
import java.io.IOException;

public class TGSongReaderImpl
implements TGSongReader {
    public static final String TG_VERSION = "TG_DEVEL-0.01";
    public static final TGFileFormat TG_FORMAT = new TGFileFormat("TuxGuitar 0.7", "application/x-tuxguitar", new String[]{"tg"});
    public static final TGFileFormatVersion SUPPORTED_FORMAT = new TGFileFormatVersion(TG_FORMAT, "TG_DEVEL-0.01");
    private DataInputStream dataInputStream;
    private TGFactory factory;

    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            this.factory = handle.getFactory();
            this.dataInputStream = new DataInputStream(handle.getInputStream());
            TGFileFormat fileFormat = new TGFileFormatDetectorImpl(SUPPORTED_FORMAT).getFileFormat(this.dataInputStream);
            if (fileFormat == null || !fileFormat.equals((Object)this.getFileFormat())) {
                throw new TGFileFormatException("error.unsupported-version");
            }
            TGSong song = this.read();
            this.dataInputStream.close();
            handle.setSong(song);
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() {
        TGSong song = this.factory.newSong();
        song.setName(this.readString());
        song.setArtist(this.readString());
        song.setAlbum(this.readString());
        song.setAuthor(this.readString());
        int trackCount = this.readInt();
        for (int i = 0; i < trackCount; ++i) {
            song.addTrack(this.readTrack(song));
        }
        return song;
    }

    private TGTrack readTrack(TGSong song) {
        int i;
        TGTrack track = this.factory.newTrack();
        track.setNumber((int)this.readLong());
        track.setName(this.readString());
        this.readChannel(song, track);
        track.setSolo(this.readBoolean());
        track.setMute(this.readBoolean());
        int measureCount = this.readInt();
        if (song.countMeasureHeaders() == 0) {
            for (i = 0; i < measureCount; ++i) {
                TGMeasureHeader header = this.factory.newHeader();
                song.addMeasureHeader(header);
            }
        }
        for (i = 0; i < measureCount; ++i) {
            track.addMeasure(this.readMeasure(song.getMeasureHeader(i)));
        }
        int stringCount = this.readInt();
        for (int i2 = 0; i2 < stringCount; ++i2) {
            track.getStrings().add(this.readInstrumentString());
        }
        this.readColor(track.getColor());
        return track;
    }

    private TGMeasure readMeasure(TGMeasureHeader header) {
        TGMeasure measure = this.factory.newMeasure(header);
        header.setNumber(this.readInt());
        header.setStart(960L * this.readLong() / 1000L);
        int noteCount = this.readInt();
        TGBeat previous = null;
        for (int i = 0; i < noteCount; ++i) {
            previous = this.readNote(measure, previous);
        }
        int silenceCount = this.readInt();
        previous = null;
        for (int i = 0; i < silenceCount; ++i) {
            previous = this.readSilence(measure, previous);
        }
        this.readTimeSignature(header.getTimeSignature());
        this.readTempo(header.getTempo());
        measure.setClef(this.readInt());
        measure.setKeySignature(this.readInt());
        header.setRepeatOpen(this.readBoolean());
        header.setRepeatClose(this.readInt());
        return measure;
    }

    private TGBeat readNote(TGMeasure measure, TGBeat previous) {
        TGBeat beat = previous;
        int value = this.readInt();
        long start = 960L * this.readLong() / 1000L;
        if (beat == null || beat.getStart() != start) {
            beat = this.factory.newBeat();
            beat.setStart(start);
            measure.addBeat(beat);
        }
        TGVoice voice = beat.getVoice(0);
        voice.setEmpty(false);
        this.readDuration(voice.getDuration());
        TGNote note = this.factory.newNote();
        note.setValue(value);
        note.setVelocity(this.readInt());
        note.setString(this.readInt());
        note.setTiedNote(this.readBoolean());
        this.readNoteEffect(note.getEffect());
        voice.addNote(note);
        return beat;
    }

    private void readChannel(TGSong song, TGTrack track) {
        TGChannel channel = this.factory.newChannel();
        TGChannelParameter gmChannel1Param = this.factory.newChannelParameter();
        TGChannelParameter gmChannel2Param = this.factory.newChannelParameter();
        short channel1 = this.readShort();
        gmChannel1Param.setKey("gm-channel-1");
        gmChannel1Param.setValue(Integer.toString(channel1));
        short channel2 = this.readShort();
        gmChannel2Param.setKey("gm-channel-2");
        gmChannel2Param.setValue(Integer.toString(channel2));
        channel.setBank(channel1 == 9 ? (short)128 : 0);
        channel.setProgram(this.readShort());
        channel.setVolume(this.readShort());
        channel.setBalance(this.readShort());
        channel.setChorus(this.readShort());
        channel.setReverb(this.readShort());
        channel.setPhaser(this.readShort());
        channel.setTremolo(this.readShort());
        for (int i = 0; i < song.countChannels(); ++i) {
            TGChannel channelAux = song.getChannel(i);
            for (int n = 0; n < channelAux.countParameters(); ++n) {
                TGChannelParameter channelParameter = channelAux.getParameter(n);
                if (!channelParameter.getKey().equals("gm-channel-1") || !Integer.toString(channel1).equals(channelParameter.getValue())) continue;
                channel.setChannelId(channelAux.getChannelId());
            }
        }
        if (channel.getChannelId() <= 0) {
            channel.setChannelId(song.countChannels() + 1);
            channel.setName(new TGSongManager(this.factory).createChannelNameFromProgram(song, channel));
            channel.addParameter(gmChannel1Param);
            channel.addParameter(gmChannel2Param);
            song.addChannel(channel);
        }
        track.setChannelId(channel.getChannelId());
    }

    private TGBeat readSilence(TGMeasure measure, TGBeat previous) {
        TGBeat beat = previous;
        long start = 960L * this.readLong() / 1000L;
        if (beat == null || beat.getStart() != start) {
            beat = this.factory.newBeat();
            beat.setStart(start);
            measure.addBeat(beat);
        }
        TGVoice voice = beat.getVoice(0);
        voice.setEmpty(false);
        this.readDuration(voice.getDuration());
        return beat;
    }

    private TGString readInstrumentString() {
        TGString string = this.factory.newString();
        string.setNumber(this.readInt());
        string.setValue(this.readInt());
        return string;
    }

    private void readTempo(TGTempo tempo) {
        tempo.setQuarterValue(this.readInt());
    }

    private void readTimeSignature(TGTimeSignature timeSignature) {
        timeSignature.setNumerator(this.readInt());
        this.readDuration(timeSignature.getDenominator());
    }

    private void readDuration(TGDuration duration) {
        duration.setValue(this.readInt());
        duration.setDotted(this.readBoolean());
        duration.setDoubleDotted(this.readBoolean());
        this.readDivisionType(duration.getDivision());
    }

    private void readDivisionType(TGDivisionType divisionType) {
        divisionType.setEnters(this.readInt());
        divisionType.setTimes(this.readInt());
    }

    private void readNoteEffect(TGNoteEffect effect) {
        effect.setVibrato(this.readBoolean());
        if (this.readBoolean()) {
            effect.setBend(this.readBendEffect());
        }
        effect.setDeadNote(this.readBoolean());
        effect.setSlide(this.readBoolean());
        effect.setHammer(this.readBoolean());
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend bend = this.factory.newEffectBend();
        int count = this.readInt();
        for (int i = 0; i < count; ++i) {
            int position = this.readInt();
            int value = this.readInt();
            bend.addPoint(position, value > 0 ? value / 2 : value);
        }
        return bend;
    }

    private void readColor(TGColor color) {
        color.setR(this.readInt());
        color.setG(this.readInt());
        color.setB(this.readInt());
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readInt() {
        try {
            return this.dataInputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private long readLong() {
        try {
            return this.dataInputStream.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private String readString() {
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(chars);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean readBoolean() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

