/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tg.util;

import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import java.util.List;

public class TGStringLimitUtil {
    public static final int MINIMUM = 4;
    public static final int MAXIMUM = 7;

    public static List<TGString> createWritableStrings(TGTrack track) {
        return TGStringLimitUtil.createWritableStrings(track, 4, 7);
    }

    public static List<TGString> createWritableStrings(TGTrack track, int minimum, int maximum) {
        int count = track.stringCount();
        if (count >= minimum && count <= maximum) {
            return track.getStrings();
        }
        int writableCount = count;
        if (writableCount < minimum) {
            writableCount = minimum;
        }
        if (writableCount > maximum) {
            writableCount = maximum;
        }
        List strings = track.getStrings();
        List<TGString> writableStrings = TGStringLimitUtil.createDefaultStrings(track, writableCount);
        for (TGString string : strings) {
            if (string.getNumber() < minimum || string.getNumber() > maximum) continue;
            for (TGString writableString : writableStrings) {
                if (writableString.getNumber() != string.getNumber()) continue;
                writableString.setValue(string.getValue());
            }
        }
        return writableStrings;
    }

    private static List<TGString> createDefaultStrings(TGTrack track, int count) {
        TGSongManager songManager = new TGSongManager();
        if (track.isPercussion()) {
            return songManager.createPercussionStrings(count);
        }
        return songManager.createDefaultInstrumentStrings(count);
    }
}

