/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.synthesizer;

import app.tuxguitar.jack.JackClient;
import app.tuxguitar.jack.JackPort;
import app.tuxguitar.jack.synthesizer.JackChannel;
import app.tuxguitar.jack.synthesizer.JackChannelProxy;
import app.tuxguitar.jack.synthesizer.JackGmPort;
import app.tuxguitar.player.base.MidiChannel;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSynthesizer;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JackSynthesizer
implements MidiSynthesizer {
    private TGContext context;
    private JackClient jackClient;
    private JackGmPort jackGmPort;
    private List<JackChannelProxy> jackChannelProxies;

    public JackSynthesizer(TGContext context, JackClient jackClient) {
        this.context = context;
        this.jackClient = jackClient;
        this.jackChannelProxies = new ArrayList<JackChannelProxy>();
    }

    public MidiChannel openChannel(int channelId) throws MidiPlayerException {
        return this.openChannel(channelId, false);
    }

    public MidiChannel openChannel(int channelId, boolean exclusive) throws MidiPlayerException {
        boolean channelLoaded;
        JackChannelProxy jackChannelProxy = this.findChannel(channelId);
        if (jackChannelProxy != null) {
            if (jackChannelProxy.isExclusive() == exclusive) {
                return jackChannelProxy;
            }
            JackPort jackPort = jackChannelProxy.getJackPort();
            if (jackPort != null) {
                jackChannelProxy.setJackPort(null);
                this.closeUnusedPort(jackPort);
            }
        }
        if (jackChannelProxy == null) {
            jackChannelProxy = new JackChannelProxy(channelId, this);
        }
        jackChannelProxy.setMidiChannel(null);
        jackChannelProxy.setJackPort(null);
        jackChannelProxy.setExclusive(exclusive);
        boolean bl = channelLoaded = exclusive ? this.loadExclusiveChannel(jackChannelProxy) : this.loadGmChannel(jackChannelProxy);
        if (channelLoaded) {
            if (!this.jackChannelProxies.contains(jackChannelProxy)) {
                this.jackChannelProxies.add(jackChannelProxy);
            }
            return jackChannelProxy;
        }
        return null;
    }

    public boolean loadGmChannel(JackChannelProxy jackChannelProxy) throws MidiPlayerException {
        JackPort jackPort;
        if (this.jackGmPort != null && !this.jackClient.isPortOpen(this.jackGmPort.getJackPort())) {
            this.jackGmPort = null;
        }
        if (this.jackGmPort == null && (jackPort = this.jackClient.openPort(this.createJackPortName(jackChannelProxy))) != null) {
            this.jackGmPort = new JackGmPort(this.jackClient, jackPort);
        }
        if (this.jackGmPort != null) {
            jackChannelProxy.setExclusive(false);
            jackChannelProxy.setMidiChannel(this.jackGmPort.getSynthesizer().openChannel(jackChannelProxy.getJackChannelId()));
            jackChannelProxy.setJackPort(this.jackGmPort.getJackPort());
            return true;
        }
        return false;
    }

    public boolean loadExclusiveChannel(JackChannelProxy jackChannelProxy) throws MidiPlayerException {
        JackPort jackPort = this.jackClient.openPort(this.createJackPortName(jackChannelProxy));
        if (jackPort != null) {
            jackChannelProxy.setExclusive(true);
            jackChannelProxy.setMidiChannel(new JackChannel(this.jackClient, jackPort));
            jackChannelProxy.setJackPort(jackPort);
            return true;
        }
        return false;
    }

    public void closeChannel(MidiChannel midiChannel) {
        JackChannelProxy jackChannelProxy = this.findChannel(((JackChannelProxy)midiChannel).getJackChannelId());
        if (jackChannelProxy != null) {
            this.jackChannelProxies.remove(jackChannelProxy);
            if (jackChannelProxy.getJackPort() != null) {
                this.closeUnusedPort(jackChannelProxy.getJackPort());
            }
        }
    }

    public void closeAllChannels() {
        ArrayList<JackChannelProxy> jackChannelProxies = new ArrayList<JackChannelProxy>(this.jackChannelProxies);
        Iterator it = jackChannelProxies.iterator();
        while (it.hasNext()) {
            this.closeChannel((JackChannelProxy)it.next());
        }
    }

    public boolean isChannelOpen(MidiChannel midiChannel) {
        JackChannelProxy jackChannelProxy = this.findChannel(((JackChannelProxy)midiChannel).getJackChannelId());
        if (jackChannelProxy != null && jackChannelProxy.getJackPort() != null && jackChannelProxy == midiChannel && this.jackClient.isPortOpen(jackChannelProxy.getJackPort())) {
            return jackChannelProxy.getJackPort().getJackPortName().equals(this.createJackPortName(jackChannelProxy));
        }
        return false;
    }

    public JackChannelProxy findChannel(int channelId) {
        for (JackChannelProxy jackChannelProxy : this.jackChannelProxies) {
            if (jackChannelProxy.getJackChannelId() != channelId) continue;
            return jackChannelProxy;
        }
        return null;
    }

    public void closeUnusedPort(JackPort jackPort) {
        if (!this.isJackPortInUse(jackPort)) {
            this.jackClient.closePort(jackPort);
        }
    }

    public boolean isJackPortInUse(JackPort jackPort) {
        for (JackChannelProxy jackChannelProxy : this.jackChannelProxies) {
            if (jackChannelProxy.getJackPort() == null || !jackChannelProxy.getJackPort().equals(jackPort)) continue;
            return true;
        }
        return false;
    }

    public String createJackPortName(JackChannelProxy jackChannelProxy) {
        if (!jackChannelProxy.isExclusive()) {
            return "GM Port";
        }
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
        TGChannel tgChannel = midiPlayer.getSongManager().getChannel(midiPlayer.getSong(), jackChannelProxy.getJackChannelId());
        if (tgChannel != null) {
            return tgChannel.getName();
        }
        return "Channel-" + jackChannelProxy.getJackChannelId();
    }

    public boolean isBusy() {
        return false;
    }
}

