/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.synthesizer;

import app.tuxguitar.jack.JackPort;
import app.tuxguitar.jack.synthesizer.JackSynthesizer;
import app.tuxguitar.player.base.MidiChannel;
import app.tuxguitar.player.base.MidiPlayerException;

public class JackChannelProxy
implements MidiChannel {
    private int jackChannelId;
    private JackSynthesizer jackSynthesizer;
    private JackPort jackPort;
    private MidiChannel midiChannel;
    private boolean exclusive;

    public JackChannelProxy(int jackChannelId, JackSynthesizer jackSynthesizer) {
        this.jackChannelId = jackChannelId;
        this.jackSynthesizer = jackSynthesizer;
    }

    public void sendNoteOn(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendNoteOn(key, velocity, voice, bendMode);
        }
    }

    public void sendNoteOff(int key, int velocity, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendNoteOff(key, velocity, voice, bendMode);
        }
    }

    public void sendPitchBend(int value, int voice, boolean bendMode) throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendPitchBend(value, voice, bendMode);
        }
    }

    public void sendProgramChange(int value) throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendProgramChange(value);
        }
    }

    public void sendControlChange(int controller, int value) throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendControlChange(controller, value);
        }
    }

    public void sendAllNotesOff() throws MidiPlayerException {
        if (this.midiChannel != null) {
            this.midiChannel.sendAllNotesOff();
        }
    }

    public void sendParameter(String key, String value) throws MidiPlayerException {
        if ("jack-port-exclusive".equals(key)) {
            boolean exclusive = Boolean.TRUE.toString().equals(value);
            if (this.exclusive != exclusive) {
                this.jackSynthesizer.openChannel(this.getJackChannelId(), exclusive);
            }
        } else if (this.midiChannel != null) {
            this.midiChannel.sendParameter(key, value);
        }
    }

    public int getJackChannelId() {
        return this.jackChannelId;
    }

    public MidiChannel getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(MidiChannel midiChannel) {
        this.midiChannel = midiChannel;
    }

    public JackPort getJackPort() {
        return this.jackPort;
    }

    public void setJackPort(JackPort jackPort) {
        this.jackPort = jackPort;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }
}

