/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.connection;

import app.tuxguitar.jack.connection.JackConnection;
import app.tuxguitar.jack.connection.JackConnectionManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.configuration.TGConfigManager;

public class JackConnectionConfig {
    private static final String JACK_CONFIG_ID = "tuxguitar-jack";
    private static final String JACK_AUTOMATICALLY_RESTORE_CONNECTIONS = "jack.automatically.restore.connections";
    private static final String JACK_CONNECTIONS = "jack.connections";
    private static final String JACK_CONNECTIONS_SEPARATOR = ";";
    private static final String JACK_CONNECTIONS_SRC_DST_SEPARATOR = "<->";
    private TGContext context;
    private JackConnectionManager jackConnectionManager;

    public JackConnectionConfig(TGContext context, JackConnectionManager jackConnectionManager) {
        this.context = context;
        this.jackConnectionManager = jackConnectionManager;
    }

    public void save() {
        StringBuffer connectionsBuffer = new StringBuffer();
        for (JackConnection jackConnection : this.jackConnectionManager.getJackConnections()) {
            if (connectionsBuffer.length() > 0) {
                connectionsBuffer.append(JACK_CONNECTIONS_SEPARATOR);
            }
            connectionsBuffer.append(jackConnection.getSrcPortId());
            connectionsBuffer.append(JACK_CONNECTIONS_SRC_DST_SEPARATOR);
            connectionsBuffer.append(jackConnection.getDstPortId());
        }
        TGConfigManager tgConfigManager = new TGConfigManager(this.context, JACK_CONFIG_ID);
        tgConfigManager.setValue(JACK_CONNECTIONS, connectionsBuffer.toString());
        tgConfigManager.setValue(JACK_AUTOMATICALLY_RESTORE_CONNECTIONS, this.jackConnectionManager.isAutoConnectPorts());
        tgConfigManager.save();
    }

    public void load() {
        TGConfigManager tgConfigManager = new TGConfigManager(this.context, JACK_CONFIG_ID);
        this.jackConnectionManager.setAutoConnectPorts(tgConfigManager.getBooleanValue(JACK_AUTOMATICALLY_RESTORE_CONNECTIONS, false));
        this.jackConnectionManager.clearJackConnections();
        String jackConnectionsStr = tgConfigManager.getStringValue(JACK_CONNECTIONS);
        if (jackConnectionsStr != null) {
            String[] jackConnectionsArr = jackConnectionsStr.split(JACK_CONNECTIONS_SEPARATOR);
            for (int i = 0; i < jackConnectionsArr.length; ++i) {
                String[] jackConnectionArr = jackConnectionsArr[i].split(JACK_CONNECTIONS_SRC_DST_SEPARATOR);
                if (jackConnectionArr.length != 2) continue;
                long srcPortId = Long.parseLong(jackConnectionArr[0]);
                long dstPortId = Long.parseLong(jackConnectionArr[1]);
                this.jackConnectionManager.addJackConnection(new JackConnection(srcPortId, dstPortId));
            }
        }
    }
}

