/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGAbstractProcessorFactory;
import app.tuxguitar.midi.synth.TGAudioProcessorFactory;
import app.tuxguitar.midi.synth.TGMidiProcessorFactory;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGSynthManager {
    private Map<Class<?>, Object> extensions = new HashMap();

    private TGSynthManager() {
    }

    public <T> List<T> getExtensions(Class<T> cls) {
        if (this.extensions.containsKey(cls)) {
            return (List)this.extensions.get(cls);
        }
        this.extensions.put(cls, new ArrayList());
        return this.getExtensions(cls);
    }

    public <T> void addExtension(Class<T> cls, T extension) {
        this.getExtensions(cls).add(extension);
    }

    public <T> void removeExtension(Class<T> cls, T extension) {
        List<T> extensions = this.getExtensions(cls);
        if (extensions.contains(extension)) {
            extensions.remove(extension);
        }
    }

    public TGMidiProcessorFactory findMidiProcessorFactory(String type) {
        List<TGMidiProcessorFactory> factories = this.getExtensions(TGMidiProcessorFactory.class);
        for (TGMidiProcessorFactory factory : factories) {
            if (!factory.getType().equals(type)) continue;
            return factory;
        }
        return null;
    }

    public TGAudioProcessorFactory findAudioProcessorFactory(String type) {
        List<TGAudioProcessorFactory> factories = this.getExtensions(TGAudioProcessorFactory.class);
        for (TGAudioProcessorFactory factory : factories) {
            if (!factory.getType().equals(type)) continue;
            return factory;
        }
        return null;
    }

    public List<String> getAllSupportedMidiTypes() {
        return this.getAllSupportedTypes(this.getExtensions(TGMidiProcessorFactory.class));
    }

    public List<String> getAllSupportedAudioTypes() {
        return this.getAllSupportedTypes(this.getExtensions(TGAudioProcessorFactory.class));
    }

    private List<String> getAllSupportedTypes(List<? extends TGAbstractProcessorFactory<?>> factories) {
        ArrayList<String> allSupportedTypes = new ArrayList<String>();
        for (TGAbstractProcessorFactory<?> factory : factories) {
            allSupportedTypes.add(factory.getType());
        }
        return allSupportedTypes;
    }

    public static TGSynthManager getInstance(TGContext context) {
        return (TGSynthManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGSynthManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGSynthManager>(){

            public TGSynthManager createInstance(TGContext context) {
                return new TGSynthManager();
            }
        });
    }
}

