/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth;

import app.tuxguitar.midi.synth.TGAudioBuffer;
import app.tuxguitar.midi.synth.TGAudioProcessor;
import app.tuxguitar.midi.synth.TGAudioProcessorFactory;
import app.tuxguitar.midi.synth.TGMidiProcessor;
import app.tuxguitar.midi.synth.TGMidiProcessorFactory;
import app.tuxguitar.midi.synth.TGProgram;
import app.tuxguitar.midi.synth.TGProgramElement;
import app.tuxguitar.midi.synth.TGSynthManager;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TGSynthChannelProcessor {
    private TGAudioBuffer buffer;
    private TGMidiProcessor processor;
    private List<TGAudioProcessor> outputs;
    private Map<TGProgramElement, TGAudioProcessor> processorMap;
    private Object lock = new Object();

    public TGSynthChannelProcessor() {
        this.buffer = new TGAudioBuffer();
        this.outputs = new ArrayList<TGAudioProcessor>();
        this.processorMap = new HashMap<TGProgramElement, TGAudioProcessor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(TGContext context, TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            this.processor = null;
            this.outputs.clear();
            this.closeOrphanProcessors(program);
            this.openReceiver(context, program.getReceiver());
            this.openOutputs(context, program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openReceiver(TGContext context, TGProgramElement receiver) {
        Object object = this.lock;
        synchronized (object) {
            TGSynthManager synthManager;
            TGMidiProcessorFactory factory;
            TGMidiProcessor processor = (TGMidiProcessor)this.getAudioProcessor(receiver);
            if (!(processor != null && processor.isOpen() || (factory = (synthManager = TGSynthManager.getInstance(context)).findMidiProcessorFactory(receiver.getType())) == null)) {
                processor = (TGMidiProcessor)factory.createProcessor();
            }
            if (processor != null) {
                this.setMidiProcessor(receiver, processor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutputs(TGContext context, TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < program.countOutputs(); ++i) {
                this.openOutput(context, program.getOutput(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutput(TGContext context, TGProgramElement output) {
        Object object = this.lock;
        synchronized (object) {
            TGSynthManager synthManager;
            TGAudioProcessorFactory factory;
            TGAudioProcessor processor = this.getAudioProcessor(output);
            if (!(processor != null && processor.isOpen() || (factory = (synthManager = TGSynthManager.getInstance(context)).findAudioProcessorFactory(output.getType())) == null)) {
                processor = factory.createProcessor();
            }
            if (processor != null) {
                this.addOutputProcessor(output, processor);
            }
        }
    }

    public void setMidiProcessor(TGProgramElement element, TGMidiProcessor processor) {
        this.processor = processor;
        this.addProcessor(element, processor);
    }

    public void addOutputProcessor(TGProgramElement element, TGAudioProcessor processor) {
        this.addOutput(processor);
        this.addProcessor(element, processor);
    }

    public void addProcessor(TGProgramElement element, TGAudioProcessor processor) {
        if (this.processorMap.containsKey(element)) {
            this.processorMap.remove(element);
        }
        this.processorMap.put(element, processor);
        this.restoreParameters(element, processor);
    }

    public void restoreParameters(TGProgramElement element, TGAudioProcessor processor) {
        if (element.getParameters() != null) {
            processor.restoreParameters(element.getParameters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeOrphanProcessors(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOrphanProcessors(TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<TGProgramElement, TGAudioProcessor> mappedProcessors = new HashMap<TGProgramElement, TGAudioProcessor>(this.processorMap);
            for (TGProgramElement element : mappedProcessors.keySet()) {
                if (!this.shouldCloseProcessor(program, element)) continue;
                this.closeProcessor(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProcessor(TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            TGAudioProcessor mappedProcessor = this.getAudioProcessor(element);
            if (mappedProcessor != null) {
                mappedProcessor.close();
                mappedProcessor.finalize();
                this.processorMap.remove(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldCloseProcessor(TGProgram program, TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            if (program != null) {
                if (program.getReceiver() != null && program.getReceiver().equals(element)) {
                    return false;
                }
                for (int i = 0; i < program.countOutputs(); ++i) {
                    if (!program.getOutput(i).equals(element)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGProgramElement getElement(TGAudioProcessor processor) {
        Object object = this.lock;
        synchronized (object) {
            Set<Map.Entry<TGProgramElement, TGAudioProcessor>> entries = this.processorMap.entrySet();
            for (Map.Entry<TGProgramElement, TGAudioProcessor> entry : entries) {
                if (entry.getValue() == null || !entry.getValue().equals(processor)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGAudioProcessor getAudioProcessor(TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processorMap.containsKey(element)) {
                return this.processorMap.get(element);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGMidiProcessor getProcessor() {
        Object object = this.lock;
        synchronized (object) {
            return this.processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutput(TGAudioProcessor effect) {
        Object object = this.lock;
        synchronized (object) {
            if (effect != null) {
                this.outputs.add(effect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGAudioProcessor getOutput(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (index >= 0 && index < this.outputs.size()) {
                return this.outputs.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countOutputs() {
        Object object = this.lock;
        synchronized (object) {
            return this.outputs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer(TGAudioBuffer buffer, int volume, int balance) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processor != null && this.processor.isOpen()) {
                this.buffer.clear();
                this.fillBuffer(this.buffer, this.processor);
                for (int i = 0; i < this.countOutputs(); ++i) {
                    this.fillBuffer(this.buffer, this.getOutput(i));
                }
                this.balance(this.buffer, volume, balance);
                buffer.mix(this.buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer(TGAudioBuffer buffer, TGAudioProcessor processor) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isEnabled(processor)) {
                processor.fillBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void balance(TGAudioBuffer buffer, int volume, int balance) {
        Object object = this.lock;
        synchronized (object) {
            buffer.balance(new float[]{(float)volume / 127.0f * ((float)(127 - balance) / 127.0f), (float)volume / 127.0f * ((float)balance / 127.0f)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.processor != null && this.processor.isBusy()) {
                return true;
            }
            for (TGAudioProcessor processor : this.outputs) {
                if (!processor.isBusy()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(TGAudioProcessor processor) {
        Object object = this.lock;
        synchronized (object) {
            TGProgramElement element = this.getElement(processor);
            return element != null && element.isEnabled();
        }
    }
}

