/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.midi;

import app.tuxguitar.io.midi.MidiFileHeader;
import app.tuxguitar.io.midi.base.MidiEvent;
import app.tuxguitar.io.midi.base.MidiMessage;
import app.tuxguitar.io.midi.base.MidiSequence;
import app.tuxguitar.io.midi.base.MidiTrack;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MidiFileWriter
implements MidiFileHeader {
    public void write(MidiSequence sequence, int type, OutputStream stream) throws IOException {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(1297377380);
        out.writeInt(6);
        out.writeShort(type);
        out.writeShort(sequence.countTracks());
        out.writeShort(sequence.getDivisionType() == 0.0f ? sequence.getResolution() & Short.MAX_VALUE : 0);
        for (int i = 0; i < sequence.countTracks(); ++i) {
            MidiFileWriter.writeTrack(sequence.getTrack(i), out);
        }
        out.flush();
        out.close();
    }

    private static int writeTrack(MidiTrack track, DataOutputStream out) throws IOException {
        int length = 0;
        if (out != null) {
            out.writeInt(1297379947);
        }
        if (out != null) {
            out.writeInt(MidiFileWriter.writeTrack(track, null));
        }
        MidiEvent previous = null;
        for (int i = 0; i < track.size(); ++i) {
            MidiEvent event = track.get(i);
            length += MidiFileWriter.writeEvent(event, previous, out);
            previous = event;
        }
        return length;
    }

    private static int writeEvent(MidiEvent event, MidiEvent previous, OutputStream out) throws IOException {
        int length = MidiFileWriter.writeVariableLengthQuantity(previous != null ? event.getTick() - previous.getTick() : 0L, out);
        MidiMessage message = event.getMessage();
        if (message.getType() == 1) {
            length += MidiFileWriter.writeShortMessage(message, out);
        } else if (message.getType() == 2) {
            length += MidiFileWriter.writeMetaMessage(message, out);
        }
        return length;
    }

    private static int writeShortMessage(MidiMessage message, OutputStream out) throws IOException {
        byte[] data = message.getData();
        int length = data.length;
        if (out != null) {
            out.write(message.getData(), 0, length);
        }
        return length;
    }

    private static int writeMetaMessage(MidiMessage message, OutputStream out) throws IOException {
        int length = 0;
        byte[] data = message.getData();
        if (out != null) {
            out.write(255);
            out.write(message.getCommand());
        }
        length += 2;
        length += MidiFileWriter.writeVariableLengthQuantity(data.length, out);
        if (out != null) {
            out.write(data);
        }
        return length += data.length;
    }

    private static int writeVariableLengthQuantity(long value, OutputStream out) throws IOException {
        boolean started = false;
        int length = 0;
        int data = (int)(value >> 21 & 0x7FL);
        if (data != 0) {
            if (out != null) {
                out.write(data | 0x80);
            }
            ++length;
            started = true;
        }
        if ((data = (int)(value >> 14 & 0x7FL)) != 0 || started) {
            if (out != null) {
                out.write(data | 0x80);
            }
            ++length;
            started = true;
        }
        if ((data = (int)(value >> 7 & 0x7FL)) != 0 || started) {
            if (out != null) {
                out.write(data | 0x80);
            }
            ++length;
        }
        data = (int)(value & 0x7FL);
        if (out != null) {
            out.write(data);
        }
        return ++length;
    }
}

