/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.utils;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.util.TGFileChooser;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.dialog.file.TGFileChooserDialog;
import app.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIRadioButton;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGExpressionResolver;
import app.tuxguitar.util.configuration.TGConfigManager;
import java.io.File;

public class MidiConfigUtils {
    public static final String SOUNDBANK_KEY = "soundbank.custom.path";
    private static final TGFileFormat soundfontFormat = new TGFileFormat("SoundFont SF2", "audio/x-sf2", new String[]{"sf2"});

    public static TGConfigManager getConfig(TGContext context) {
        return new TGConfigManager(context, "tuxguitar-jsa");
    }

    public static String getSoundbankPath(TGContext context) {
        return MidiConfigUtils.getSoundbankPath(MidiConfigUtils.getConfig(context));
    }

    public static String getSoundbankPath(TGConfigManager config) {
        return config.getStringValue(SOUNDBANK_KEY);
    }

    public static void setupDialog(TGContext context, UIWindow parent) {
        MidiConfigUtils.setupDialog(context, parent, MidiConfigUtils.getConfig(context));
    }

    public static void setupDialog(final TGContext context, UIWindow parent, final TGConfigManager config) {
        final String soundbank = MidiConfigUtils.getSoundbankPath(config);
        UIFactory uiFactory = TGApplication.getInstance((TGContext)context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"jsa.settings.title"));
        UITableLayout soundbankLayout = new UITableLayout();
        UILegendPanel soundbankGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        soundbankGroup.setLayout((UILayout)soundbankLayout);
        soundbankGroup.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.tip"));
        dialogLayout.set((UIControl)soundbankGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), null, null);
        UIRadioButton sbDefault = uiFactory.createRadioButton((UIContainer)soundbankGroup);
        sbDefault.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.default"));
        sbDefault.setSelected(soundbank == null);
        soundbankLayout.set((UIControl)sbDefault, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        soundbankLayout.set((UIControl)sbDefault, "packed_width", (Object)Float.valueOf(0.0f));
        final UIRadioButton sbCustom = uiFactory.createRadioButton((UIContainer)soundbankGroup);
        sbCustom.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.custom"));
        sbCustom.setSelected(soundbank != null);
        soundbankLayout.set((UIControl)sbCustom, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        soundbankLayout.set((UIControl)sbCustom, "packed_width", (Object)Float.valueOf(0.0f));
        final UITextField sbCustomPath = uiFactory.createTextField((UIContainer)soundbankGroup);
        sbCustomPath.setText(soundbank == null ? new String() : soundbank);
        sbCustomPath.setEnabled(soundbank != null);
        soundbankLayout.set((UIControl)sbCustomPath, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        final UIButton sbCustomChooser = uiFactory.createButton((UIContainer)soundbankGroup);
        sbCustomChooser.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
        sbCustomChooser.setEnabled(soundbank != null);
        sbCustomChooser.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGFileChooser.getInstance((TGContext)context).openChooser(new TGFileChooserHandler(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void updateFileName(String fileName) {
                        sbCustomPath.setText(fileName);
                    }
                }, soundfontFormat, TGFileChooserDialog.STYLE_OPEN);
            }
        });
        soundbankLayout.set((UIControl)sbCustomChooser, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UISelectionListener sbRadioSelectionListener = new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                sbCustomPath.setEnabled(sbCustom.isSelected());
                sbCustomChooser.setEnabled(sbCustom.isSelected());
            }
        };
        sbDefault.addSelectionListener(sbRadioSelectionListener);
        sbCustom.addSelectionListener(sbRadioSelectionListener);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String selection = sbCustom.isSelected() ? sbCustomPath.getText() : null;
                boolean changed = false;
                changed = selection == null && soundbank != null;
                changed = changed || selection != null && soundbank == null;
                boolean bl = changed = changed || selection != null && !selection.equals(soundbank);
                if (changed) {
                    if (selection != null) {
                        File soundfont = new File(TGExpressionResolver.getInstance((TGContext)context).resolve(selection));
                        if (!soundfont.isFile()) {
                            TGMessageDialogUtil.errorMessage((TGContext)context, (UIWindow)dialog, (String)TuxGuitar.getProperty((String)"jsa.error.soundbank.custom", (String[])new String[]{soundfont.getAbsolutePath()}));
                            return;
                        }
                        config.setValue(MidiConfigUtils.SOUNDBANK_KEY, selection);
                    } else {
                        config.remove(MidiConfigUtils.SOUNDBANK_KEY);
                    }
                    config.save();
                    TGMessageDialogUtil.infoMessage((TGContext)context, (String)TuxGuitar.getProperty((String)"warning"), (String)TuxGuitar.getProperty((String)"jsa.settings.soundbank-restart-message"));
                }
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }
}

