/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.sequencer;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSequencer;
import app.tuxguitar.player.base.MidiSequencerProvider;
import app.tuxguitar.player.impl.jsa.sequencer.MidiSequencerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;

public class MidiSequencerProviderImpl
implements MidiSequencerProvider {
    public List<MidiSequencer> listSequencers() throws MidiPlayerException {
        try {
            ArrayList<MidiSequencer> sequencers = new ArrayList<MidiSequencer>();
            MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                try {
                    MidiDevice device;
                    Iterator it = sequencers.iterator();
                    boolean exists = false;
                    while (it.hasNext()) {
                        if (!((MidiSequencer)it.next()).getKey().equals(infos[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists || !((device = MidiSystem.getMidiDevice(infos[i])) instanceof Sequencer)) continue;
                    sequencers.add(new MidiSequencerImpl((Sequencer)device));
                    continue;
                }
                catch (MidiUnavailableException e) {
                    throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"), (Throwable)e);
                }
            }
            return sequencers;
        }
        catch (Throwable t) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.unknown"), t);
        }
    }

    public void closeAll() throws MidiPlayerException {
    }
}

