/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.midiport;

import app.tuxguitar.gm.port.GMReceiver;
import app.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import javax.sound.midi.MidiChannel;

class MidiPortSynthesizerReceiver
implements GMReceiver {
    private MidiPortSynthesizer port;
    private MidiChannel[] channels;

    public MidiPortSynthesizerReceiver(MidiPortSynthesizer port) {
        this.port = port;
    }

    private MidiChannel[] getChannels() {
        if (this.channels == null && this.port.getSynth() != null) {
            this.channels = this.port.getSynth().getChannels();
        }
        return this.channels;
    }

    public void sendSystemReset() {
        if (this.getChannels() != null) {
            for (int i = 0; i < this.getChannels().length; ++i) {
                this.getChannels()[i].resetAllControllers();
            }
        }
    }

    public void sendAllNotesOff() {
        if (this.getChannels() != null) {
            for (int channel = 0; channel < this.getChannels().length; ++channel) {
                this.sendControlChange(channel, 123, 0);
            }
        }
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        if (this.getChannels() != null && channel >= 0 && channel < this.getChannels().length) {
            this.getChannels()[channel].noteOn(key, velocity);
        }
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        if (this.getChannels() != null && channel >= 0 && channel < this.getChannels().length) {
            this.getChannels()[channel].noteOff(key, velocity);
        }
    }

    public void sendControlChange(int channel, int controller, int value) {
        if (this.getChannels() != null && channel >= 0 && channel < this.getChannels().length) {
            this.getChannels()[channel].controlChange(controller, value);
        }
    }

    public void sendProgramChange(int channel, int value) {
        if (this.getChannels() != null && channel >= 0 && channel < this.getChannels().length) {
            this.getChannels()[channel].programChange(value);
        }
    }

    public void sendPitchBend(int channel, int value) {
        if (this.getChannels() != null && channel >= 0 && channel < this.getChannels().length) {
            this.getChannels()[channel].setPitchBend(value * 128);
        }
    }
}

