/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.midiport;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.gm.port.GMOutputPort;
import app.tuxguitar.gm.port.GMReceiver;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.impl.jsa.assistant.SBAssistant;
import app.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizerReceiver;
import app.tuxguitar.player.impl.jsa.utils.MidiConfigUtils;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGExpressionResolver;
import app.tuxguitar.util.plugin.TGPluginInfo;
import java.io.File;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class MidiPortSynthesizer
extends GMOutputPort {
    private TGContext context;
    private String key;
    private String name;
    private Synthesizer synth;
    private GMReceiver receiver;
    private boolean synthesizerLoaded;
    private boolean soundbankLoaded;

    public MidiPortSynthesizer(TGContext context, Synthesizer synthesizer) {
        this.context = context;
        this.key = synthesizer.getDeviceInfo().getName();
        this.name = synthesizer.getDeviceInfo().getName();
        this.synth = synthesizer;
        this.receiver = new MidiPortSynthesizerReceiver(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void open() {
        this.getSynth();
    }

    public void close() {
        if (this.synth != null && this.synth.isOpen()) {
            this.unloadSoundbank();
            this.synth.close();
        }
    }

    public GMReceiver getReceiver() {
        return this.receiver;
    }

    public void check() throws MidiPlayerException {
        if (!this.isSynthesizerLoaded()) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"));
        }
        if (!this.isSoundbankLoaded(true)) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.soundbank.unavailable"));
        }
    }

    public Synthesizer getSynth() {
        try {
            if (!this.synth.isOpen()) {
                this.synth.open();
                if (!this.isSoundbankLoaded(false)) {
                    String path = MidiConfigUtils.getSoundbankPath(this.context);
                    if (path != null) {
                        this.loadSoundbank(new File(TGExpressionResolver.getInstance((TGContext)this.context).resolve(path)));
                    }
                    if (!this.isSoundbankLoaded(true)) {
                        this.loadSoundbank(this.synth.getDefaultSoundbank());
                    }
                    if (!this.isSoundbankLoaded(true)) {
                        new SBAssistant(this.context, this).process();
                    }
                }
            }
            this.synthesizerLoaded = this.synth.isOpen();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.synth;
    }

    public boolean loadSoundbank(File file) {
        try {
            return this.loadSoundbank(MidiSystem.getSoundbank(file));
        }
        catch (Throwable throwable) {
            TGPluginInfo pluginInfo = new TGPluginInfo(this.context, "tuxguitar-jsa");
            pluginInfo.initialize("tuxguitar-jsa");
            TGMessageDialogUtil.errorMessage((TGContext)this.context, (UIWindow)TGWindow.getInstance((TGContext)this.context).getWindow(), (String)pluginInfo.getName(), (String)TuxGuitar.getProperty((String)"jsa.error.soundbank.custom", (String[])new String[]{file.getAbsolutePath()}));
            return false;
        }
    }

    public boolean loadSoundbank(Soundbank sb) {
        try {
            if (sb != null && this.getSynth().isSoundbankSupported(sb)) {
                this.unloadSoundbank();
                this.soundbankLoaded = this.getSynth().loadAllInstruments(sb);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.soundbankLoaded;
    }

    public void unloadSoundbank() {
        try {
            Instrument[] loaded;
            this.soundbankLoaded = false;
            Instrument[] available = this.synth.getAvailableInstruments();
            if (available != null) {
                for (int i = 0; i < available.length; ++i) {
                    this.getSynth().unloadInstrument(available[i]);
                }
            }
            if ((loaded = this.synth.getLoadedInstruments()) != null) {
                for (int i = 0; i < loaded.length; ++i) {
                    this.getSynth().unloadInstrument(loaded[i]);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isSynthesizerLoaded() {
        return this.synthesizerLoaded;
    }

    public boolean isSoundbankLoaded(boolean checkSynth) {
        if (checkSynth) {
            Instrument[] loaded = this.synth.getLoadedInstruments();
            Instrument[] available = this.synth.getAvailableInstruments();
            this.soundbankLoaded = loaded != null && loaded.length > 0 || available != null && available.length > 0;
        }
        return this.soundbankLoaded;
    }
}

