/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.midiport;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.player.base.MidiOutputPort;
import app.tuxguitar.player.base.MidiOutputPortProvider;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.impl.jsa.midiport.MidiPortOut;
import app.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class MidiPortProviderImpl
implements MidiOutputPortProvider {
    private TGContext context;

    public MidiPortProviderImpl(TGContext context) {
        this.context = context;
    }

    public List<MidiOutputPort> listPorts() throws MidiPlayerException {
        try {
            ArrayList<MidiOutputPort> ports = new ArrayList<MidiOutputPort>();
            MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infos.length; ++i) {
                try {
                    MidiDevice device;
                    Iterator it = ports.iterator();
                    boolean exists = false;
                    while (it.hasNext()) {
                        if (!((MidiOutputPort)it.next()).getKey().equals(infos[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists || (device = MidiSystem.getMidiDevice(infos[i])).getMaxReceivers() == 0 || device instanceof Sequencer) continue;
                    if (device instanceof Synthesizer) {
                        ports.add((MidiOutputPort)new MidiPortSynthesizer(this.context, (Synthesizer)device));
                        continue;
                    }
                    ports.add((MidiOutputPort)new MidiPortOut(device));
                    continue;
                }
                catch (MidiUnavailableException e) {
                    throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"), (Throwable)e);
                }
            }
            return ports;
        }
        catch (Throwable t) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.unknown"), t);
        }
    }

    public void closeAll() {
    }
}

