/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.synth;

import app.tuxguitar.io.synth.TGSynthEvent;
import app.tuxguitar.midi.synth.TGSynthModel;
import app.tuxguitar.player.base.MidiPlayerException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TGSynthSequencer {
    private static final double SECOND_IN_NANOS = 1.0E9;
    private static final double SAMPLE_IN_NANOS = 1.1609977324263038E7;
    private long length;
    private long tempoInUsq;
    private TGSynthModel synth;
    private List<TGSynthEvent> midiEvents;
    private BigDecimal tick;
    private int currentIndex;

    public TGSynthSequencer(TGSynthModel synth, List<TGSynthEvent> midiEvents) {
        this.synth = synth;
        this.midiEvents = midiEvents;
        this.tick = new BigDecimal(0);
    }

    public long getTempoInUsq() {
        return this.tempoInUsq;
    }

    public void setTempoInUsq(long tempoInUsq) {
        this.tempoInUsq = tempoInUsq;
    }

    public TGSynthModel getSynth() {
        return this.synth;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isEnded() {
        return this.tick.longValue() >= this.length;
    }

    public void forward() {
        double tempo = 60000.0 / ((double)this.getTempoInUsq() / 1000.0);
        this.tick = this.tick.add(new BigDecimal(960.0 * (tempo * 1.1609977324263038E7 / 60.0) / 1.0E9));
    }

    public void start() {
        this.sortEvents();
        this.tempoInUsq = 500000L;
        this.currentIndex = 0;
        this.tick = new BigDecimal(0);
        this.length = !this.midiEvents.isEmpty() ? this.midiEvents.get(this.midiEvents.size() - 1).getTick() : 0L;
    }

    public void dispatchEvents() throws MidiPlayerException {
        while (this.currentIndex < this.midiEvents.size() && this.midiEvents.get(this.currentIndex).getTick() <= this.tick.longValue()) {
            this.midiEvents.get(this.currentIndex++).process(this);
            this.waitUntilReady();
        }
    }

    private void sortEvents() {
        Collections.sort(this.midiEvents, new Comparator<TGSynthEvent>(){

            @Override
            public int compare(TGSynthEvent e1, TGSynthEvent e2) {
                if (e1 != null && e2 != null) {
                    if (e1.getTick() > e2.getTick()) {
                        return 1;
                    }
                    if (e1.getTick() < e2.getTick()) {
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    public void waitUntilReady() {
        while (this.synth.isBusy()) {
            Thread.yield();
        }
    }
}

