/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util.properties;

import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.properties.TGProperties;
import app.tuxguitar.util.properties.TGPropertiesException;
import app.tuxguitar.util.properties.TGPropertiesFactory;
import app.tuxguitar.util.properties.TGPropertiesReader;
import app.tuxguitar.util.properties.TGPropertiesWriter;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.HashMap;
import java.util.Map;

public class TGPropertiesManager {
    private TGPropertiesFactory propertiesFactory = null;
    private Map<String, TGPropertiesReader> propertiesReaders = new HashMap<String, TGPropertiesReader>();
    private Map<String, TGPropertiesWriter> propertiesWriters = new HashMap<String, TGPropertiesWriter>();

    private TGPropertiesManager() {
    }

    public TGProperties createProperties() throws TGPropertiesException {
        if (this.propertiesFactory != null) {
            return this.propertiesFactory.createProperties();
        }
        return null;
    }

    public void readProperties(TGProperties properties, String resource, String module) {
        if (this.propertiesReaders.containsKey(resource)) {
            TGPropertiesReader tgPropertiesReader = this.propertiesReaders.get(resource);
            tgPropertiesReader.readProperties(properties, module);
        }
    }

    public void writeProperties(TGProperties properties, String resource, String module) {
        if (this.propertiesWriters.containsKey(resource)) {
            TGPropertiesWriter tgPropertiesWriter = this.propertiesWriters.get(resource);
            tgPropertiesWriter.writeProperties(properties, module);
        }
    }

    public TGPropertiesFactory getPropertiesFactory() {
        return this.propertiesFactory;
    }

    public void setPropertiesFactory(TGPropertiesFactory propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
    }

    public void addPropertiesReader(String resource, TGPropertiesReader propertiesReader) {
        if (!this.propertiesReaders.containsKey(resource)) {
            this.propertiesReaders.put(resource, propertiesReader);
        }
    }

    public void removePropertiesReader(String resource) {
        if (this.propertiesReaders.containsKey(resource)) {
            this.propertiesReaders.remove(resource);
        }
    }

    public void addPropertiesWriter(String resource, TGPropertiesWriter propertiesWriter) {
        if (!this.propertiesWriters.containsKey(resource)) {
            this.propertiesWriters.put(resource, propertiesWriter);
        }
    }

    public void removePropertiesWriter(String resource) {
        if (this.propertiesWriters.containsKey(resource)) {
            this.propertiesWriters.remove(resource);
        }
    }

    public static TGPropertiesManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGPropertiesManager.class.getName(), new TGSingletonFactory<TGPropertiesManager>(){

            @Override
            public TGPropertiesManager createInstance(TGContext context) {
                return new TGPropertiesManager();
            }
        });
    }
}

