/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.thread;

import app.tuxguitar.thread.TGThreadHandler;
import app.tuxguitar.thread.TGThreadLoop;
import app.tuxguitar.thread.TGThreadPriority;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGThreadManager
implements TGThreadHandler {
    private TGThreadHandler handler;

    private TGThreadManager() {
    }

    public void start(Runnable runnable) {
        if (this.handler != null) {
            this.handler.start(TGThreadPriority.NORMAL, runnable);
        }
    }

    @Override
    public void start(TGThreadPriority priority, Runnable runnable) {
        if (this.handler != null) {
            this.handler.start(priority, runnable);
        }
    }

    @Override
    public void loop(TGThreadLoop loop) {
        if (this.handler != null) {
            this.handler.loop(loop);
        }
    }

    @Override
    public void yield() {
        if (this.handler != null) {
            this.handler.yield();
        }
    }

    @Override
    public void dispose() {
        if (this.handler != null) {
            this.handler.dispose();
        }
    }

    @Override
    public Object getThreadId() {
        if (this.handler != null) {
            return this.handler.getThreadId();
        }
        return null;
    }

    public TGThreadHandler getThreadHandler() {
        return this.handler;
    }

    public void setThreadHandler(TGThreadHandler handler) {
        this.handler = handler;
    }

    public static TGThreadManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGThreadManager.class.getName(), new TGSingletonFactory<TGThreadManager>(){

            @Override
            public TGThreadManager createInstance(TGContext context) {
                return new TGThreadManager();
            }
        });
    }
}

