/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.helpers.tuning.xml;

import app.tuxguitar.song.helpers.tuning.TuningGroup;
import app.tuxguitar.song.helpers.tuning.TuningPreset;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TuningWriter {
    private static final String TUNINGS_ROOT = "tunings";

    public static void write(TuningGroup group, String fileName) {
        try {
            File file = new File(fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(TUNINGS_ROOT);
            TuningWriter.write(group, root);
            document.appendChild(root);
            FileOutputStream fs = new FileOutputStream(file);
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            StreamResult output = new StreamResult(fs);
            idTransform.setOutputProperty("indent", "yes");
            idTransform.transform(input, output);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void write(TuningGroup group, Node parent) {
        Element node;
        Document document = parent.getOwnerDocument();
        if (group.getName() != null && !group.getName().isEmpty()) {
            Attr attrName = document.createAttribute("name");
            attrName.setNodeValue(group.getName());
            parent.getAttributes().setNamedItem(attrName);
        }
        for (TuningGroup child : group.getGroups()) {
            node = document.createElement("group");
            TuningWriter.write(child, node);
            parent.appendChild(node);
        }
        for (TuningPreset preset : group.getTunings()) {
            node = document.createElement("tuning");
            Attr attrName = document.createAttribute("name");
            Attr attrNotes = document.createAttribute("notes");
            attrName.setNodeValue(preset.getName());
            attrNotes.setNodeValue(Arrays.stream(preset.getValues()).mapToObj(Integer::toString).collect(Collectors.joining(",")));
            node.getAttributes().setNamedItem(attrName);
            node.getAttributes().setNamedItem(attrNotes);
            parent.appendChild(node);
        }
    }
}

