/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.control;

import app.tuxguitar.graphics.control.TGLayout;

public abstract class TGSpacing {
    public static final int SCORE = 1;
    public static final int TABLATURE = 2;
    private int flags = 0;
    private float[] spacing;
    private int[][] positions;

    public TGSpacing(TGLayout layout, int[][] positions, int len) {
        this.flags |= (layout.getStyle() & 4) != 0 ? 1 : 0;
        this.flags |= (layout.getStyle() & 8) != 0 ? 2 : 0;
        this.positions = positions;
        this.spacing = new float[len];
    }

    public void clear() {
        for (int i = 0; i < this.spacing.length; ++i) {
            this.spacing[i] = 0.0f;
        }
    }

    public void setSize(int index, float size) {
        if (size > this.spacing[this.positions[this.flags - 1][index]]) {
            this.spacing[this.positions[this.flags - 1][index]] = size;
        }
    }

    public float getSize(int index) {
        return this.spacing[this.positions[this.flags - 1][index]];
    }

    public float getSize() {
        float spacing = 0.0f;
        for (int i = 0; i < this.spacing.length; ++i) {
            spacing += this.spacing[i];
        }
        return spacing;
    }

    public float getPosition(int index) {
        float spacing = 0.0f;
        for (int i = 0; i < this.positions[this.flags - 1][index]; ++i) {
            spacing += this.spacing[i];
        }
        return spacing;
    }
}

