/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.system.icons.TGColorManager;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItem;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIFontChooser;
import app.tuxguitar.ui.chooser.UIFontChooserHandler;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIPaintEvent;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.resource.UIFontModel;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UISize;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGMainToolBarItemTimeCounter
extends TGMainToolBarItem
implements TGEventListener {
    private static final String COLOR_BACKGROUND = "widget.transport.backgroundColor";
    private static final String COLOR_FOREGROUND = "widget.transport.foregroundColor";
    private static final TGColorManager.TGSkinnableColor[] SKINNABLE_COLORS = new TGColorManager.TGSkinnableColor[]{new TGColorManager.TGSkinnableColor("widget.transport.backgroundColor", new UIColorModel(0, 0, 0)), new TGColorManager.TGSkinnableColor("widget.transport.foregroundColor", new UIColorModel(240, 240, 240))};
    private static final float TIMESTAMP_H_MARGIN = 8.0f;
    private static final float TIMESTAMP_V_MARGIN_FACTOR = 1.6f;
    public static final float TIMESTAMP_MIN_WIDTH = 2.0f;
    public static final float TIMESTAMP_MIN_HEIGHT = 2.0f;
    private UICanvas timestampCanvas;
    private TGSyncProcessLocked redrawProcess;
    private UIPanel parentPanel;
    private UIWindow parentWindow;
    private UIColor backgroundColor;
    private UIColor foregroundColor;
    private UIFontModel fontModel;
    private UIFont font;
    private long timestamp = -1L;
    private float yTimestamp;
    private boolean fontChanged;
    private TGContext context;

    public TGMainToolBarItemTimeCounter(TGMainToolBarItemConfig toolBarItemConfig, final TGContext context, UIPanel parentPanel, final UIWindow parentWindow) {
        super(toolBarItemConfig);
        this.parentPanel = parentPanel;
        this.parentWindow = parentWindow;
        this.context = context;
        UIFactory uiFactory = TGApplication.getInstance(context).getFactory();
        this.timestampCanvas = uiFactory.createCanvas((UIContainer)parentPanel, false);
        this.timestampCanvas.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                TGMainToolBarItemTimeCounter.this.paintTimestamp(event.getPainter());
            }
        });
        this.timestampCanvas.addMouseDownListener(new UIMouseDownListener(){
            final /* synthetic */ TGMainToolBarItemTimeCounter this$0;
            {
                this.this$0 = this$0;
            }

            public void onMouseDown(UIMouseEvent event) {
                if (!MidiPlayer.getInstance((TGContext)context).isRunning()) {
                    UIFactory uiFactory = TGApplication.getInstance(this.this$0.context).getFactory();
                    UIFontChooser uiFontChooser = uiFactory.createFontChooser(parentWindow);
                    uiFontChooser.setDefaultModel(this.this$0.fontModel);
                    uiFontChooser.choose(new UIFontChooserHandler(){

                        public void onSelectFont(UIFontModel selection) {
                            if (selection != null) {
                                TGConfigManager.getInstance(this$0.context).setValue("font.main-toolbar.timestamp", selection);
                                this$0.loadFont();
                                this$0.timestampCanvas.redraw();
                            }
                        }
                    });
                }
            }
        });
        this.timestampCanvas.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                if (TGMainToolBarItemTimeCounter.this.font != null) {
                    TGMainToolBarItemTimeCounter.this.font.dispose();
                }
                TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)TGMainToolBarItemTimeCounter.this);
            }
        });
        TGColorManager tgColorManager = TGColorManager.getInstance(this.context);
        tgColorManager.appendSkinnableColors(SKINNABLE_COLORS);
        this.loadFont();
        this.loadColors();
        this.createSyncProcesses();
        this.appendListeners();
    }

    @Override
    public UIControl getControl() {
        return this.timestampCanvas;
    }

    @Override
    public void setLayoutProperties(UITableLayout layout) {
        layout.set((UIControl)this.timestampCanvas, "packed_width", (Object)Float.valueOf(2.0f));
        layout.set((UIControl)this.timestampCanvas, "packed_height", (Object)Float.valueOf(2.0f));
    }

    private void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGMainToolBarItemTimeCounter.this.timestampCanvas.redraw();
            }
        });
    }

    private void appendListeners() {
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
    }

    public void processEvent(TGEvent event) {
        int type;
        if ("ui-redraw".equals(event.getEventType()) && ((type = ((Integer)event.getAttribute("redrawMode")).intValue()) == 2 || type == 3)) {
            MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
            if (midiPlayer.isRunning() && midiPlayer.getCurrentTimestamp() != null) {
                long tMs = midiPlayer.getCurrentTimestamp();
                if (tMs / 100L != this.timestamp / 100L) {
                    this.redrawProcess.process();
                    this.timestamp = tMs;
                }
            } else {
                this.redrawProcess.process();
            }
        }
    }

    @Override
    public void loadIcons(TGIconManager iconManager) {
        this.loadColors();
    }

    @Override
    public void loadProperties() {
    }

    @Override
    public void update(TGContext context, boolean running) {
        this.timestampCanvas.redraw();
    }

    private void loadColors() {
        TGColorManager tgColorManager = TGColorManager.getInstance(this.context);
        this.backgroundColor = tgColorManager.getColor(COLOR_BACKGROUND);
        this.foregroundColor = tgColorManager.getColor(COLOR_FOREGROUND);
    }

    private void loadFont() {
        if (this.font != null) {
            this.font.dispose();
        }
        UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        this.fontModel = TGConfigManager.getInstance(this.context).getFontModelConfigValue("font.main-toolbar.timestamp");
        this.font = uiFactory.createFont(this.fontModel);
        this.fontChanged = true;
    }

    private void paintTimestamp(UIPainter painter) {
        float newHeight;
        float newWidth;
        String time;
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
        if (midiPlayer.isRunning()) {
            long tMs = this.timestamp;
            time = String.format("%d:%02d:%02d.%01d", tMs / 3600000L, tMs / 60000L % 60L, tMs / 1000L % 60L, tMs / 100L % 10L);
        } else {
            time = "-:--:--.-";
        }
        painter.setFont(this.font);
        UISize size = this.timestampCanvas.getBounds().getSize();
        if (this.fontChanged || size.getWidth() < 4.0f) {
            newWidth = painter.getFMWidth(time) + 16.0f;
            newHeight = this.font.getHeight() * 1.6f;
            boolean doLayout = false;
            boolean doWindowLayout = false;
            if (newWidth != size.getWidth()) {
                this.parentPanel.getLayout().set((UIControl)this.timestampCanvas, "packed_width", (Object)Float.valueOf(newWidth));
                if (newWidth - size.getWidth() > 8.0f) {
                    doLayout = true;
                }
            }
            if (Math.abs(newHeight - size.getHeight()) >= 2.0f) {
                this.parentPanel.getLayout().set((UIControl)this.timestampCanvas, "packed_height", (Object)Float.valueOf(newHeight));
                this.yTimestamp = painter.getFMMiddleLine() + newHeight / 2.0f;
                doWindowLayout = true;
            }
            if (doWindowLayout) {
                this.parentWindow.layout();
            } else if (doLayout) {
                this.parentPanel.layout();
            }
            this.fontChanged = false;
        } else {
            newWidth = size.getWidth();
            newHeight = size.getHeight();
        }
        if (this.backgroundColor.isDisposed() || this.foregroundColor.isDisposed()) {
            this.loadColors();
        }
        painter.setBackground(this.backgroundColor);
        painter.initPath(2);
        painter.addRectangle(0.0f, 0.0f, newWidth, newHeight);
        painter.closePath();
        painter.setForeground(this.foregroundColor);
        painter.drawString(time, 8.0f, this.yTimestamp);
    }
}

