/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.main;

import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfigManager;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarConfigMap;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarItemConfig;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarSectionGeneric;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarSectionTempo;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBarSectionToolItems;
import app.tuxguitar.app.view.toolbar.model.TGToolBarModel;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.List;

public class TGMainToolBar
extends TGToolBarModel {
    private UIPanel panel;
    public static final Integer LEFT_AREA = 0;
    public static final Integer CENTER_AREA = 1;
    public static final Integer RIGHT_AREA = 2;
    public static final Integer[] AREAS = new Integer[]{LEFT_AREA, CENTER_AREA, RIGHT_AREA};
    public static final String[] AREA_NAMES = new String[]{"toolbar.main.left", "toolbar.main.center", "toolbar.main.right"};
    private TGMainToolBarConfig config;

    private TGMainToolBar(TGContext context) {
        super(context);
        String toolBarName = TGConfigManager.getInstance(context).getStringValue("main-toolbar.name");
        TGMainToolBarConfigManager configMgr = new TGMainToolBarConfigManager();
        this.config = configMgr.getConfig(toolBarName);
        if (this.config == null) {
            this.config = configMgr.getDefaultConfig();
        }
    }

    public void createToolBar(UIWindow parentWindow, boolean visible) {
        UIFactory uiFactory = TGApplication.getInstance(this.getContext()).getFactory();
        this.panel = uiFactory.createPanel((UIContainer)parentWindow, false);
        this.panel.setVisible(visible);
        this.layout();
    }

    public void layout() {
        this.clearSections();
        for (UIControl control : this.panel.getChildren()) {
            control.dispose();
        }
        UIWindow parentWindow = (UIWindow)this.panel.getParent();
        UIFactory uiFactory = TGApplication.getInstance(this.getContext()).getFactory();
        UITableLayout mainToolBarLayout = new UITableLayout();
        this.panel.setLayout((UILayout)mainToolBarLayout);
        ArrayList<UIControl> controls = new ArrayList<UIControl>();
        mainToolBarLayout.set("margin", (Object)Float.valueOf(0.0f));
        int col = 1;
        TGMainToolBarConfigMap configMap = new TGMainToolBarConfigMap();
        for (int area : new int[]{LEFT_AREA, CENTER_AREA, RIGHT_AREA}) {
            TGMainToolBarSection section = null;
            TGMainToolBarItemConfig lastAddedItemConfig = null;
            controls.clear();
            for (String toolBarItemName : this.config.getAreaContent(area)) {
                TGMainToolBarItemConfig toolBarItemConfig = configMap.getToolBarItemConfig(toolBarItemName);
                if (toolBarItemConfig == null) {
                    System.out.printf("toolBarItem name not found (ignored): " + toolBarItemName + "\n", new Object[0]);
                    continue;
                }
                int sectionType = toolBarItemConfig.getSectionType();
                if (lastAddedItemConfig == null || sectionType != lastAddedItemConfig.getSectionType()) {
                    if (section != null) {
                        controls.addAll(section.getControls());
                        this.createSection(mainToolBarLayout, section);
                    }
                    if (sectionType == 1) {
                        section = new TGMainToolBarSectionGeneric(this.getContext(), this.panel, parentWindow);
                    } else if (sectionType == 2) {
                        UIToolBar toolBar = uiFactory.createHorizontalToolBar((UIContainer)this.panel);
                        section = new TGMainToolBarSectionToolItems(this.getContext(), toolBar);
                    } else if (toolBarItemConfig.getType() == 5) {
                        section = new TGMainToolBarSectionTempo(this.getContext(), this.panel);
                    }
                }
                section.addToolBarItem(toolBarItemConfig);
                lastAddedItemConfig = toolBarItemConfig;
            }
            if (section == null) continue;
            controls.addAll(section.getControls());
            this.createSection(mainToolBarLayout, section);
            this.layoutControls(mainToolBarLayout, area, col, controls);
            col += controls.size();
        }
        this.panel.layout();
    }

    public TGMainToolBarConfig getConfig() {
        return this.config;
    }

    public void setConfig(TGMainToolBarConfig config) {
        this.config = config;
    }

    private void createSection(UITableLayout layout, TGMainToolBarSection section) {
        section.loadIcons();
        section.loadProperties();
        section.setLayoutProperties(layout);
        this.addSection(section);
    }

    private void layoutControls(UITableLayout mainToolBarLayout, int area, int col, List<UIControl> controls) {
        for (int i = 0; i < controls.size(); ++i) {
            boolean fillX;
            UIControl control = controls.get(i);
            boolean isFirst = i == 0;
            boolean isLast = i == controls.size() - 1;
            int alignX = UITableLayout.ALIGN_LEFT;
            boolean bl = fillX = isFirst && area != LEFT_AREA || isLast && area != RIGHT_AREA;
            if (area == CENTER_AREA) {
                if (isFirst && !isLast) {
                    alignX = UITableLayout.ALIGN_RIGHT;
                } else if (isFirst && isLast) {
                    alignX = UITableLayout.ALIGN_CENTER;
                }
            } else if (area == RIGHT_AREA) {
                alignX = UITableLayout.ALIGN_RIGHT;
            }
            mainToolBarLayout.set(control, Integer.valueOf(1), Integer.valueOf(col), Integer.valueOf(alignX), UITableLayout.ALIGN_CENTER, Boolean.valueOf(fillX), Boolean.valueOf(true));
            ++col;
        }
    }

    public UIPanel getControl() {
        return this.panel;
    }

    public static TGMainToolBar getInstance(TGContext context) {
        return (TGMainToolBar)TGSingletonUtil.getInstance((TGContext)context, (String)TGMainToolBar.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMainToolBar>(){

            public TGMainToolBar createInstance(TGContext context) {
                return new TGMainToolBar(context);
            }
        });
    }
}

