/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.edit;

import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.component.tab.edit.EditorKit;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.toolbar.UIToolActionItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;
import app.tuxguitar.util.TGContext;

public class TGEditToolBarSectionEdit
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "edit";
    private UIToolCheckableItem modeSelection;
    private UIToolCheckableItem modeEdition;
    private UIToolCheckableItem notNaturalKey;
    private UIToolCheckableItem voice1;
    private UIToolCheckableItem voice2;
    private UIToolCheckableItem freeEditionMode;
    private UIToolActionItem openMeasureErrorsDialog;

    public TGEditToolBarSectionEdit(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    @Override
    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.modeSelection = toolBar.createCheckItem();
        this.modeSelection.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-selection"));
        this.modeEdition = toolBar.createCheckItem();
        this.modeEdition.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = toolBar.createCheckItem();
        this.notNaturalKey.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-natural-key"));
        toolBar.createSeparator();
        this.voice1 = toolBar.createCheckItem();
        this.voice1.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-1"));
        this.voice2 = toolBar.createCheckItem();
        this.voice2.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-2"));
        toolBar = this.createToolBar();
        this.freeEditionMode = toolBar.createCheckItem();
        this.freeEditionMode.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.toggle-free-edition-mode"));
        this.openMeasureErrorsDialog = toolBar.createActionItem();
        this.openMeasureErrorsDialog.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.display-errors"));
    }

    @Override
    public void updateSectionItems() {
        TGContext context = this.getToolBar().getContext();
        TablatureEditor editor = TablatureEditor.getInstance(context);
        EditorKit editorKit = editor.getTablature().getEditorKit();
        boolean running = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext()).isRunning();
        this.modeSelection.setChecked(editorKit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!running);
        this.modeEdition.setChecked(editorKit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!running);
        this.freeEditionMode.setChecked(TGDocumentManager.getInstance((TGContext)context).getSongManager().isFreeEditionMode((TGMeasure)editor.getTablature().getCaret().getMeasure()));
        this.freeEditionMode.setEnabled(!running);
        this.openMeasureErrorsDialog.setEnabled(!running);
        this.notNaturalKey.setChecked(!editorKit.isNatural());
        this.notNaturalKey.setEnabled(!running && editorKit.getMouseMode() == 2);
        this.voice1.setChecked(editor.getTablature().getCaret().getVoice() == 0);
        this.voice1.setEnabled(!running);
        this.voice2.setChecked(editor.getTablature().getCaret().getVoice() == 1);
        this.voice2.setEnabled(!running);
    }

    @Override
    public void loadSectionProperties() {
        this.modeSelection.setToolTipText(this.getText("edit.mouse-mode-selection"));
        this.modeEdition.setToolTipText(this.getText("edit.mouse-mode-edition"));
        this.notNaturalKey.setToolTipText(this.getText("edit.not-natural-key"));
        this.voice1.setToolTipText(this.getText("edit.voice-1"));
        this.voice2.setToolTipText(this.getText("edit.voice-2"));
        this.freeEditionMode.setToolTipText(this.getText("edit.free-edition-mode"));
        this.openMeasureErrorsDialog.setToolTipText(this.getText("edit.measure-errors-dialog"));
    }

    @Override
    public void loadSectionIcons() {
        this.modeSelection.setImage(this.getIconManager().getImageByName("edit_mode_selection.png"));
        this.modeEdition.setImage(this.getIconManager().getImageByName("edit_mode_edition.png"));
        this.notNaturalKey.setImage(this.getIconManager().getImageByName("edit_mode_edition_no_natural.png"));
        this.voice1.setImage(this.getIconManager().getImageByName("edit_voice_1.png"));
        this.voice2.setImage(this.getIconManager().getImageByName("edit_voice_2.png"));
        this.freeEditionMode.setImage(this.getIconManager().getImageByName("edit_mode_free.png"));
        this.openMeasureErrorsDialog.setImage(this.getIconManager().getImageByName("measure_status_check.png"));
    }
}

