/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.component.table.TGTableViewer;
import app.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import app.tuxguitar.graphics.control.TGLayoutHorizontal;
import app.tuxguitar.graphics.control.TGLayoutVertical;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class ViewMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem layoutMenuItem;
    private UIMenuCheckableItem showMainToolbar;
    private UIMenuActionItem editMainToolbar;
    private UIMenuCheckableItem showEditToolbar;
    private UIMenuCheckableItem showTableViewer;
    private UIMenuCheckableItem showFretBoard;
    private UIMenuCheckableItem showInstruments;
    private UIMenuCheckableItem showTransport;
    private UIMenuCheckableItem showPiano;
    private UIMenuCheckableItem showMatrix;
    private UIMenuCheckableItem pageLayout;
    private UIMenuCheckableItem linearLayout;
    private UIMenuCheckableItem multitrack;
    private UIMenuCheckableItem scoreEnabled;
    private UIMenuCheckableItem tablatureEnabled;
    private UIMenuCheckableItem compact;
    private UIMenuActionItem zoomIn;
    private UIMenuActionItem zoomOut;
    private UIMenuActionItem zoomReset;
    private UIMenuSubMenuItem chordMenuItem;
    private UIMenuCheckableItem chordName;
    private UIMenuCheckableItem chordDiagram;

    public ViewMenuItem(UIMenu parent) {
        this.layoutMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.showMainToolbar = this.layoutMenuItem.getMenu().createCheckItem();
        this.showMainToolbar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-main-toolbar"));
        this.editMainToolbar = this.layoutMenuItem.getMenu().createActionItem();
        this.editMainToolbar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-maintoolbar-settings-dialog"));
        this.showEditToolbar = this.layoutMenuItem.getMenu().createCheckItem();
        this.showEditToolbar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-edit-toolbar"));
        this.showTableViewer = this.layoutMenuItem.getMenu().createCheckItem();
        this.showTableViewer.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-table-viewer"));
        this.showFretBoard = this.layoutMenuItem.getMenu().createCheckItem();
        this.showFretBoard.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-fretboard-editor"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.showInstruments = this.layoutMenuItem.getMenu().createCheckItem();
        this.showInstruments.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-channels-dialog"));
        this.showTransport = this.layoutMenuItem.getMenu().createCheckItem();
        this.showTransport.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-transport-dialog"));
        this.showPiano = this.layoutMenuItem.getMenu().createCheckItem();
        this.showPiano.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-piano-editor"));
        this.showMatrix = this.layoutMenuItem.getMenu().createCheckItem();
        this.showMatrix.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-matrix-editor"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.pageLayout = this.layoutMenuItem.getMenu().createRadioItem();
        this.pageLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-page"));
        this.linearLayout = this.layoutMenuItem.getMenu().createRadioItem();
        this.linearLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-linear"));
        this.multitrack = this.layoutMenuItem.getMenu().createCheckItem();
        this.multitrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-multitrack"));
        this.scoreEnabled = this.layoutMenuItem.getMenu().createCheckItem();
        this.scoreEnabled.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-score-enabled"));
        this.tablatureEnabled = this.layoutMenuItem.getMenu().createCheckItem();
        this.tablatureEnabled.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-tablature-enabled"));
        this.compact = this.layoutMenuItem.getMenu().createCheckItem();
        this.compact.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-compact"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.chordMenuItem = this.layoutMenuItem.getMenu().createSubMenuItem();
        this.chordName = this.chordMenuItem.getMenu().createCheckItem();
        this.chordName.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-chord-name-enabled"));
        this.chordDiagram = this.chordMenuItem.getMenu().createCheckItem();
        this.chordDiagram.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-chord-diagram-enabled"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.zoomIn = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomIn.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-increment-scale"));
        this.zoomOut = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomOut.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-decrement-scale"));
        this.zoomReset = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomReset.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-reset-scale"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        Tablature tablature = TablatureEditor.getInstance(this.findContext()).getTablature();
        int style = tablature.getViewLayout().getStyle();
        this.showMainToolbar.setChecked(TGMainToolBar.getInstance(this.findContext()).isVisible());
        this.showEditToolbar.setChecked(TGEditToolBar.getInstance(this.findContext()).isVisible());
        this.showTableViewer.setChecked(TGTableViewer.getInstance(this.findContext()).isVisible());
        this.showFretBoard.setChecked(TuxGuitar.getInstance().getFretBoardEditor().isVisible());
        this.showInstruments.setChecked(!TuxGuitar.getInstance().getChannelManager().isDisposed());
        this.showTransport.setChecked(!TGTransportDialog.getInstance(this.findContext()).isDisposed());
        this.showPiano.setChecked(!TuxGuitar.getInstance().getPianoEditor().isDisposed());
        this.showMatrix.setChecked(!TuxGuitar.getInstance().getMatrixEditor().isDisposed());
        this.pageLayout.setChecked(tablature.getViewLayout() instanceof TGLayoutVertical);
        this.linearLayout.setChecked(tablature.getViewLayout() instanceof TGLayoutHorizontal);
        this.multitrack.setChecked((style & 2) != 0);
        this.scoreEnabled.setChecked((style & 4) != 0);
        this.tablatureEnabled.setChecked((style & 8) != 0);
        this.compact.setEnabled((style & 2) == 0 || tablature.getViewLayout().getSong().countTracks() == 1);
        this.compact.setChecked(this.compact.isEnabled() && (style & 1) != 0);
        this.chordName.setChecked((style & 0x10) != 0);
        this.chordDiagram.setChecked((style & 0x20) != 0);
        this.zoomReset.setEnabled(!Tablature.DEFAULT_SCALE.equals(tablature.getScale()));
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.layoutMenuItem, "view", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showMainToolbar, "view.show-main-toolbar", "action.gui.toggle-main-toolbar");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.editMainToolbar, "toolbar.settings", "action.gui.open-maintoolbar-settings-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showEditToolbar, "view.show-edit-toolbar", "action.gui.toggle-main-toolbar");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showTableViewer, "view.show-table-viewer", "action.gui.toggle-table-viewer");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showFretBoard, "view.show-fretboard", "action.gui.toggle-fretboard-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showInstruments, "view.show-instruments", "action.gui.toggle-channels-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showTransport, "view.show-transport", "action.gui.toggle-transport-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showPiano, "view.show-piano", "action.gui.toggle-piano-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showMatrix, "view.show-matrix", "action.gui.toggle-matrix-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pageLayout, "view.layout.page", "action.view.layout-set-page");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.linearLayout, "view.layout.linear", "action.view.layout-set-linear");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.multitrack, "view.layout.multitrack", "action.view.layout-set-multitrack");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.scoreEnabled, "view.layout.score-enabled", "action.view.layout-set-score-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tablatureEnabled, "view.layout.tablature-enabled", "action.view.layout-set-tablature-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.compact, "view.layout.compact", "action.view.layout-set-compact");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordMenuItem, "view.layout.chord-style", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordName, "view.layout.chord-name", "action.view.layout-set-chord-name-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordDiagram, "view.layout.chord-diagram", "action.view.layout-set-chord-diagram-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomIn, "view.zoom.in", "action.view.layout-increment-scale");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomOut, "view.zoom.out", "action.view.layout-decrement-scale");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomReset, "view.zoom.reset", "action.view.layout-reset-scale");
    }

    public void loadIcons() {
        this.showMainToolbar.setImage(TuxGuitar.getInstance().getIconManager().getToolbarMain());
        this.editMainToolbar.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("settings.png"));
        this.showEditToolbar.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("toolbar_edit.png"));
        this.showTableViewer.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("table_viewer.png"));
        this.showFretBoard.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("fretboard.png"));
        this.showInstruments.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("mixer.png"));
        this.showTransport.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("transport.png"));
        this.showPiano.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("piano.png"));
        this.showMatrix.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("matrix.png"));
        this.pageLayout.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_page.png"));
        this.linearLayout.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_linear.png"));
        this.multitrack.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_multitrack.png"));
        this.scoreEnabled.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_score.png"));
        this.tablatureEnabled.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_tablature.png"));
        this.compact.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("layout_compact.png"));
        this.zoomIn.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("zoom_in.png"));
        this.zoomOut.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("zoom_out.png"));
        this.zoomReset.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("zoom_original.png"));
    }
}

