/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.piano;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.config.TGConfigDefaults;
import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.dialog.piano.TGPianoEditor;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIColorChooser;
import app.tuxguitar.ui.chooser.UIColorChooserHandler;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.resource.UIFontModel;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.properties.TGProperties;

public class TGPianoConfig {
    private static final float MINIMUM_CONTROL_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private TGContext context;
    private UIColor colorNatural;
    private UIColor colorNotNatural;
    private UIColor colorNote;
    private UIColor colorScale;
    private UIColor colorOctaveNumber;
    private UIColor colorNotPlayable;
    private UIFont font;

    public TGPianoConfig(TGContext context) {
        this.context = context;
    }

    public UIColor getColorNatural() {
        return this.colorNatural;
    }

    public UIColor getColorNotNatural() {
        return this.colorNotNatural;
    }

    public UIColor getColorNote() {
        return this.colorNote;
    }

    public UIColor getColorScale() {
        return this.colorScale;
    }

    public UIColor getColorOctaveNumber() {
        return this.colorOctaveNumber;
    }

    public UIColor getColorNotePlayable() {
        return this.colorNotPlayable;
    }

    public UIFont getFont() {
        return this.font;
    }

    public UIColor createColor(UIFactory factory, UIColorModel cm) {
        return TGApplication.getInstance(this.context).getFactory().createColor(cm.getRed(), cm.getGreen(), cm.getBlue());
    }

    public UIFont createFont(UIFactory factory, UIFontModel fm) {
        return TGApplication.getInstance(this.context).getFactory().createFont(fm.getName(), fm.getHeight(), fm.isBold(), fm.isItalic());
    }

    public void load() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        UIFactory factory = TGApplication.getInstance(this.context).getFactory();
        this.colorNatural = this.createColor(factory, config.getColorModelConfigValue("piano.color.natural-key"));
        this.colorNotNatural = this.createColor(factory, config.getColorModelConfigValue("piano.color.not-natural-key"));
        this.colorNote = this.createColor(factory, config.getColorModelConfigValue("piano.color.note"));
        this.colorScale = this.createColor(factory, config.getColorModelConfigValue("piano.color.scale"));
        this.colorOctaveNumber = this.createColor(factory, config.getColorModelConfigValue("piano.color.octave-number"));
        this.colorNotPlayable = this.createColor(factory, config.getColorModelConfigValue("piano.color.not-playable"));
        this.font = this.createFont(factory, config.getFontModelConfigValue("piano.font"));
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("piano.color.natural-key", defaults.getValue("piano.color.natural-key"));
        config.setValue("piano.color.not-natural-key", defaults.getValue("piano.color.not-natural-key"));
        config.setValue("piano.color.note", defaults.getValue("piano.color.note"));
        config.setValue("piano.color.scale", defaults.getValue("piano.color.scale"));
        config.setValue("piano.color.octave-number", defaults.getValue("piano.color.octave-number"));
    }

    public void save(UIColorModel rgbNatural, UIColorModel rgbNotNatural, UIColorModel rgbNote, UIColorModel rgbScale, UIColorModel rgbOctaveNumber) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("piano.color.natural-key", rgbNatural);
        config.setValue("piano.color.not-natural-key", rgbNotNatural);
        config.setValue("piano.color.note", rgbNote);
        config.setValue("piano.color.scale", rgbScale);
        config.setValue("piano.color.octave-number", rgbOctaveNumber);
    }

    public void dispose() {
        this.colorNatural.dispose();
        this.colorNotNatural.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
        this.colorOctaveNumber.dispose();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public void configure(UIWindow parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout windowLayout = new UITableLayout();
        final UIWindow window = factory.createWindow(parent, true, false);
        window.setLayout((UILayout)windowLayout);
        window.setText(TuxGuitar.getProperty("piano.settings"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = factory.createLegendPanel((UIContainer)window);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("piano.settings"));
        windowLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int groupRow = 0;
        final UIColorModel rgbNatural = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("piano.natural-key-color") + ":", this.colorNatural, ++groupRow);
        final UIColorModel rgbNotNatural = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("piano.not-natural-key-color") + ":", this.colorNotNatural, ++groupRow);
        final UIColorModel rgbNote = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("piano.note-color") + ":", this.colorNote, ++groupRow);
        final UIColorModel rgbScale = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("piano.scale-note-color") + ":", this.colorScale, ++groupRow);
        final UIColorModel rgbOctaveNumber = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("piano.octave-number-color") + ":", this.colorOctaveNumber, ++groupRow);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)window, false);
        buttons.setLayout((UILayout)buttonsLayout);
        windowLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonDefaults = factory.createButton((UIContainer)buttons);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGPianoConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
                this.this$0.defaults();
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonDefaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonOK = factory.createButton((UIContainer)buttons);
        buttonOK.setDefaultButton();
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGPianoConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
                this.this$0.save(rgbNatural, rgbNotNatural, rgbNote, rgbScale, rgbOctaveNumber);
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGPianoConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(window, 5);
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
        TGPianoEditor.getInstance(this.context).getPiano().reloadFromConfig();
    }

    private UIColorModel getColorChooser(UIWindow window, UILayoutContainer parent, String title, UIColor rgb, int row) {
        UIFactory factory = this.getUIFactory();
        UITableLayout layout = (UITableLayout)parent.getLayout();
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(title);
        layout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        ButtonColor button = new ButtonColor(window, (UIContainer)parent, TuxGuitar.getProperty("choose"));
        button.loadColor(new UIColorModel(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
        layout.set(button.getControl(), Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        return button.getValue();
    }

    private class ButtonColor {
        private UIWindow window;
        private UIButton button;
        private UIColor color;
        private UIColorModel value;

        public ButtonColor(UIWindow window, UIContainer parent, String text) {
            this.window = window;
            this.value = new UIColorModel();
            this.button = TGPianoConfig.this.getUIFactory().createButton(parent);
            this.button.setText(text);
            this.addListeners();
        }

        public void loadColor(UIColorModel cm) {
            this.value.setRed(cm.getRed());
            this.value.setGreen(cm.getGreen());
            this.value.setBlue(cm.getBlue());
            UIColor color = TGPianoConfig.this.getUIFactory().createColor(this.value);
            this.button.setFgColor(color);
            this.disposeColor();
            this.color = color;
        }

        public void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        public void addListeners() {
            this.button.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    UIColorChooser dlg = TGPianoConfig.this.getUIFactory().createColorChooser(ButtonColor.this.window);
                    dlg.setDefaultModel(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    dlg.choose(new UIColorChooserHandler(){

                        public void onSelectColor(UIColorModel model) {
                            if (model != null) {
                                ButtonColor.this.loadColor(model);
                            }
                        }
                    });
                }
            });
            this.button.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        public UIControl getControl() {
            return this.button;
        }

        public UIColorModel getValue() {
            return this.value;
        }
    }
}

