/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.matrix;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.transport.TGTransport;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.dialog.matrix.TGMatrixConfig;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import app.tuxguitar.app.view.util.TGBufferedPainterLocked;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGNoteImpl;
import app.tuxguitar.player.base.MidiPercussionKey;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseEnterListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseExitListener;
import app.tuxguitar.ui.event.UIMouseMoveListener;
import app.tuxguitar.ui.event.UIMouseUpListener;
import app.tuxguitar.ui.event.UIPaintListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.resource.UISize;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICanvas;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UIImageView;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScrollBar;
import app.tuxguitar.ui.widget.UIScrollBarPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISeparator;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGMusicKeyUtils;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.List;

public class TGMatrixEditor
implements TGEventListener {
    private static final float DEFAULT_WIDTH = 640.0f;
    private static final float DEFAULT_HEIGHT = 480.0f;
    private static final int BORDER_HEIGHT = 20;
    private static final int SCROLL_INCREMENT = 50;
    private static final int[] DIVISIONS = new int[]{1, 2, 3, 4, 6, 8, 16};
    private MidiPercussionKey[] percussions;
    private TGContext context;
    private TGMatrixConfig config;
    private UIWindow dialog;
    private UIPanel composite;
    private UIPanel toolbar;
    private UIScrollBarPanel canvasPanel;
    private UICanvas editor;
    private UIRectangle clientArea;
    private UIImage buffer;
    private BufferDisposer bufferDisposer;
    private UIImageView durationLabel;
    private UILabel gridsLabel;
    private UIButton goLeft;
    private UIButton goRight;
    private UIButton increment;
    private UIButton decrement;
    private UIButton settings;
    private float width;
    private float height;
    private float bufferWidth;
    private float bufferHeight;
    private float timeWidth;
    private float lineHeight;
    private float leftSpacing;
    private int minNote;
    private int maxNote;
    private int duration;
    private int selection;
    private int grids;

    public TGMatrixEditor(TGContext context) {
        this.context = context;
        this.grids = this.loadGrids();
    }

    public void show() {
        this.percussions = TuxGuitar.getInstance().getPlayer().getPercussionKeys();
        this.config = new TGMatrixConfig(this.context);
        this.config.load();
        this.dialog = this.getUIFactory().createWindow(TGWindow.getInstance(this.context).getWindow(), false, true);
        this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setBounds(new UIRectangle(new UISize(640.0f, 480.0f)));
        this.dialog.addDisposeListener((UIDisposeListener)new DisposeListenerImpl());
        this.bufferDisposer = new BufferDisposer();
        this.composite = this.getUIFactory().createPanel((UIContainer)this.dialog, false);
        this.initToolBar();
        this.initEditor();
        this.createWindowLayout();
        this.createControlLayout();
        this.loadIcons();
        this.addListeners();
        TGDialogUtil.openDialog(this.dialog, 6);
    }

    public void createWindowLayout() {
        UITableLayout uiLayout = new UITableLayout();
        uiLayout.set((UIControl)this.composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.dialog.setLayout((UILayout)uiLayout);
    }

    public void createControlLayout() {
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        uiLayout.set((UIControl)this.toolbar, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        uiLayout.set((UIControl)this.canvasPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.composite.setLayout((UILayout)uiLayout);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.toolbar);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((UIControl)this.editor);
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
    }

    private void initToolBar() {
        UIFactory uiFactory = this.getUIFactory();
        int column = 0;
        this.toolbar = uiFactory.createPanel((UIContainer)this.composite, false);
        this.createToolBarLayout();
        this.goLeft = uiFactory.createButton((UIContainer)this.toolbar);
        this.goLeft.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        this.createToolItemLayout((UIControl)this.goLeft, ++column);
        this.goRight = uiFactory.createButton((UIContainer)this.toolbar);
        this.goRight.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        this.createToolItemLayout((UIControl)this.goRight, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.increment = uiFactory.createButton((UIContainer)this.toolbar);
        this.increment.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        this.createToolItemLayout((UIControl)this.increment, ++column);
        this.durationLabel = uiFactory.createImageView((UIContainer)this.toolbar);
        this.createToolItemLayout((UIControl)this.durationLabel, ++column);
        this.decrement = uiFactory.createButton((UIContainer)this.toolbar);
        this.decrement.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        this.createToolItemLayout((UIControl)this.decrement, ++column);
        this.createToolSeparator(uiFactory, ++column);
        this.gridsLabel = uiFactory.createLabel((UIContainer)this.toolbar);
        this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids") + ":");
        this.createToolItemLayout((UIControl)this.gridsLabel, ++column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, false, false);
        final UIDropDownSelect divisionsCombo = uiFactory.createDropDownSelect((UIContainer)this.toolbar);
        for (int i = 0; i < DIVISIONS.length; ++i) {
            divisionsCombo.addItem(new UISelectItem(Integer.toString(DIVISIONS[i]), (Object)DIVISIONS[i]));
        }
        divisionsCombo.setSelectedValue(this.grids > 0 ? Integer.valueOf(this.grids) : null);
        divisionsCombo.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMatrixEditor this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                Integer grids = (Integer)divisionsCombo.getSelectedValue();
                if (grids != null) {
                    this.this$0.setGrids(grids);
                }
            }
        });
        this.createToolItemLayout((UIControl)divisionsCombo, ++column);
        this.settings = uiFactory.createButton((UIContainer)this.toolbar);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("settings.png"));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMatrixEditor.this.configure();
            }
        });
        this.createToolItemLayout((UIControl)this.settings, ++column, UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, true, false);
        this.toolbar.getLayout().set((UIControl)this.goLeft, "margin_left", (Object)Float.valueOf(0.0f));
        this.toolbar.getLayout().set((UIControl)this.settings, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void createToolBarLayout() {
        UITableLayout uiLayout = new UITableLayout();
        uiLayout.set("margin_left", (Object)Float.valueOf(0.0f));
        uiLayout.set("margin_right", (Object)Float.valueOf(0.0f));
        this.toolbar.setLayout((UILayout)uiLayout);
    }

    private void createToolItemLayout(UIControl uiControl, int column) {
        this.createToolItemLayout(uiControl, column, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, false, false);
    }

    private void createToolItemLayout(UIControl uiControl, int column, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY) {
        UITableLayout uiLayout = (UITableLayout)this.toolbar.getLayout();
        uiLayout.set(uiControl, Integer.valueOf(1), Integer.valueOf(column), alignX, alignY, fillX, fillX);
    }

    private void createToolSeparator(UIFactory uiFactory, int column) {
        UISeparator uiSeparator = uiFactory.createVerticalSeparator((UIContainer)this.toolbar);
        UITableLayout uiLayout = (UITableLayout)this.toolbar.getLayout();
        uiLayout.set((UIControl)uiSeparator, Integer.valueOf(1), Integer.valueOf(column), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        uiLayout.set((UIControl)uiSeparator, "packed_width", (Object)Float.valueOf(20.0f));
        uiLayout.set((UIControl)uiSeparator, "packed_height", (Object)Float.valueOf(20.0f));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    public void initEditor() {
        TGMatrixMouseListener mouseListener = new TGMatrixMouseListener(this.context);
        UIFactory uiFactory = this.getUIFactory();
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        this.canvasPanel = uiFactory.createScrollBarPanel((UIContainer)this.composite, true, true, true);
        this.canvasPanel.setLayout((UILayout)uiLayout);
        this.selection = -1;
        this.editor = uiFactory.createCanvas((UIContainer)this.canvasPanel, false);
        this.editor.setFocus();
        this.editor.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.context, new TGMatrixPainterListener()));
        this.editor.addMouseUpListener((UIMouseUpListener)mouseListener);
        this.editor.addMouseEnterListener((UIMouseEnterListener)mouseListener);
        this.editor.addMouseExitListener((UIMouseExitListener)mouseListener);
        this.editor.addMouseMoveListener((UIMouseMoveListener)mouseListener);
        this.canvasPanel.getHScroll().setIncrement(50);
        this.canvasPanel.getHScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMatrixEditor.this.redraw();
            }
        });
        this.canvasPanel.getVScroll().setIncrement(50);
        this.canvasPanel.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMatrixEditor.this.redraw();
            }
        });
        uiLayout.set((UIControl)this.editor, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
    }

    private void updateScroll() {
        if (this.clientArea != null) {
            UIScrollBar vBar = this.canvasPanel.getVScroll();
            UIScrollBar hBar = this.canvasPanel.getHScroll();
            vBar.setMaximum(Math.max(Math.round(this.height - this.clientArea.getHeight()), 0));
            vBar.setThumb(Math.round(this.clientArea.getHeight()));
            hBar.setMaximum(Math.max(Math.round(this.width - this.clientArea.getWidth()), 0));
            hBar.setThumb(Math.round(this.clientArea.getWidth()));
        }
    }

    private int getValueAt(float y) {
        if (this.clientArea == null || y - 20.0f < 0.0f || y + 20.0f > this.clientArea.getHeight()) {
            return -1;
        }
        int scroll = this.canvasPanel.getVScroll().getValue();
        int value = this.maxNote - (int)((y + (float)scroll - 20.0f) / this.lineHeight);
        return value;
    }

    private long getStartAt(float x) {
        TGMeasure measure = this.getMeasure();
        float posX = x + (float)this.canvasPanel.getHScroll().getValue();
        long start = (long)((float)measure.getStart() + (posX - this.leftSpacing) * (float)measure.getLength() / (this.timeWidth * (float)measure.getTimeSignature().getNumerator()));
        return start;
    }

    private void paintEditor(UIPainter painter) {
        this.clientArea = this.editor.getBounds();
        if (this.clientArea != null) {
            UIImage buffer = this.getBuffer();
            this.width = this.bufferWidth;
            this.height = this.bufferHeight + 40.0f;
            this.updateScroll();
            int scrollX = this.canvasPanel.getHScroll().getValue();
            int scrollY = this.canvasPanel.getVScroll().getValue();
            painter.drawImage(buffer, (float)(-scrollX), (float)(20 - scrollY));
            this.paintMeasure(painter, -scrollX, 20 - scrollY);
            this.paintBorders(painter, -scrollX, 0.0f);
            this.paintPosition(painter, -scrollX, 0.0f);
            this.paintSelection(painter, -scrollX, 20 - scrollY);
        }
    }

    private UIImage getBuffer() {
        if (this.clientArea != null) {
            this.bufferDisposer.update(this.clientArea.getWidth(), this.clientArea.getHeight());
            if (this.buffer == null || this.buffer.isDisposed()) {
                int i;
                UIFactory uiFactory = this.getUIFactory();
                String[] names = null;
                TGMeasure measure = this.getMeasure();
                this.maxNote = 0;
                this.minNote = 127;
                if (TuxGuitar.getInstance().getSongManager().isPercussionChannel(this.getCaret().getSong(), measure.getTrack().getChannelId())) {
                    names = new String[this.percussions.length];
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        this.minNote = Math.min(this.minNote, this.percussions[i2].getValue());
                        this.maxNote = Math.max(this.maxNote, this.percussions[i2].getValue());
                        names[i2] = this.percussions[names.length - i2 - 1].getName();
                    }
                } else {
                    int keySignature = this.getCaret().getMeasure().getKeySignature();
                    for (int sNumber = 1; sNumber <= measure.getTrack().stringCount(); ++sNumber) {
                        TGString string = measure.getTrack().getString(sNumber);
                        this.minNote = Math.min(this.minNote, string.getValue());
                        this.maxNote = Math.max(this.maxNote, string.getValue() + measure.getTrack().getMaxFret());
                    }
                    this.minNote = Math.max(this.minNote, 12);
                    this.maxNote = Math.min(this.maxNote, 127);
                    names = new String[this.maxNote - this.minNote + 1];
                    for (int i3 = 0; i3 < names.length; ++i3) {
                        names[i3] = TGMusicKeyUtils.noteFullName((int)(this.maxNote - i3), (int)keySignature);
                    }
                }
                float minimumNameWidth = 110.0f;
                float minimumNameHeight = 1.0f;
                UIImage auxImage = uiFactory.createImage(1.0f, 1.0f);
                UIPainter auxPainter = auxImage.createPainter();
                auxPainter.setFont(this.config.getFont());
                for (int i4 = 0; i4 < names.length; ++i4) {
                    float fmHeight;
                    float fmWidth = auxPainter.getFMWidth(names[i4]);
                    if (fmWidth > minimumNameWidth) {
                        minimumNameWidth = fmWidth;
                    }
                    if (!((fmHeight = auxPainter.getFMHeight()) > minimumNameHeight)) continue;
                    minimumNameHeight = fmHeight;
                }
                auxPainter.dispose();
                auxImage.dispose();
                int cols = measure.getTimeSignature().getNumerator();
                int rows = this.maxNote - this.minNote;
                this.leftSpacing = minimumNameWidth + 10.0f;
                this.lineHeight = Math.max(minimumNameHeight, (this.clientArea.getHeight() - 40.0f) / ((float)rows + 1.0f));
                this.timeWidth = Math.max((float)(10 * (64 / measure.getTimeSignature().getDenominator().getValue())), (this.clientArea.getWidth() - this.leftSpacing) / (float)cols);
                this.bufferWidth = this.leftSpacing + this.timeWidth * (float)cols;
                this.bufferHeight = this.lineHeight * (float)(rows + 1);
                this.buffer = uiFactory.createImage(this.bufferWidth, this.bufferHeight);
                UIPainter painter = this.buffer.createPainter();
                painter.setFont(this.config.getFont());
                painter.setForeground(this.config.getColorForeground());
                for (i = 0; i <= rows; ++i) {
                    painter.setBackground(this.config.getColorLine(i % 2));
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle(0.0f, (float)i * this.lineHeight, this.bufferWidth, this.lineHeight);
                    painter.closePath();
                    painter.drawString(names[i], 5.0f, (float)i * this.lineHeight + this.lineHeight / 2.0f + painter.getFMMiddleLine());
                }
                for (i = 0; i < cols; ++i) {
                    float colX = this.leftSpacing + (float)i * this.timeWidth;
                    float divisionWidth = this.timeWidth / (float)this.grids;
                    for (int j = 0; j < this.grids; ++j) {
                        if (j == 0) {
                            painter.setLineStyleSolid();
                        } else {
                            painter.setLineStyleDot();
                        }
                        painter.initPath();
                        painter.setAntialias(false);
                        painter.moveTo((float)Math.round(colX + (float)j * divisionWidth), 0.0f);
                        painter.lineTo((float)Math.round(colX + (float)j * divisionWidth), this.bufferHeight);
                        painter.closePath();
                    }
                }
                painter.dispose();
            }
        }
        return this.buffer;
    }

    private void paintMeasure(UIPainter painter, float fromX, float fromY) {
        TGMeasure measure;
        if (this.clientArea != null && (measure = this.getMeasure()) != null) {
            for (TGBeat beat : measure.getBeats()) {
                this.paintBeat(painter, measure, beat, fromX, fromY);
            }
        }
    }

    private void paintBeat(UIPainter painter, TGMeasure measure, TGBeat beat, float fromX, float fromY) {
        if (this.clientArea != null) {
            float minimumY = 20.0f;
            float maximumY = this.clientArea.getHeight() - 20.0f;
            TGSongManager songManager = TGDocumentManager.getInstance((TGContext)this.context).getSongManager();
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (int i = 0; i < voice.countNotes(); ++i) {
                    TGNoteImpl note = (TGNoteImpl)voice.getNote(i);
                    float x1 = fromX + this.leftSpacing + (float)(beat.getStart() - measure.getStart()) * (this.timeWidth * (float)measure.getTimeSignature().getNumerator()) / (float)measure.getLength() + 1.0f;
                    float y1 = fromY + (float)(this.maxNote - this.minNote - (songManager.getMeasureManager().getRealNoteValue((TGNote)note) - this.minNote)) * this.lineHeight + 1.0f;
                    float x2 = x1 + (float)voice.getDuration().getTime() * this.timeWidth / (float)measure.getTimeSignature().getDenominator().getTime() - 2.0f;
                    float y2 = y1 + this.lineHeight - 2.0f;
                    if (y1 >= maximumY || y2 <= minimumY) continue;
                    y1 = y1 < minimumY ? minimumY : y1;
                    float f = y2 = y2 > maximumY ? maximumY : y2;
                    if (!(x2 - x1 > 0.0f) || !(y2 - y1 > 0.0f)) continue;
                    painter.setBackground(note.getBeatImpl().isPlaying(TuxGuitar.getInstance().getTablatureEditor().getTablature().getViewLayout()) ? this.config.getColorPlay() : this.config.getColorNote());
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle(x1, y1, x2 - x1, y2 - y1);
                    painter.closePath();
                }
            }
        }
    }

    private void paintBorders(UIPainter painter, float fromX, float fromY) {
        if (this.clientArea != null) {
            painter.setBackground(this.config.getColorBorder());
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle(fromX, fromY, this.bufferWidth, 20.0f);
            painter.addRectangle(fromX, fromY + (this.clientArea.getHeight() - 20.0f), this.bufferWidth, 20.0f);
            painter.closePath();
            painter.initPath();
            painter.setAntialias(false);
            painter.addRectangle(fromX, fromY, this.width, this.clientArea.getHeight());
            painter.closePath();
        }
    }

    private void paintPosition(UIPainter painter, float fromX, float fromY) {
        if (this.clientArea != null && !TuxGuitar.getInstance().getPlayer().isRunning()) {
            Caret caret = this.getCaret();
            TGMeasure measure = this.getMeasure();
            TGBeatImpl beat = caret.getSelectedBeat();
            if (beat != null) {
                float x = (float)(beat.getStart() - measure.getStart()) * (this.timeWidth * (float)measure.getTimeSignature().getNumerator()) / (float)measure.getLength();
                float width = (float)beat.getVoice(caret.getVoice()).getDuration().getTime() * this.timeWidth / (float)measure.getTimeSignature().getDenominator().getTime();
                painter.setBackground(this.config.getColorPosition());
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle(fromX + (this.leftSpacing + x), fromY, width, 20.0f);
                painter.closePath();
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle(fromX + (this.leftSpacing + x), fromY + (this.clientArea.getHeight() - 20.0f), width, 20.0f);
                painter.closePath();
            }
        }
    }

    private void paintSelection(UIPainter painter, float fromX, float fromY) {
        if (this.clientArea != null && !TuxGuitar.getInstance().getPlayer().isRunning() && this.selection >= 0) {
            int x = Math.round(fromX);
            int y = Math.round(fromY + (float)(this.maxNote - this.selection) * this.lineHeight);
            int width = Math.round(this.bufferWidth);
            int height = Math.round(this.lineHeight);
            painter.setAlpha(100);
            painter.setBackground(this.config.getColorLine(2));
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle((float)x, (float)y, (float)width, (float)height);
            painter.closePath();
        }
    }

    private void updateSelection(float y) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning()) {
            int previousSelection = this.selection;
            this.selection = this.getValueAt(y);
            if (this.selection != previousSelection) {
                this.redraw();
            }
        }
    }

    private void hit(float x, float y) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning()) {
            int value = this.getValueAt(y);
            long start = this.getStartAt(x);
            Caret caret = this.getCaret();
            TGMeasure measure = this.getMeasure();
            TGSongManager songManager = TGDocumentManager.getInstance((TGContext)this.context).getSongManager();
            TGVoice voice = songManager.getMeasureManager().getVoiceIn(measure, start, caret.getVoice());
            if (value >= this.minNote && value <= this.maxNote) {
                if (start >= measure.getStart() && voice != null) {
                    if (!this.removeNote(voice.getBeat(), value)) {
                        this.addNote(voice.getBeat(), start, value);
                    }
                } else {
                    this.play(value);
                }
            } else if (voice != null) {
                this.moveTo(voice.getBeat());
            }
        }
    }

    private boolean removeNote(TGBeat beat, int value) {
        TGMeasure measure = this.getMeasure();
        TGSongManager songManager = TGDocumentManager.getInstance((TGContext)this.context).getSongManager();
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice voice = beat.getVoice(v);
            for (TGNoteImpl note : voice.getNotes()) {
                if (songManager.getMeasureManager().getRealNoteValue((TGNote)note) != value) continue;
                TGString string = measure.getTrack().getString(note.getString());
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                tgActionProcessor.process();
                this.moveTo(beat, string);
                return true;
            }
        }
        return false;
    }

    private boolean addNote(TGBeat beat, long start, int value) {
        if (beat != null) {
            TGMeasure measure = this.getMeasure();
            List strings = measure.getTrack().getStrings();
            for (int i = 0; i < strings.size(); ++i) {
                TGString string = (TGString)strings.get(i);
                if (value < string.getValue()) continue;
                boolean emptyString = true;
                block1: for (int v = 0; v < beat.countVoices(); ++v) {
                    TGVoice voice = beat.getVoice(v);
                    for (TGNoteImpl note : voice.getNotes()) {
                        if (note.getString() != string.getNumber()) continue;
                        emptyString = false;
                        continue block1;
                    }
                }
                if (!emptyString) continue;
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
                tgActionProcessor.setAttribute("position", (Object)start);
                tgActionProcessor.setAttribute("fret", (Object)(value - string.getValue()));
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
                tgActionProcessor.process();
                this.moveTo(beat, string);
                return true;
            }
        }
        return false;
    }

    private void moveTo(TGBeat beat) {
        this.moveTo(beat, null);
    }

    private void moveTo(TGBeat beat, TGString string) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.caret.move-to");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        if (string != null) {
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        }
        tgActionProcessor.process();
    }

    private void play(final int value) {
        new Thread(new Runnable(){
            final /* synthetic */ TGMatrixEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TGTrack tgTrack = this.this$0.getMeasure().getTrack();
                TGChannel tgChannel = TuxGuitar.getInstance().getSongManager().getChannel(tgTrack.getSong(), tgTrack.getChannelId());
                if (tgChannel != null) {
                    int volume = 127;
                    int balance = 64;
                    short chorus = tgChannel.getChorus();
                    short reverb = tgChannel.getReverb();
                    short phaser = tgChannel.getPhaser();
                    short tremolo = tgChannel.getTremolo();
                    int channel = tgChannel.getChannelId();
                    short program = tgChannel.getProgram();
                    short bank = tgChannel.getBank();
                    int[][] beat = new int[][]{{tgTrack.getOffset() + value, 95}};
                    TuxGuitar.getInstance().getPlayer().playBeat(channel, (int)bank, (int)program, volume, balance, (int)chorus, (int)reverb, (int)phaser, (int)tremolo, (int[][])beat);
                }
            }
        }).start();
    }

    private int loadGrids() {
        int grids = TuxGuitar.getInstance().getConfig().getIntegerValue("matrix.grids");
        for (int i = 0; i < DIVISIONS.length; ++i) {
            if (grids != DIVISIONS[i]) continue;
            return grids;
        }
        return DIVISIONS[1];
    }

    private void setGrids(int grids) {
        this.grids = grids;
        this.disposeBuffer();
        this.redraw();
    }

    public int getGrids() {
        return this.grids;
    }

    private TGMeasure getMeasure() {
        TGMeasureImpl measure;
        if (TuxGuitar.getInstance().getPlayer().isRunning() && (measure = TGTransport.getInstance(this.context).getCache().getPlayMeasure()) != null) {
            return measure;
        }
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
    }

    private Caret getCaret() {
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.editor.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        this.redraw();
    }

    private void configure() {
        this.config.configure(this.dialog);
    }

    public void reloadFromConfig() {
        this.disposeBuffer();
        this.redraw();
    }

    private void layout() {
        if (!this.isDisposed()) {
            this.composite.layout();
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.goLeft.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_left.png"));
            this.goRight.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_right.png"));
            this.decrement.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_down.png"));
            this.increment.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("arrow_up.png"));
            this.settings.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("settings.png"));
            this.loadDurationImage(true);
            this.layout();
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
            this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids"));
            this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
            this.disposeBuffer();
            this.layout();
            this.redraw();
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    private void disposeBuffer() {
        if (this.buffer != null && !this.buffer.isDisposed()) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    private void disposeAll() {
        this.disposeBuffer();
        this.config.dispose();
    }

    private UICanvas getEditor() {
        return this.editor;
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
            final /* synthetic */ TGMatrixEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if ("ui-skin".equals(event.getEventType())) {
                    this.this$0.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    this.this$0.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    this.this$0.processRedrawEvent(event);
                }
            }
        });
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public static TGMatrixEditor getInstance(TGContext context) {
        return (TGMatrixEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGMatrixEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMatrixEditor>(){

            public TGMatrixEditor createInstance(TGContext context) {
                return new TGMatrixEditor(context);
            }
        });
    }

    private class DisposeListenerImpl
    implements UIDisposeListener {
        private DisposeListenerImpl() {
        }

        public void onDispose(UIDisposeEvent event) {
            TGMatrixEditor.this.disposeAll();
            TGMatrixEditor.this.removeListeners();
            TuxGuitar.getInstance().updateCache(true);
        }
    }

    private class BufferDisposer {
        private int numerator;
        private int denominator;
        private int track;
        private boolean percussion;
        private float width;
        private float height;

        private BufferDisposer() {
        }

        public void update(float width, float height) {
            TGMeasure measure = TGMatrixEditor.this.getMeasure();
            int track = measure.getTrack().getNumber();
            int numerator = measure.getTimeSignature().getNumerator();
            int denominator = measure.getTimeSignature().getDenominator().getValue();
            boolean percussion = measure.getTrack().isPercussion();
            if (width != this.width || height != this.height || this.track != track || this.numerator != numerator || this.denominator != denominator || this.percussion != percussion) {
                TGMatrixEditor.this.disposeBuffer();
            }
            this.track = track;
            this.numerator = numerator;
            this.denominator = denominator;
            this.percussion = percussion;
            this.width = width;
            this.height = height;
        }
    }

    private class TGMatrixMouseListener
    implements UIMouseUpListener,
    UIMouseEnterListener,
    UIMouseExitListener,
    UIMouseMoveListener {
        private TGContext context;

        public TGMatrixMouseListener(TGContext context) {
            this.context = context;
        }

        public void onMouseUp(final UIMouseEvent event) {
            TGMatrixEditor.this.getEditor().setFocus();
            if (event.getButton() == 1) {
                new TGSyncProcessLocked(this.context, new Runnable(){
                    final /* synthetic */ TGMatrixMouseListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.TGMatrixEditor.this.hit(event.getPosition().getX(), event.getPosition().getY());
                    }
                }).process();
            }
        }

        public void onMouseMove(final UIMouseEvent event) {
            new TGSyncProcessLocked(this.context, new Runnable(){
                final /* synthetic */ TGMatrixMouseListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.TGMatrixEditor.this.updateSelection(event.getPosition().getY());
                }
            }).process();
        }

        public void onMouseExit(UIMouseEvent event) {
            new TGSyncProcessLocked(this.context, new Runnable(){

                @Override
                public void run() {
                    TGMatrixEditor.this.updateSelection(-1.0f);
                }
            }).process();
        }

        public void onMouseEnter(UIMouseEvent event) {
            new TGSyncProcessLocked(this.context, new Runnable(){

                @Override
                public void run() {
                    TGMatrixEditor.this.redraw();
                }
            }).process();
        }
    }

    private class TGMatrixPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        @Override
        public void paintControl(UIPainter painter) {
            TGMatrixEditor.this.paintEditor(painter);
        }

        @Override
        public UICanvas getPaintableControl() {
            return TGMatrixEditor.this.editor;
        }
    }
}

