/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.errors;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGProcess;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventException;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.song.helpers.TGMeasureError;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIImageView;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.List;

public class TGMeasureErrorDialog
implements TGEventListener {
    private UIWindow dialog;
    private TGContext context;
    private TGMeasureError currentError;
    private UILegendPanel curMeasureLegendPanel;
    private UIImageView measureStatusIcon;
    private UILabel measureStatusLabel;
    private UIButton fixButton;
    private UILegendPanel globalStatusLegendPanel;
    private UIImageView globalStatusIcon;
    private UILabel globalStatusLabel;
    private UILegendPanel errListLegendPanel;
    private UICheckBox showAllTracks;
    private UICheckBox showInvalidMeasures;
    private UICheckBox showInvalidTiedNotes;
    private UITable<TGMeasureError> errTable;
    private UIButton closeButton;
    private TGProcess updateItemsProcess;
    private TGProcess loadIconsProcess;
    private TGProcess loadPropertiesProcess;
    private TGMeasureError selectedError;
    private UIImage imageOK;
    private UIImage imageKO;
    private String sMeasureErrors;
    private String sShowAllTracks;
    private String sShowInvalidMeasures;
    private String sShowInvalidTiedNotes;
    private String sErrorsList;
    private String sCurrentMeasuresStatus;
    private String sFix;
    private String sSongStatus;
    private String sSongValid;
    private String sSongInvalid;
    private String sVoiceValid;
    private String sVoiceTooLong;
    private String sVoiceTooShort;
    private String sVoiceInvalid;
    private String sInvalidTiedNote;
    private String sClose;

    public TGMeasureErrorDialog(TGContext context) {
        this.context = context;
        this.currentError = null;
        this.selectedError = null;
        this.createSyncProcesses();
    }

    public void show(TGViewContext viewContext) {
        UIFactory uiFactory = this.getUIFactory();
        UIWindow uiParent = (UIWindow)viewContext.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.loadIcons();
        this.loadProperties();
        this.dialog = uiFactory.createWindow(uiParent, false, true);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(this.sMeasureErrors);
        UITableLayout curMeasureLayout = new UITableLayout();
        this.curMeasureLegendPanel = uiFactory.createLegendPanel((UIContainer)this.dialog);
        this.curMeasureLegendPanel.setLayout((UILayout)curMeasureLayout);
        dialogLayout.set((UIControl)this.curMeasureLegendPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        this.measureStatusIcon = uiFactory.createImageView((UIContainer)this.curMeasureLegendPanel);
        curMeasureLayout.set((UIControl)this.measureStatusIcon, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        this.measureStatusLabel = uiFactory.createLabel((UIContainer)this.curMeasureLegendPanel);
        curMeasureLayout.set((UIControl)this.measureStatusLabel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.fixButton = uiFactory.createButton((UIContainer)this.curMeasureLegendPanel);
        this.fixButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureError err = TGMeasureErrorDialog.this.currentError;
                if (err != null) {
                    String actionName = err.getErrorType() == 1 ? "action.measure.fix-voice" : "action.note.duration.tied";
                    TGActionProcessor actionProcessor = new TGActionProcessor(TGMeasureErrorDialog.this.context, actionName);
                    actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)err.getMeasure());
                    if (err.getErrorType() == 1) {
                        TuxGuitar.getInstance().getTablatureEditor().getTablature().getSelector().clearSelection();
                        actionProcessor.setAttribute("action.measure.fix-voice.err-code", (Object)TGMeasureErrorDialog.this.currentError.getErrCode());
                        actionProcessor.setAttribute("action.measure.fix-voice.voice-index", (Object)err.getVoiceIndex());
                    } else {
                        actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)err.getInvalidTiedNote());
                    }
                    actionProcessor.process();
                }
            }
        });
        curMeasureLayout.set((UIControl)this.fixButton, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout globalStatusLayout = new UITableLayout();
        this.globalStatusLegendPanel = uiFactory.createLegendPanel((UIContainer)this.dialog);
        this.globalStatusLegendPanel.setLayout((UILayout)globalStatusLayout);
        dialogLayout.set((UIControl)this.globalStatusLegendPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        this.globalStatusIcon = uiFactory.createImageView((UIContainer)this.globalStatusLegendPanel);
        globalStatusLayout.set((UIControl)this.globalStatusIcon, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        this.globalStatusLabel = uiFactory.createLabel((UIContainer)this.globalStatusLegendPanel);
        globalStatusLayout.set((UIControl)this.globalStatusLabel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout filterLayout = new UITableLayout();
        UIPanel filterPanel = uiFactory.createPanel((UIContainer)this.dialog, true);
        filterPanel.setLayout((UILayout)filterLayout);
        dialogLayout.set((UIControl)filterPanel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        this.showAllTracks = uiFactory.createCheckBox((UIContainer)filterPanel);
        this.showAllTracks.setSelected(true);
        this.showAllTracks.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureErrorDialog.this.updateItemsProcess.process();
            }
        });
        filterLayout.set((UIControl)this.showAllTracks, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        this.showInvalidMeasures = uiFactory.createCheckBox((UIContainer)filterPanel);
        this.showInvalidMeasures.setSelected(true);
        this.showInvalidMeasures.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureErrorDialog.this.updateItemsProcess.process();
            }
        });
        filterLayout.set((UIControl)this.showInvalidMeasures, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        this.showInvalidTiedNotes = uiFactory.createCheckBox((UIContainer)filterPanel);
        this.showInvalidTiedNotes.setSelected(true);
        this.showInvalidTiedNotes.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureErrorDialog.this.updateItemsProcess.process();
            }
        });
        filterLayout.set((UIControl)this.showInvalidTiedNotes, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        UITableLayout errListLayout = new UITableLayout();
        this.errListLegendPanel = uiFactory.createLegendPanel((UIContainer)this.dialog);
        this.errListLegendPanel.setLayout((UILayout)errListLayout);
        dialogLayout.set((UIControl)this.errListLegendPanel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.errTable = uiFactory.createTable((UIContainer)this.errListLegendPanel, false);
        this.errTable.setColumns(1);
        this.errTable.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureError err = (TGMeasureError)TGMeasureErrorDialog.this.errTable.getSelectedValue();
                TGMeasureErrorDialog.this.selectedError = err;
                if (err != null) {
                    TGMeasureErrorDialog.this.moveToError(err);
                }
            }
        });
        errListLayout.set(this.errTable, "packed_height", (Object)Float.valueOf(120.0f));
        errListLayout.set(this.errTable, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonLayout = new UITableLayout();
        UIPanel buttonPanel = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttonPanel.setLayout((UILayout)buttonLayout);
        dialogLayout.set((UIControl)buttonPanel, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        this.closeButton = uiFactory.createButton((UIContainer)buttonPanel);
        this.closeButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureErrorDialog.this.dispose();
            }
        });
        buttonLayout.set((UIControl)this.closeButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGMeasureErrorDialog.this.removeListeners();
            }
        });
        TGDialogUtil.openDialog(this.dialog, 1);
    }

    private void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    private void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private void moveToError(TGMeasureError err) {
        int caretVoiceIndex = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getVoice();
        if (caretVoiceIndex != err.getVoiceIndex()) {
            new TGActionProcessor(this.context, caretVoiceIndex == 0 ? "action.edit.voice-2" : "action.edit.voice-1").process();
        }
        TGActionProcessor actionProcessor = new TGActionProcessor(this.context, "action.caret.move-to");
        actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)((TGTrackImpl)err.getMeasure().getTrack()));
        actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)err.getMeasure());
        if (err.getErrorType() == 1) {
            actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)err.getMeasure().getBeat(0));
            actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)err.getMeasure().getTrack().getString(1));
        } else {
            actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)err.getInvalidTiedNote().getVoice().getBeat());
            actionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)err.getMeasure().getTrack().getString(err.getInvalidTiedNote().getString()));
        }
        actionProcessor.setAttribute("keep-selection", (Object)Boolean.FALSE);
        actionProcessor.process();
    }

    private void loadProperties() {
        this.sMeasureErrors = TuxGuitar.getProperty("measure-errors");
        this.sShowAllTracks = TuxGuitar.getProperty("measure-errors.show-all-tracks");
        this.sShowInvalidMeasures = TuxGuitar.getProperty("measure-errors.show-invalid-measures");
        this.sShowInvalidTiedNotes = TuxGuitar.getProperty("measure-errors.show-invalid-tied-notes");
        this.sErrorsList = TuxGuitar.getProperty("measure-errors.errors-list");
        this.sCurrentMeasuresStatus = TuxGuitar.getProperty("measure-errors.current-measure-status");
        this.sFix = TuxGuitar.getProperty("measure-errors.fix-error");
        this.sSongStatus = TuxGuitar.getProperty("measure-errors.song-status");
        this.sSongValid = TuxGuitar.getProperty("measure-errors.song-valid");
        this.sSongInvalid = TuxGuitar.getProperty("measure-errors.song-invalid");
        this.sVoiceValid = TuxGuitar.getProperty("measure-errors.voice-valid");
        this.sVoiceTooLong = TuxGuitar.getProperty("measure-errors.voice-too-long");
        this.sVoiceTooShort = TuxGuitar.getProperty("measure-errors.voice-too-short");
        this.sVoiceInvalid = TuxGuitar.getProperty("measure-errors.voice-invalid");
        this.sInvalidTiedNote = TuxGuitar.getProperty("measure-errors.tied-note-invalid");
        this.sClose = TuxGuitar.getProperty("close");
    }

    private void loadIcons() {
        this.imageOK = TuxGuitar.getInstance().getIconManager().getOK();
        this.imageKO = TuxGuitar.getInstance().getIconManager().getKO();
    }

    private void updateItems() {
        if (this.isDisposed()) {
            return;
        }
        Tablature tablature = TuxGuitar.getInstance().getTablatureEditor().getTablature();
        TGSong song = tablature.getSong();
        TGMeasureImpl measure = tablature.getCaret().getMeasure();
        TGNote note = tablature.getCaret().getSelectedNote();
        int voiceIndex = tablature.getCaret().getVoice();
        TGSongManager songManager = tablature.getSongManager();
        this.showAllTracks.setText(this.sShowAllTracks);
        this.showInvalidMeasures.setText(this.sShowInvalidMeasures);
        this.showInvalidTiedNotes.setText(this.sShowInvalidTiedNotes);
        List listErrors = songManager.getMeasureErrors(song);
        ArrayList<Object> listTableItems = new ArrayList<Object>();
        this.errTable.removeItems();
        this.currentError = null;
        for (TGMeasureError tGMeasureError : listErrors) {
            boolean invalidTiedNoteFilter;
            UITableItem tableItem = new UITableItem((Object)tGMeasureError);
            tableItem.setText(0, this.userMessage(tGMeasureError));
            if (tGMeasureError.isEqualTo(this.selectedError)) {
                this.currentError = tGMeasureError;
            } else if (this.selectedError == null) {
                if (note != null && note.equals(tGMeasureError.getInvalidTiedNote())) {
                    this.currentError = tGMeasureError;
                } else if (measure.equals(tGMeasureError.getMeasure()) && (voiceIndex == tGMeasureError.getVoiceIndex() || this.currentError == null)) {
                    this.currentError = tGMeasureError;
                }
            }
            boolean trackFilter = this.showAllTracks.isSelected() || measure.getTrack().getNumber() == tGMeasureError.getMeasure().getTrack().getNumber();
            boolean invalidMeasureFilter = this.showInvalidMeasures.isSelected() || tGMeasureError.getErrorType() != 1;
            boolean bl = invalidTiedNoteFilter = this.showInvalidTiedNotes.isSelected() || tGMeasureError.getErrorType() != 2;
            if (!trackFilter || !invalidMeasureFilter || !invalidTiedNoteFilter) continue;
            listTableItems.add(tableItem);
        }
        this.selectedError = null;
        if (this.currentError == null) {
            UITableItem tableItem = new UITableItem(null);
            tableItem.setText(0, "");
            listTableItems.add(0, tableItem);
        }
        this.errTable.setColumnName(0, this.sErrorsList);
        for (UITableItem uITableItem : listTableItems) {
            this.errTable.addItem(uITableItem);
            if (this.currentError != uITableItem.getValue()) continue;
            this.errTable.setSelectedItem(uITableItem);
        }
        this.curMeasureLegendPanel.setText(this.sCurrentMeasuresStatus);
        this.measureStatusIcon.setImage(this.currentError == null ? this.imageOK : this.imageKO);
        if (this.currentError == null) {
            this.measureStatusLabel.setText(this.userMessageMeasureValid((TGMeasure)measure, tablature.getCaret().getVoice() + 1));
        } else {
            this.measureStatusLabel.setText(this.userMessage(this.currentError));
        }
        this.fixButton.setText(this.sFix);
        this.fixButton.setEnabled(this.currentError != null && this.currentError.canBeFixed());
        this.globalStatusLegendPanel.setText(this.sSongStatus);
        String songStatusDetailed = new String();
        if (listErrors.size() == 0) {
            this.globalStatusIcon.setImage(this.imageOK);
            songStatusDetailed = this.sSongValid;
        } else {
            this.globalStatusIcon.setImage(this.imageKO);
            songStatusDetailed = this.sSongInvalid.replace("{0}", String.valueOf(listErrors.size()));
        }
        this.globalStatusLabel.setText(songStatusDetailed);
        this.closeButton.setText(this.sClose);
        this.dialog.pack();
    }

    private String userMessage(TGMeasureError err) {
        if (err == null) {
            return null;
        }
        String msg = new String();
        switch (err.getErrorType()) {
            case 2: {
                msg = this.sInvalidTiedNote.replace("{0}", String.valueOf(err.getMeasure().getTrack().getNumber()));
                msg = msg.replace("{1}", String.valueOf(err.getMeasure().getNumber()));
                msg = msg.replace("{2}", String.valueOf(err.getVoiceIndex() + 1));
                break;
            }
            case 1: {
                switch (err.getErrCode()) {
                    case 16: {
                        msg = this.sVoiceTooLong;
                        break;
                    }
                    case 8: {
                        msg = this.sVoiceTooShort;
                        break;
                    }
                    default: {
                        msg = this.sVoiceInvalid;
                    }
                }
                msg = msg.replace("{0}", String.valueOf(err.getMeasure().getTrack().getNumber()));
                msg = msg.replace("{1}", String.valueOf(err.getMeasure().getNumber()));
                msg = msg.replace("{2}", String.valueOf(err.getVoiceIndex() + 1));
                break;
            }
            default: {
                return null;
            }
        }
        return msg;
    }

    private String userMessageMeasureValid(TGMeasure measure, int voiceIndex) {
        String msg = this.sVoiceValid;
        msg = msg.replace("{0}", String.valueOf(measure.getTrack().getNumber()));
        msg = msg.replace("{1}", String.valueOf(measure.getNumber()));
        msg = msg.replace("{2}", String.valueOf(voiceIndex));
        return msg;
    }

    private void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGMeasureErrorDialog.this.updateItems();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGMeasureErrorDialog.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGMeasureErrorDialog.this.loadProperties();
            }
        });
    }

    public void processEvent(TGEvent event) throws TGEventException {
        if (!this.isDisposed()) {
            if ("ui-update".equals(event.getEventType())) {
                int type = (Integer)event.getAttribute("updateMode");
                if (type == 1) {
                    this.updateItemsProcess.process();
                }
            } else if ("ui-skin".equals(event.getEventType())) {
                this.loadIconsProcess.process();
            } else if ("language".equals(event.getEventType())) {
                this.loadPropertiesProcess.process();
            }
        }
    }

    public static TGMeasureErrorDialog getInstance(TGContext context) {
        return (TGMeasureErrorDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGMeasureErrorDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMeasureErrorDialog>(){

            public TGMeasureErrorDialog createInstance(TGContext context) {
                return new TGMeasureErrorDialog(context);
            }
        });
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    private UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }
}

