/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.chord;

import app.tuxguitar.app.view.dialog.chord.TGChordDatabase;

public class TGChordNamingConvention {
    public String createChordName(int chordTonic, int chordIndex, int alteration, int plusMinus, boolean add, int add5, int add9, int add11, int bassTonic, boolean sharp) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTonic(chordTonic, sharp));
        String chordName = TGChordDatabase.get(chordIndex).getName();
        if (!chordName.equals("M")) {
            sb.append(chordName);
        }
        if (add) {
            sb.append("add");
        }
        if (alteration != 0) {
            char lastChar = sb.toString().charAt(sb.toString().length() - 1);
            if (lastChar >= '0' && lastChar <= '9') {
                sb.append("/");
            }
            switch (alteration) {
                case 1: {
                    sb.append(this.getAdd("9", plusMinus));
                    break;
                }
                case 2: {
                    sb.append(this.getAdd("11", plusMinus));
                    break;
                }
                case 3: {
                    sb.append(this.getAdd("13", plusMinus));
                }
            }
        }
        if (add5 != 0) {
            sb.append("/").append(this.getAdd("5", add5));
        }
        if (add9 != 0) {
            sb.append("/").append(this.getAdd("9", add9));
        }
        if (add11 != 0) {
            sb.append("/").append(this.getAdd("11", add11));
        }
        if (chordTonic != bassTonic) {
            sb.append(" \\");
            sb.append(this.getTonic(bassTonic, sharp));
        }
        return sb.toString();
    }

    public String getTonic(int chordTonic, boolean sharp) {
        String retVal;
        switch (chordTonic) {
            case 0: {
                retVal = "C";
                break;
            }
            case 1: {
                retVal = sharp ? "C#" : "Db";
                break;
            }
            case 2: {
                retVal = "D";
                break;
            }
            case 3: {
                retVal = sharp ? "D#" : "Eb";
                break;
            }
            case 4: {
                retVal = "E";
                break;
            }
            case 5: {
                retVal = "F";
                break;
            }
            case 6: {
                retVal = sharp ? "F#" : "Gb";
                break;
            }
            case 7: {
                retVal = "G";
                break;
            }
            case 8: {
                retVal = sharp ? "G#" : "Ab";
                break;
            }
            case 9: {
                retVal = "A";
                break;
            }
            case 10: {
                retVal = sharp ? "A#" : "Bb";
                break;
            }
            default: {
                retVal = "B";
            }
        }
        return retVal;
    }

    private String getAdd(String number, int selectionIndex) {
        StringBuffer retVal = new StringBuffer(number);
        switch (selectionIndex) {
            case 1: {
                retVal.append("+");
                break;
            }
            case 2: {
                retVal.append("-");
            }
        }
        return retVal.toString();
    }
}

