/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.channel;

import app.tuxguitar.app.view.dialog.channel.TGChannelItem;
import app.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScrollBarPanel;
import java.util.ArrayList;
import java.util.List;

public class TGChannelList {
    private static final int SCROLL_INCREMENT = 10;
    private List<TGChannelItem> channelItems;
    private TGChannelManagerDialog dialog;
    protected UIScrollBarPanel channelItemAreaSC;
    protected UIPanel channelItemArea;

    public TGChannelList(TGChannelManagerDialog dialog) {
        this.dialog = dialog;
        this.channelItems = new ArrayList<TGChannelItem>();
    }

    public void show(UILayoutContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        this.channelItemAreaSC = uiFactory.createScrollBarPanel((UIContainer)parent, true, false, true);
        this.channelItemAreaSC.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, true));
        this.channelItemAreaSC.getVScroll().setIncrement(10);
        this.channelItemAreaSC.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelList.this.channelItemAreaSC.layout();
            }
        });
        this.channelItemArea = uiFactory.createPanel((UIContainer)this.channelItemAreaSC, false);
    }

    public void removeChannelsAfter(int count) {
        while (!this.channelItems.isEmpty() && this.channelItems.size() > count) {
            TGChannelItem tgChannelItem = this.channelItems.remove(0);
            tgChannelItem.dispose();
        }
    }

    public TGChannelItem getOrCreateChannelItemAt(int index) {
        while (this.channelItems.size() <= index) {
            TGChannelItem tgChannelItem = new TGChannelItem(this.dialog);
            tgChannelItem.show((UIContainer)this.channelItemArea);
            this.channelItems.add(tgChannelItem);
        }
        return this.channelItems.get(index);
    }

    public void loadProperties() {
        for (TGChannelItem tgChannelItem : this.channelItems) {
            tgChannelItem.loadProperties();
        }
    }

    public void loadIcons() {
        for (TGChannelItem tgChannelItem : this.channelItems) {
            tgChannelItem.loadIcons();
        }
    }

    public void updateItems() {
        boolean countChanged;
        List<TGChannel> channels = this.dialog.getHandle().getChannels();
        boolean bl = countChanged = channels.size() != this.channelItems.size();
        if (countChanged) {
            this.removeChannelsAfter(channels.size());
        }
        for (int i = 0; i < channels.size(); ++i) {
            TGChannel channel = channels.get(i);
            TGChannelItem tgChannelItem = this.getOrCreateChannelItemAt(i);
            tgChannelItem.loadChannel(channel);
        }
        if (countChanged) {
            this.layoutItems();
        }
    }

    public void layoutItems() {
        UITableLayout uiLayout = new UITableLayout();
        for (int i = 0; i < this.channelItems.size(); ++i) {
            uiLayout.set((UIControl)this.channelItems.get(i).getComposite(), Integer.valueOf(i + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        }
        this.channelItemArea.setLayout((UILayout)uiLayout);
        this.channelItemAreaSC.layout();
    }

    public UIScrollBarPanel getControl() {
        return this.channelItemAreaSC;
    }
}

