/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.channel;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import java.util.List;

public class TGChannelHandle {
    private TGContext context;

    public TGChannelHandle(TGContext context) {
        this.context = context;
    }

    public void addChannel() {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.channel.add-new");
        tgActionProcessor.process();
    }

    public void removeChannel(TGChannel channel) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.channel.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
        tgActionProcessor.process();
    }

    public void updateChannel(int id, short bnk, short prg, short vol, short bal, short cho, short rev, short pha, short tre, String name) {
        TGSong song = this.getDocumentManager().getSong();
        TGChannel channel = this.getManager().getChannel(song, id);
        if (channel != null) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.channel.update");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
            tgActionProcessor.setAttribute("bank", (Object)bnk);
            tgActionProcessor.setAttribute("program", (Object)prg);
            tgActionProcessor.setAttribute("volume", (Object)vol);
            tgActionProcessor.setAttribute("balance", (Object)bal);
            tgActionProcessor.setAttribute("chorus", (Object)cho);
            tgActionProcessor.setAttribute("reverb", (Object)rev);
            tgActionProcessor.setAttribute("phaser", (Object)pha);
            tgActionProcessor.setAttribute("tremolo", (Object)tre);
            tgActionProcessor.setAttribute("name", (Object)name);
            tgActionProcessor.process();
        }
    }

    public List<TGChannel> getChannels() {
        return this.getManager().getChannels(this.getDocumentManager().getSong());
    }

    public boolean isAnyTrackConnectedToChannel(TGChannel channel) {
        return this.getManager().isAnyTrackConnectedToChannel(this.getDocumentManager().getSong(), channel.getChannelId());
    }

    public boolean isAnyPercussionChannel() {
        return this.getManager().isAnyPercussionChannel(this.getDocumentManager().getSong());
    }

    public boolean isPlayerRunning() {
        return TuxGuitar.getInstance().getPlayer().isRunning();
    }

    private TGSongManager getManager() {
        return TuxGuitar.getInstance().getSongManager();
    }

    private TGDocumentManager getDocumentManager() {
        return TuxGuitar.getInstance().getDocumentManager();
    }
}

