/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.beat;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGBeatMoveDialog {
    public void show(final TGViewContext context) {
        final TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("beat.move-custom.dialog.title"));
        UITableLayout directionLayout = new UITableLayout();
        UILegendPanel direction = uiFactory.createLegendPanel((UIContainer)dialog);
        direction.setLayout((UILayout)directionLayout);
        direction.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction-tip"));
        dialogLayout.set((UIControl)direction, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel directionLabel = uiFactory.createLabel((UIContainer)direction);
        directionLabel.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction") + ":");
        directionLayout.set((UIControl)directionLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UISelectItem<Integer>[] moveDirections = this.createMoveDirections();
        final UIDropDownSelect directionCombo = uiFactory.createDropDownSelect((UIContainer)direction);
        for (int i = 0; i < moveDirections.length; ++i) {
            directionCombo.addItem(moveDirections[i]);
        }
        directionCombo.setSelectedItem(moveDirections[0]);
        directionLayout.set((UIControl)directionCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final ArrayList<UIControl> move1Controls = new ArrayList<UIControl>();
        UITableLayout move1Layout = new UITableLayout();
        UILegendPanel move1 = uiFactory.createLegendPanel((UIContainer)dialog);
        move1.setLayout((UILayout)move1Layout);
        move1.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-1.tip"));
        dialogLayout.set((UIControl)move1, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel count1Label = uiFactory.createLabel((UIContainer)move1);
        count1Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        move1Layout.set((UIControl)count1Label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        final UISpinner count1Spinner = uiFactory.createSpinner((UIContainer)move1);
        count1Spinner.setMinimum(0);
        count1Spinner.setMaximum(100);
        count1Spinner.setIncrement(1);
        count1Spinner.setValue(0);
        count1Spinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBeatMoveDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.updateControls(count1Spinner.getValue(), move1Controls);
            }
        });
        move1Layout.set((UIControl)count1Spinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel duration1Label = uiFactory.createLabel((UIContainer)move1);
        duration1Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        move1Layout.set((UIControl)duration1Label, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        move1Controls.add((UIControl)duration1Label);
        UISelectItem<Integer>[] moveDurations = this.createMoveDurations();
        final UIDropDownSelect duration1Combo = uiFactory.createDropDownSelect((UIContainer)move1);
        for (int i = 0; i < moveDurations.length; ++i) {
            duration1Combo.addItem(moveDurations[i]);
        }
        duration1Combo.setSelectedValue((Object)1);
        move1Layout.set((UIControl)duration1Combo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        move1Controls.add((UIControl)duration1Combo);
        this.updateControls(0, move1Controls);
        final ArrayList<UIControl> move2Controls = new ArrayList<UIControl>();
        UITableLayout move2Layout = new UITableLayout();
        UILegendPanel move2 = uiFactory.createLegendPanel((UIContainer)dialog);
        move2.setLayout((UILayout)move2Layout);
        move2.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-2.tip"));
        dialogLayout.set((UIControl)move2, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel count2Label = uiFactory.createLabel((UIContainer)move2);
        count2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        move2Layout.set((UIControl)count2Label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        final UISpinner count2Spinner = uiFactory.createSpinner((UIContainer)move2);
        count2Spinner.setValue(0);
        count2Spinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBeatMoveDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.updateControls(count2Spinner.getValue(), move2Controls);
            }
        });
        move2Layout.set((UIControl)count2Spinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel duration2Label = uiFactory.createLabel((UIContainer)move2);
        duration2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        move2Layout.set((UIControl)duration2Label, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)duration2Label);
        final UIDropDownSelect duration2Combo = uiFactory.createDropDownSelect((UIContainer)move2);
        for (int i = 0; i < moveDurations.length; ++i) {
            duration2Combo.addItem(moveDurations[i]);
        }
        duration2Combo.setSelectedValue((Object)4);
        move2Layout.set((UIControl)duration2Combo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)duration2Combo);
        UILabel type2Label = uiFactory.createLabel((UIContainer)move2);
        type2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type") + ":");
        move2Layout.set((UIControl)type2Label, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)type2Label);
        UISelectItem<boolean[]>[] moveDurationTypes = this.createMoveDurationTypes();
        final UIDropDownSelect type2Combo = uiFactory.createDropDownSelect((UIContainer)move2);
        for (int i = 0; i < moveDurationTypes.length; ++i) {
            type2Combo.addItem(moveDurationTypes[i]);
        }
        type2Combo.setSelectedItem(moveDurationTypes[0]);
        move2Layout.set((UIControl)type2Combo, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)type2Combo);
        UILabel division2Label = uiFactory.createLabel((UIContainer)move2);
        division2Label.setText(TuxGuitar.getProperty("duration.division-type") + ":");
        move2Layout.set((UIControl)division2Label, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)division2Label);
        UISelectItem<int[]>[] moveDivisionTypes = this.createDivisionTypes();
        final UIDropDownSelect division2Combo = uiFactory.createDropDownSelect((UIContainer)move2);
        for (int i = 0; i < moveDivisionTypes.length; ++i) {
            division2Combo.addItem(moveDivisionTypes[i]);
        }
        division2Combo.setSelectedItem(moveDivisionTypes[0]);
        move2Layout.set((UIControl)division2Combo, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        move2Controls.add((UIControl)division2Combo);
        this.updateControls(0, move2Controls);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBeatMoveDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int directionValue = this.this$0.getDirection((UIDropDownSelect<Integer>)directionCombo);
                long duration1 = this.this$0.getDuration1((UIDropDownSelect<Integer>)duration1Combo, count1Spinner.getValue());
                long duration2 = this.this$0.getDuration2((UIDropDownSelect<Integer>)duration2Combo, (UIDropDownSelect<boolean[]>)type2Combo, (UIDropDownSelect<int[]>)division2Combo, count2Spinner.getValue());
                long duration = (duration1 + duration2) * (long)directionValue;
                dialog.dispose();
                this.this$0.moveBeats(context.getContext(), track, measure, beat, duration);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGBeatMoveDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public UISelectItem<Integer>[] createMoveDirections() {
        return new UISelectItem[]{new UISelectItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.right"), (Object)1), new UISelectItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.left"), (Object)-1)};
    }

    public UISelectItem<Integer>[] createMoveDurations() {
        return new UISelectItem[]{new UISelectItem(TuxGuitar.getProperty("duration.whole"), (Object)1), new UISelectItem(TuxGuitar.getProperty("duration.half"), (Object)2), new UISelectItem(TuxGuitar.getProperty("duration.quarter"), (Object)4), new UISelectItem(TuxGuitar.getProperty("duration.eighth"), (Object)8), new UISelectItem(TuxGuitar.getProperty("duration.sixteenth"), (Object)16), new UISelectItem(TuxGuitar.getProperty("duration.thirtysecond"), (Object)32), new UISelectItem(TuxGuitar.getProperty("duration.sixtyfourth"), (Object)64)};
    }

    public UISelectItem<boolean[]>[] createMoveDurationTypes() {
        return new UISelectItem[]{new UISelectItem(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type.normal"), (Object)new boolean[]{false, false}), new UISelectItem(TuxGuitar.getProperty("duration.dotted"), (Object)new boolean[]{true, false}), new UISelectItem(TuxGuitar.getProperty("duration.doubledotted"), (Object)new boolean[]{false, true})};
    }

    public UISelectItem<int[]>[] createDivisionTypes() {
        TGDivisionType[] types = TGDivisionType.DIVISION_TYPES;
        UISelectItem[] comboItems = new UISelectItem[types.length];
        for (int i = 0; i < types.length; ++i) {
            String name = TuxGuitar.getProperty("duration.division-type." + Integer.valueOf(types[i].getEnters()).toString());
            if (name.isEmpty()) {
                name = Integer.valueOf(types[i].getEnters()).toString();
            }
            comboItems[i] = new UISelectItem(name, (Object)new int[]{types[i].getEnters(), types[i].getTimes()});
        }
        return comboItems;
    }

    public int getDirection(UIDropDownSelect<Integer> directionCombo) {
        Integer value = (Integer)directionCombo.getSelectedValue();
        return value != null ? value : 0;
    }

    public long getDuration1(UIDropDownSelect<Integer> durationCombo, int count) {
        Integer value = (Integer)durationCombo.getSelectedValue();
        if (count > 0 && value != null) {
            TGDuration duration = new TGFactory().newDuration();
            duration.setValue(value.intValue());
            duration.setDotted(false);
            duration.setDoubleDotted(false);
            duration.getDivision().setTimes(1);
            duration.getDivision().setEnters(1);
            return duration.getTime() * (long)count;
        }
        return 0L;
    }

    public long getDuration2(UIDropDownSelect<Integer> durationCombo, UIDropDownSelect<boolean[]> typeCombo, UIDropDownSelect<int[]> divisionCombo, int count) {
        Integer value = (Integer)durationCombo.getSelectedValue();
        boolean[] type = (boolean[])typeCombo.getSelectedValue();
        int[] division = (int[])divisionCombo.getSelectedValue();
        if (count > 0 && value != null && type != null && division != null) {
            TGDuration duration = new TGFactory().newDuration();
            duration.setValue(value.intValue());
            duration.setDotted(type[0]);
            duration.setDoubleDotted(type[1]);
            duration.getDivision().setEnters(division[0]);
            duration.getDivision().setTimes(division[1]);
            return duration.getTime() * (long)count;
        }
        return 0L;
    }

    public void updateControls(int count, List<UIControl> controls) {
        for (UIControl control : controls) {
            control.setEnabled(count > 0);
        }
    }

    public void moveBeats(TGContext context, TGTrack track, TGMeasure measure, TGBeat beat, Long theMove) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.move");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute("move", (Object)theMove);
        tgActionProcessor.process();
    }
}

