/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.tab;

import app.tuxguitar.app.document.TGDocument;
import app.tuxguitar.app.document.TGDocumentListManager;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.song.helpers.TGBeatRangeIterator;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGNoteRange;
import java.util.ArrayList;
import java.util.Collection;

public class Selector {
    private final Tablature tablature;
    private TGBeat initial;
    private TGBeat start;
    private TGBeat end;
    private boolean active;

    public Selector(Tablature tablature) {
        this.tablature = tablature;
    }

    public void initializeSelection(TGBeat beat) {
        this.initial = beat;
        this.start = beat;
        this.end = beat;
        this.active = false;
        this.saveState();
    }

    public void updateSelection(TGBeat beat) {
        if (this.initial == null || beat == null) {
            this.initializeSelection(beat);
        } else {
            this.active = true;
            TGTrack track = beat.getMeasure().getTrack();
            boolean overlap = false;
            if (this.initial.getMeasure().getNumber() < beat.getMeasure().getNumber() || this.initialIsEarlierInTheSameMeasure(beat)) {
                int firstSelectabledMeasureNb;
                for (int m = firstSelectabledMeasureNb = this.initial.getMeasure().getNumber(); m < beat.getMeasure().getNumber(); ++m) {
                    if (this.measureCanBeSelected(track.getMeasure(m - 1))) continue;
                    overlap = true;
                    firstSelectabledMeasureNb = m;
                }
                if (overlap) {
                    this.initial = this.start = track.getMeasure(firstSelectabledMeasureNb).getBeat(0);
                    this.end = beat;
                } else {
                    this.start = this.initial;
                    this.end = beat;
                }
            } else {
                int lastSelectableMeasureNb;
                for (int m = lastSelectableMeasureNb = this.initial.getMeasure().getNumber(); m > beat.getMeasure().getNumber(); --m) {
                    if (this.measureCanBeSelected(track.getMeasure(m - 2))) continue;
                    overlap = true;
                    lastSelectableMeasureNb = m - 1;
                }
                if (overlap) {
                    this.start = beat;
                    this.initial = this.end = track.getMeasure(lastSelectableMeasureNb - 1).getBeat(track.getMeasure(lastSelectableMeasureNb - 1).countBeats() - 1);
                } else {
                    this.start = beat;
                    this.end = this.initial;
                }
            }
        }
    }

    public void clearSelection() {
        this.initializeSelection(null);
    }

    private boolean measureCanBeSelected(TGMeasure measure) {
        int measureNb = measure.getNumber();
        if (measureNb == measure.getTrack().countMeasures()) {
            return true;
        }
        return measure.getBeat(measure.countBeats() - 1).getPreciseStart() < measure.getTrack().getMeasure(measureNb).getBeat(0).getPreciseStart();
    }

    private boolean initialIsEarlierInTheSameMeasure(TGBeat beat) {
        return this.initial.getMeasure().getNumber() == beat.getMeasure().getNumber() && this.initial.getStart() < beat.getStart();
    }

    public TGBeat getInitialBeat() {
        return this.initial;
    }

    public TGBeat getStartBeat() {
        return this.start;
    }

    public TGBeat getEndBeat() {
        return this.end;
    }

    public boolean isActive() {
        return this.active;
    }

    public void paintSelectedArea(TGLayout viewLayout, UIPainter painter) {
        if (this.isActive()) {
            int activeTrackNumber = this.tablature.getTrackSelection();
            TGTrackImpl track = (TGTrackImpl)this.initial.getMeasure().getTrack();
            if (activeTrackNumber < 0 || activeTrackNumber == track.getNumber()) {
                track.paintBeatSelection(viewLayout, painter, this.start, this.end);
            }
        }
    }

    public TGNoteRange getNoteRange(Collection<Integer> voices) {
        return new TGNoteRange(this.start, this.end, voices);
    }

    public TGBeatRange getBeatRange() {
        if (!this.isActive()) {
            return TGBeatRange.empty();
        }
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        TGBeatRangeIterator it = new TGBeatRangeIterator(this.start, this.end);
        while (it.hasNext()) {
            beats.add(it.next());
        }
        return new TGBeatRange(beats);
    }

    private void saveState() {
        TGDocument document;
        TGDocumentListManager documents = TGDocumentListManager.getInstance(this.tablature.getContext());
        TGDocument tGDocument = document = this.initial == null ? documents.findCurrentDocument() : documents.findDocument(this.initial.getMeasure().getTrack().getSong());
        if (this.isActive()) {
            document.setSelectionStart(this.getStartBeat());
            document.setSelectionEnd(this.getEndBeat());
        } else {
            document.setSelectionStart(null);
            document.setSelectionEnd(null);
        }
    }

    public void restoreStateFrom(TGDocument document) {
        TGBeat start = document.getSelectionStart();
        TGBeat end = document.getSelectionEnd();
        if (start != null && end != null) {
            this.initializeSelection(start);
            this.updateSelection(end);
        } else {
            this.clearSelection();
        }
    }
}

